<?php

namespace App\Http\Controllers\Admin;

use App\AdminUser;
use App\functions;
use App\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Morilog\Jalali;
use DB;
use Session;
use Auth;
use App\UserFinance;
use SoulDoit\DataTable\SSP;


class FinanceController extends Controller
{
    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            if(Auth::user()->access_finance ==1 || Auth::user()->role == 'admin')
                return $next($request);
            else
                abort(404);
        });
    }

    public function index(){
        $result = array();
        return view('admin.finance',['result'=>(object)$result]);
    }


    public function list_finance(Request $request)
    {
        if(strpos($request->search['value'],"#") !== false){
            $request->id = str_replace('#','',$request->search['value']);
            $request->merge(['search' => array('value'=>$request->id,'regex'=>$request->search['regex']) ]);
        }


        $functions = new \App\functions;
        if (isset($request->date_start)) {
            $request->date_start = $functions->toLatin($request->date_start);
            $request->date_start = Jalali\CalendarUtils::createCarbonFromFormat('Y/m/d H:i', $request->date_start);
        }

        if (isset($request->date_stop)) {
            $request->date_stop = $functions->toLatin($request->date_stop);
            $request->date_stop = Jalali\CalendarUtils::createCarbonFromFormat('Y/m/d H:i', $request->date_stop);
        }

        $dt = [
            ['db' => 'id', 'dt' => 0],

            ['db' => 'user.family', 'dt' => 22],
            ['db' => 'id_order', 'dt' => 44],
            ['db' => 'user.mobile', 'dt' => 55],

            ['db' => 'user.name', 'dt' => 1],
            ['db' => 'type', 'dt' => 2, 'formatter' => function ($value, $model) {
                $str = '';
                if($model->id_order){
                    $str = ' - سفارش';
                }
                if($value == 'واریز'){
                    return '<span class="text-success">واریز'.$str.' <i class="ft-trending-up"></i></span>';
                }
                else{
                    return '<span class="text-danger">برداشت'.$str.' <i class="ft-trending-down"></i></span>';
                }
                return number_format($value);
            }],
            ['db' => 'amount', 'dt' => 3, 'formatter' => function ($value, $model) {
                if($model->type == 'واریز')
                    return number_format($value);
                else
                    return number_format($value);
            }],
            ['db' => 'stock', 'dt' => 4, 'formatter' => function ($value, $model) {
                return number_format($value);
            }],
            ['db' => 'users_finance.created_at', 'dt' => 5, 'formatter' => function ($value, $model) {
                return  Jalali\CalendarUtils::strftime('d F Y - H:i', strtotime($value));;
            }],
            ['db' => 'users_finance.description', 'dt' => 6, 'formatter' => function ($value, $model) {
                if($model->id_order)
                    return "<a class='typo_link text-info' href='".asset('').env('PanelPrefix').'/orders/'.$model->id_order."'>".$value."</a>";
                else
                    return $value;
            }],
            ['db' => 'status', 'dt' => 7, 'formatter' => function ($value, $model) {
                if($value =='در دست اقدام')
                    return '<span class="badge badge-pill bg-warning font-weight-light">'.$value.'</span>';
                elseif($value =='معلق,پرداخت شده' || $value =='معلق,عودت') {
                    return '<span class="badge badge-pill bg-dark font-weight-light">معلق</span>
                            <span class="badge badge-pill bg-success font-weight-light">' .substr($value, strpos($value, ",") + 1). '</span>';
                }
                elseif($value =='رد شده' ) {
                    return '<span class="badge badge-pill bg-danger font-weight-light">رد شده</span>';
                }elseif($value =='ناموفق' ) {
                    return '<span class="badge badge-pill bg-danger m-1">ناموفق</span>';
                }elseif($value =='معلق' ) {
                    return '<span class="badge badge-pill bg-dark m-1">معلق</span>';
                }else
                    return '<span class="badge badge-pill bg-success font-weight-light">'.$value.'</span>';
            }],
            ['db' => 'users_finance.id', 'dt' => 8, 'formatter' => function ($value, $model) {
                return '<button type="button"  class="btn btn-light btn-sm"
                        onclick="Info('.$value.')"  data-bs-toggle="modal" data-bs-target="#Info">جزئیات</button>';
            }],

        ];


        $my_ssp = (new SSP('\App\UserFinance', $dt, 'table_name'))->where(function ($query) {
            if (isset(request()->id_user)) {
                $query->where('users_finance.id_user', request()->id_user);
            }

            if (isset(request()->id)) {
                $query->where('users_finance.id', request()->id);
            }

            if (isset(request()->admin)) {
                $query->where('users_finance.id_admin', request()->admin);
            }

            if (isset(request()->model)) {
                $query->where('users_finance.type', request()->model);
            }

            if (isset(request()->date_start)) {
                $query->where('users_finance.created_at', '>', request()->date_start);
            }

            if (isset(request()->date_stop)) {
                $query->where('users_finance.created_at', '<', request()->date_stop);
            }

            if (isset(request()->status)) {
                $query->where('users_finance.status', request()->status);
            }

            if (isset(request()->amount_start)) {
                $amount_start = str_replace(',','',request()->amount_start);
                $query->where('users_finance.amount', '>=', $amount_start);
            }

            if (isset(request()->amount_stop)) {
                $amount_stop = str_replace(',','',request()->amount_stop);
                $query->where('users_finance.amount', '<=', $amount_stop);
            }

            if (isset(request()->bank_name) && request()->bank_name != '') {
                if(request()->bank_name == 'غیر ملت')
                    $query->where('users_cardbank.bank_name','!=','بانک ملت');
                else
                    $query->where('users_cardbank.bank_name',request()->bank_name);
            }

        });
        if (isset(request()->bank_name) && request()->bank_name != '')
            $my_ssp->leftJoin('users_cardbank', 'users_finance.id_cardbank','users_cardbank.id');

        $my_ssp->leftJoin('users AS user', 'users_finance.id_user','user.id');

        return response()->json($my_ssp->getDtArr());
    }


    public function single_finance(Request $request){

        $result = (object)array();
        $result->finance = \App\UserFinance::find($request->id);
        $result->update = Jalali\CalendarUtils::strftime('d F Y ساعت H:i', strtotime($result->finance->updated_at));

        $result->FinotechSendMoney = \App\FinotechSendMoney::where('id_order',$request->id)->first();
        $user = User::find($result->finance->id_user);
        $result->user = $user;

        if(isset($result->finance->id_admin)){
            $result->admin = \App\AdminUser::find($result->finance->id_admin);
        }

        $result->cardbank = \App\CardBank::find($result->finance->id_cardbank);
        $result->FinotechSendMoney = \App\FinotechSendMoney::where('id_finance',$result->finance->id)->first();

        return view('admin.finances.finance-single',['result'=>$result]);

    }


    public function confirm_finance(Request $request){
        $functions = new \App\functions;

        $finance = \App\UserFinance::find($request->id);
        if ($finance) {
            $finance->payment = $finance->amount;
            $finance->status = 'واریز شده';
            $finance->description = 'از طریق '.$request->via.' واریز شد';
            $finance->id_admin = Auth::user()->id;

            // اگر ادمین درخواست واریز اتوماتیک داشت
            if ($request->autoDeposit == 'true'):
                $sendMoney = $functions->FinotechSendMoney($finance->id_cardbank,$finance->amount,$finance->id_user,null,$finance->id);
                if($sendMoney->status != true){
                    return response()->json($sendMoney);
                }
            endif;
            $finance->save();


            $user = User::find($finance->id_user);
            try{
                \Kavenegar::VerifyLookup($user->mobile,number_format($finance->amount),str_replace(' ', '‌',$request->via),null,'settle');
            }
            catch (\Exception $ex){}

            $functions->LogAdmin('تایید و واریز به حساب برای درخواست برداشت: '.$user->mobile,'finance');

            if(isset($user->firebase_token))
                $functions->send_notification('واریز به حساب',$user->family.' عزیز، مبلغ '.$finance->amount.' به حساب شما '.$request->via.' شد.',$user->firebase_token);


            $result = array('status' => true , 'message' => 'وضعیت با موفقیت تغییر یافت');
        } else
            $result = array('status' => false , 'message' => 'خطا در ارسال پارامتر');
        return response()->json($result);

    }

    public function reject_finance(Request $request){

        $finance = \App\UserFinance::find($request->id);
        if ($finance) {
            DB::beginTransaction();
            try {
                \App\User::find($finance->id_user)->increment('wallet',$finance->amount);

                $finance->status = 'رد شده';
                $finance->description = $request->reason;
                $finance->id_admin = Auth::user()->id;
                $finance->save();
                $result = array('status' => true , 'messege' => 'وضعیت با رد شد و به کیف پول کاربر اضافه شد!');

                $user = User::find($finance->id_user);
                $functions = new \App\functions;
                $functions->LogAdmin('رد درخواست برداشت از کیف پول برای درخواست برداشت: '.$user->mobile,'finance');

                DB::commit();
            } catch (\Exception $e) {
                DB::rollback();
                $result = array('status' => false, 'message' => 'عملیات دچار مشکل شد');
            }
        } else
            $result = array('status' => false , 'messege' => 'خطا در ارسال پارامتر');
        return response()->json($result);
    }



    public function return_amount(Request $request)
    {
        $finance = \App\UserFinance::find($request->id);
        if ($finance) {

            $date = Jalali\Jalalian::forge('today')->format('%d %B %Y');

            $user = User::find($finance->id_user);

            $finance->status = 'معلق,عودت';
            $finance->description = 'وجه در تاریخ '.$date.' عودت داده شد ';
            $finance->id_admin = Auth::user()->id;

            if($request->wallet == 1){
                \App\User::find($user->id)->increment('wallet',$finance->amount);
                $finance->description .='و به کیف پول افزوده شد.';
                $finance->stock = $finance->stock + $finance->amount;
                $result = array('status' => true , 'messege' => 'با موفقیت عودت و به کیف پول کاربر اضافه شد.');
            }else
                $result = array('status' => true , 'messege' => 'با موفقیت وضعیت به عودت تغییر یافت.');

            $finance->save();

        } else
            $result = array('status' => false , 'messege' => 'خطا در ارسال پارامتر');
        return response()->json($result);
    }


    public function hesab_format(Request $request)
    {
        $IDs = explode(',',$request->IDs);
        $finances = UserFinance::whereIn('id',$IDs)->where('status','در دست اقدام')->whereNotNull('id_cardbank')->get();

        //echo '0000000002000000000400000'.'<br>';
        $sum = 0;
        $string = '';
        foreach ($finances as $finance) {
            $user = User::select('mobile','name','family')->find($finance->id_user);

            $CardBank = \App\CardBank::find($finance->id_cardbank);
            $string .= str_pad($CardBank->account_number, 10, "0", STR_PAD_LEFT);
            $string .= str_pad($finance->amount, 15, "0", STR_PAD_LEFT);
            $string .= str_pad($user->mobile, 17, "0", STR_PAD_LEFT);
            $string .= str_pad('', 30, " ", STR_PAD_LEFT);
            //$string .= str_pad($user->name.' '.$user->family, 30, " ", STR_PAD_LEFT);
            $string .= '<br>
';
            $sum += $finance->amount;
        }

        $FristLine = str_pad(count($finances), 10, "0", STR_PAD_LEFT);
        $FristLine .= str_pad($sum, 15, "0", STR_PAD_LEFT);

        $date = Jalali\Jalalian::forge('now')->format('Ymd');

        echo "<div id='text'>".$FristLine.'<br>
'.$string."</div>";


        echo '
        <script>
        if (\'Blob\' in window) {
            var fileName = "ELFL'.$date.'";
            var text = document.getElementById("text").textContent;
            if (fileName) {
              var textFileAsBlob = new Blob([text], { type: \'text/plain\' });

              if (\'msSaveOrOpenBlob\' in navigator) {
                navigator.msSaveOrOpenBlob(textFileAsBlob, fileName);
              } else {
                var downloadLink = document.createElement(\'a\');
                downloadLink.download = fileName;
                downloadLink.innerHTML = \'Download File\';

                if (\'webkitURL\' in window) {
                  // Chrome allows the link to be clicked without actually adding it to the DOM.
                  downloadLink.href = window.webkitURL.createObjectURL(textFileAsBlob);
                } else {
                  // Firefox requires the link to be added to the DOM before it can be clicked.
                  downloadLink.href = window.URL.createObjectURL(textFileAsBlob);
                  downloadLink.click(function(){
                    document.body.removeChild(event.target);
                  });

                  downloadLink.style.display = \'none\';
                  document.body.appendChild(downloadLink);
                }
                downloadLink.click();
              }
            }
          } else {
            alert(\'Your browser does not support the HTML5 Blob Or auto create file and download.\');
          }
        </script>';

    }
    public function shaba_format(Request $request)
    {
        $IDs = explode(',',$request->IDs);
        $finances = UserFinance::whereIn('id',$IDs)->where('status','در دست اقدام')->whereNotNull('id_cardbank')->get();

        //echo '0000000002000000000400000'.'<br>';
        $sum = 0;
        $string = '';
        foreach ($finances as $finance) {
            $user = User::select('mobile','name','family')->find($finance->id_user);

            $CardBank = \App\CardBank::find($finance->id_cardbank);
            $string .= 'IR'.$CardBank->shaba.',';
            $string .= $user->mobile.',';
            $string .= $finance->amount.',';
            $string .= $user->code_meli.',';
            $string .= $user->name.' '.$user->family.',';
            $string .= 'برداشت از موجودی'.',';

            $string .= '<br>
';
            $sum += $finance->amount;
        }


        $date = Jalali\Jalalian::forge('now')->format('Ymd');

        echo "<div id='text'>".$string."</div>";


        echo '
        <script>
        if (\'Blob\' in window) {
            var fileName = "ELFL'.$date.'";
            var text = document.getElementById("text").textContent;
            if (fileName) {
              var textFileAsBlob = new Blob([text], { type: \'text/plain\' });

              if (\'msSaveOrOpenBlob\' in navigator) {
                navigator.msSaveOrOpenBlob(textFileAsBlob, fileName);
              } else {
                var downloadLink = document.createElement(\'a\');
                downloadLink.download = fileName;
                downloadLink.innerHTML = \'Download File\';

                if (\'webkitURL\' in window) {
                  // Chrome allows the link to be clicked without actually adding it to the DOM.
                  downloadLink.href = window.webkitURL.createObjectURL(textFileAsBlob);
                } else {
                  // Firefox requires the link to be added to the DOM before it can be clicked.
                  downloadLink.href = window.URL.createObjectURL(textFileAsBlob);
                  downloadLink.click(function(){
                    document.body.removeChild(event.target);
                  });

                  downloadLink.style.display = \'none\';
                  document.body.appendChild(downloadLink);
                }
                downloadLink.click();
              }
            }
          } else {
            alert(\'Your browser does not support the HTML5 Blob Or auto create file and download.\');
          }
        </script>';

    }



    public function remove(Request $request)
    {
        $UserFinance = \App\UserFinance::where('id', $request->id)->where('status', 'معلق')->first();
        if ($UserFinance) {
            try {
                if ($UserFinance->delete())
                    $result = array('status' => true, 'messege' => 'با موفقیت حذف شد');

            } catch (\Illuminate\Database\QueryException $e) {
                $result = array('status' => false, 'messege' => 'حذف امکان پذیر نیست');
            }

        } else
            $result = array('status' => false, 'messege' => 'خطا در ارسال پارامتر');
        return response()->json($result);
    }
}
