<?php

namespace App\Http\Controllers\Admin;

use App\Cryptocurrency;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Settings;
use Auth;
use DB;
class SettingsController extends Controller
{
    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            if(Auth::user()->access_settings == 1 || Auth::user()->role == 'admin')
                return $next($request);
            else
                abort(404);
        });
    }

    public function index(){
        //
    }

    public function GeneralSettings(){

        $result = array();
        $settings = Settings::all();

        foreach($settings as $settings){
            $result[$settings->name] =  $settings->value;
        }
        //return response()->json($result);
        return view('admin.settings.settings',['result'=>(object)$result]);

    }

    public function PaymentSettings(){

        $result = array();
        $settings = Settings::all();

        foreach($settings as $settings){
            $result[$settings->name] =  $settings->value;
        }

        //return response()->json($result);
        return view('admin.settings.payment-settings',['result'=>(object)$result]);

    }

    public function CryptoSettings(){

        $result = new \stdClass();
        $settings = Settings::all();

        foreach($settings as $settings){
            $result->{$settings->name} =  $settings->value;
        }

        $functions = new \App\functions;
        $cryptocurrencies = \App\Cryptocurrency::all();

        foreach($cryptocurrencies as $cryptocurrency) {

        }
        //return response()->json($result);
        return view('admin.settings.crypto-settings', compact(['cryptocurrencies','result']));

    }

    public function ApiSettings(){

        $result = array();
        $settings = Settings::all();

        foreach($settings as $settings){
            $result[$settings->name] =  $settings->value;
        }

        return view('admin.settings.api-settings',['result'=>(object)$result]);

    }

    function insert(Request $request)
    {
        $validator = \Validator::make($request->all(), [
            'name' => 'required',
            'name_fa' => 'required',
            'symbol' => 'required',
            'min_buy' => 'required',
            'percent' => 'required',
            'destination_tag' => 'required',
        ], [
            'name.required' => 'نام را مشخص کنید',
            'name_fa.required' => 'نام فارسی را مشخص کنید',
            'symbol.required' => 'نماد را مشخص کنید',
            'min_buy.required' => 'حداقل خرید را مشخص کنید',
            'percent.required' => 'درصد را مشخص کنید',
            'destination_tag.required' => 'تگ برچسب را مشخص کنید',
        ]);

        if ($validator->fails()) {
            $result = array('status' => false, 'message' => $validator->errors()->first());
            return response()->json($result);
        }


        DB::beginTransaction();
        try {
            $cryptocurrency = new Cryptocurrency;
            $cryptocurrency->name = $request->name;
            $cryptocurrency->name_fa = $request->name_fa;
            $cryptocurrency->symbol = strtoupper($request->symbol);
            $cryptocurrency->min_buy = $request->min_buy;
            $cryptocurrency->percent = $request->percent;
            try {
                $request->file('logo')->move(LARAVEL_PUBLIC_DIR . '/app-assets/images/currency/', strtolower($request->name) . '.svg');
            } catch(\Throwable $e){}

            $cryptocurrency->save();

            DB::commit();
            $result = array('status' => true, 'message' => 'ارز با موفقیت اضافه شد');
            return response()->json($result);

        } catch (\Exception $e) {
            DB::rollback();
            $result = array('status' => false, 'message' => 'عملیات دچار مشکل شد' . $e);
        }

        return response()->json($result);
    }

    public function Crypto_destroy(Request $request)
    {
        $cryptocurrency = Cryptocurrency::query()->find($request->id);

        try {
            if($cryptocurrency->delete())
                $result = array('status' => true , 'messege' => 'با موفقیت حذف شد');
        } catch (\Illuminate\Database\QueryException $e) {
            $result = array('status' => false , 'messege' => 'حذف امکان پذیر نیست');
        }

        return response()->json($result);
    }


    public function save(Request $request){
        if ($request->get('_type', false))
            return $this->insert($request);

        if ($request->get('coin_id', false))
            return $this->updateCoin($request);

        if ($request->get('edit_coinId', false))
            return $this->editCoin($request);

        foreach($request->request as $key => $value){
            $request[$key] =  str_replace(',','',$request[$key]);
        }

        $validator = \Validator::make($request->all(), [
            //'payment_gateway' => 'required',
            //'min_buy'=> 'required',
        ]);
        if ($validator->fails() != 1):

            $functions = new \App\functions;
//            getSetting('AutomaticDeposit', false)->update(['value'=>json_encode($functions->toLatin($request->time))]);

            $popup = array('show'=>$request->ActivePopup?$request->ActivePopup:false,'url'=>'storage/popup.txt','name'=> time() , 'perDay'=>$request->perDayPopup);
            $Settings = getSetting('popup', false);
            $Settings->value = json_encode($popup);
            //file_put_contents('storage/popup.txt',  str_replace(';base64',';base64,',$request->TextPopup));
            file_put_contents(storage_path('popup.txt'),  str_replace(';base64',';base64,',$request->TextPopup));
            $Settings->save();

            if($request->hasFile('logo')){
                $request->file('logo')->move(LARAVEL_PUBLIC_DIR . '/images/logo/', 'logo.svg');
            }

            if($request->hasFile('logo-light')){
                $request->file('logo-light')->move(LARAVEL_PUBLIC_DIR . '/images/logo/', 'logo-light.svg');
            }

            if($request->hasFile('logo-dark')){
                $request->file('logo-dark')->move(LARAVEL_PUBLIC_DIR . '/images/logo/', 'logo-dark.svg');
            }

            if($request->hasFile('favicon')){
                $request->file('favicon')->move(LARAVEL_PUBLIC_DIR . '/images/logo/', 'favicon.svg');
            }

            foreach($request->request as $key => $value){
                $Settings = getSetting($key, false);
                if(isset($Settings)){
                    $Settings->value = $value;
                    $Settings->save();
                }else{
                    $Settings = new Settings();
                    $Settings->name = $key;
                    $Settings->value = $value;
                    $Settings->save();
                }
            }

            $functions->LogAdmin('تغییر در تنظیمات ','editSettings');

            $result = array('status' => true, 'message' => 'با موفقیت تغییر یافت');
        else:
            $result = array('status' => false, 'message' => $validator->errors()->first());
            //$result = array('status' => false, 'message' => 'داده های درج شده درست نیست');
        endif;
        return response()->json($result);
    }

    public function editCoin ($request) {
        try {
            DB::beginTransaction();
            $crypto_currency = Cryptocurrency::find($request->get('edit_coinId'));
            $crypto_currency->min_buy = $request->get('min_buy');
            $crypto_currency->destination_tag = $request->get('destination_tag');
            $crypto_currency->symbol = $request->get('symbol');
            $crypto_currency->name_fa = $request->get('name_fa');
            $crypto_currency->name = $request->get('name');
            $crypto_currency->save();
            DB::commit();

            $functions = new \App\functions;
            $functions->LogAdmin('تغییر در ویرایش ارز' . $crypto_currency->name_fa,'settingsCoin');

            $result = [
                'status' => true,
                'message' => 'با موفقیت ویرایش شد '
            ];
        }catch (\Exception $e) {
            DB::rollback();
            $result = [
                'status' => false,
                'message' => 'عملیات دچار مشکل شد' . $e
            ];
        }
        return response()->json($result);
    }

    public function updateCoin ($request) {
        try {
            DB::beginTransaction();
            $crypto_currency = Cryptocurrency::find($request->get('coin_id'));
            $crypto_currency->forceFill([
                'address_wallet' => $request->get('address_wallet'),
                'buy_status' => $request->get('buy_status'),
                'sell_status' => $request->get('sell_status'),
                'stock_api' => $request->get('stock_api') == 'on' ? 1 : 0,
                'stock' => $request->get('stock'),
                'percent_coin' => $request->get('percent_coin'),
                'transfer_fee' => $request->get('transfer_fee'),
            ]);
            $crypto_currency->save();
            DB::commit();

            $functions = new \App\functions;
            $functions->LogAdmin('تغییر در تنظیمات ارز' . $crypto_currency->name_fa,'settingsCoin');

            $result = [
                'status' => true,
                'message' => 'با موفقیت تغییر یافت'
            ];
        }catch (\Exception $e) {
            DB::rollback();
            $result = [
                'status' => false,
                'message' => 'عملیات دچار مشکل شد' . $e
            ];
        }
        return response()->json($result);
    }
}
