<?php

namespace App\Http\Controllers\Admin;

use Morilog\Jalali;
use App\ProductOrder;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;

class ShopOrderController extends Controller
{
    public function index()
    {
        $orders = ProductOrder::query()
            ->select('id', 'user_id', 'final_price', 'status', 'payment_method', 'created_at')
            ->with(['user' => function($query) {
                return $query->select(['id', 'name', 'family']);
            }])
            ->orderBy('updated_at', 'desc')
            ->paginate(10);

        if(isset($orders))
            foreach ($orders as $order)
                $order->date = Jalali\CalendarUtils::strftime('H:i Y/m/d', strtotime($order->created_at));

        return view('admin.orders.shop-orders', ['orders' => $orders]);
    }

    public function single($orderId)
    {
        $order = ProductOrder::query()
            ->where('product_orders.id', $orderId)
            ->select([
                'product_orders.id',
                'product_orders.user_id',
                'product_orders.price',
                'product_orders.final_price',
                'product_orders.quantity',
                'product_orders.status',
                'product_orders.delivery_price',
                'product_orders.payment_method',
                'product_orders.admin_note',
                'product_orders.created_at',
                'users.id as userId',
                'users.name as userName',
                'users.family as userFamily',
                'products.title as productTitle',
                'products.image as productImage',
            ])
            ->leftJoin('users', 'users.id', 'product_orders.user_id')
            ->leftJoin('products', 'products.id', 'product_orders.product_id')
            ->first();

        if(isset($order)) {
            $order->date = Jalali\CalendarUtils::strftime('H:i Y/m/d', strtotime($order->created_at));
            $order->price = number_format($order->price);
            $order->final_price = number_format($order->final_price);
            $order->delivery_price = number_format($order->delivery_price);
        }

        return response()->json(['data' => $order]);
    }

    public function adminNote(Request $request)
    {
        $orderId = $request->get('id');

        $validator = Validator::make($request->all(),
            [
                'note' => 'required|string',
            ],
            [
                'note.required' => 'فیلد توضیحات نمیتواند خالی باشد.',
                'note.string' => 'فیلد توضیحات باید متن باشد.',
            ]
        );

        if ($validator->fails()) {
            $result = array('status' => false, 'message' => $validator->errors()->first());
            return response()->json($result);
        }

        $order = ProductOrder::query()->find($orderId);

        $order->admin_note  = $request->get('note');
        $order->status  = 'done';
        $order->save();

        $result = array('status' => true, 'message' => 'سفارش نهایی شد');
        return response()->json($result);

//        return response()->json(['code' => '200']);
    }
}
