<?php

namespace App\Http\Controllers\User;

use App\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Morilog\Jalali;
use DB;
use Session;
use App\Orders;
use App\functions;

class OrdersController extends Controller
{
    public function index(){

        $functions = new \App\functions;
        $orders = \App\Orders::query()
            ->select('orders.id', 'orders.orders_model', 'orders.type', 'orders.amount', 'orders.created_at', 'orders.status', 'orders_cryptocurrency.amount_coin')
            ->leftJoin('orders_cryptocurrency', 'orders.id', '=', 'orders_cryptocurrency.id_order')
            ->where('orders.id_user', Auth::user()->id)
            ->get();

        foreach ($orders as $order){
            $order->date = Jalali\CalendarUtils::strftime('H:i Y/m/d', strtotime($order->created_at));
        }

        return view('user.orders.orders', ['orders'=>$orders]);
    }

    public function open_orders(){

        $functions = new \App\functions;
        $orders = \App\Orders::query()
            ->select('orders.id', 'orders.orders_model', 'orders.type', 'orders.amount', 'orders.created_at', 'orders.status', 'orders_cryptocurrency.amount_coin')
            ->leftJoin('orders_cryptocurrency', 'orders.id', '=', 'orders_cryptocurrency.id_order')
            ->where('orders.id_user', Auth::user()->id)
            ->whereIn('orders.status', ['معلق', 'پرداخت شده'])
            ->get();

        foreach ($orders as $order){
            $order->date = Jalali\CalendarUtils::strftime('H:i Y/m/d', strtotime($order->created_at));
        }

        return view('user.orders.open-orders', ['orders'=>$orders]);
    }

    public function single(Request $request){
        $order = \App\Orders::where('id',$request->id)->where('id_user',Auth::user()->id)->where('status','!=','معلق')->first();
        if($order) {
            $result = (object)array();
            $functions = new functions;
            $order->detail = $functions->get_order_detail($order->id);
            $order->date = Jalali\CalendarUtils::strftime('d F Y ساعت H:i', strtotime($order->created_at));
            if(isset($order->id_cardbank)){
                $order->cardbank = \App\CardBank::find($order->id_cardbank);
            }
            if ($order->id_cardother){
                $order->cardother = \App\OrdersCardBank::find($order->id_cardother);
            }
            $result->order = $order;

            $user = User::find($order->id_user);
            $provinces = isset($user->id_province) ? \App\provinces::find($user->id_province)->title : '';
            $city = isset($user->id_city) ? \App\cities::find($user->id_city)->title : '';
            $user->address = isset($user->address) ? $provinces.' - '.$city.' - '.$user->address :'';
            $result->user = $user;

            $cryptocurrency = \App\Cryptocurrency::all()->pluck('name')->toArray();
            $orders_model = $order->orders_model;
            if (in_array($orders_model, $cryptocurrency)){
                $result->orders_model = DB::table('orders_cryptocurrency')->where('id_order',$order->id)->first();
                $result->crypto =  DB::table('cryptocurrency')->where('name',$order->orders_model)->first();
            }
            else
                $result->orders_model = DB::table('orders_'.strtolower($order->orders_model))->where('id_order',$order->id)->first();

            if(isset($result->orders_model))
                if (in_array($orders_model, $cryptocurrency))
                    return view('user.orders.single-cryptocurrency', ['result'=>$result]);
                else
                    return view('user.orders.single-' . $order->orders_model, ['result'=>$result]);
            else{
                $result->BackStock = \App\UserFinance::where('id_user',$user->id)->where('id_order',$order->id)->where('type','واریز')->first();
                return view('user.orders.single-error', ['result'=>$result]);
            }

        }else
            abort(404);
    }

    public function comment_add(Request $request){

        $comment = \App\Comment::where('id_order',$request->id)->first();
        if(isset($comment)){
            $result = array('status' => false, 'message' => "قبلا نظر شما برای این سفارش ثبت شده است!");
            return response()->json($result);
        }
        $comment = new \App\Comment;
        $comment->id_order = $request->id;
        $comment->id_user = Auth::user()->id;
        $comment->comment = $request->comment;
        $comment->rate = $request->rate;
        $comment->save();
        $result = array('status' => true, 'message' => "نظر شما با موفقت ثبت شد");
        return response()->json($result);
    }
}
