<?php

namespace App\Http\Controllers\User;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Auth;
use App\Ticket;
use App\TicketMessage;
use DB;
use Morilog\Jalali;

class TicketController extends Controller
{
    function index()
    {
        $functions = new \App\functions;
        $orders = \App\Orders::select('id','created_at')
            ->where('id_user',Auth::user()->id)
            ->where('status','!=','معلق')
            ->orderBy('updated_at','desc')
            ->limit(10)
            ->get();
        foreach ($orders as $order){
            $order->detail = $functions->get_order_detail($order->id);
            $order->date = Jalali\CalendarUtils::strftime('H:i Y/m/d', strtotime($order->created_at));
        }

        $functions = new \App\functions;
        $tickets = \App\Ticket::select('id','title','unit','seen_user','created_at','status','updated_at')
            ->where('id_user',Auth::user()->id)
            ->latest('updated_at')
            ->get();
        foreach ($tickets as $ticket) {
            $ticket->created_at = Jalali\CalendarUtils::strftime('H:i Y/m/d', strtotime($ticket->created_at));
            $ticket->updated_at = Jalali\CalendarUtils::strftime('H:i Y/m/d', strtotime($ticket->updated_at));
        }

        return view('user.ticket', compact(['tickets', 'orders']));
    }

    function ticketIndex()
    {

        $functions = new \App\functions;
        $tickets = \App\Ticket::select('id','created_at')->where('id_user',Auth::user()->id)->get();

        return view('user.ticket',['tickets' => $tickets]);
    }

    function insert(Request $request)
    {
        $validator = \Validator::make($request->all(), [
            'subject' => 'required',
            'unit' => 'required',
            'order' => 'numeric|nullable',
            'message' => 'required',
            'file' => 'nullable|mimes:jpg,jpeg,png,pdf,doc,,docx,,zip,rar|max:20500',
        ], [
            'subject.required' => 'موضوع را مشخص کنید',
            'unit.required' => 'واحد را انتخاب کنید',
            'message.required' => 'پیغام خود را درج کنید',
            'file.mimes' => 'فرمت فایل مناسب نیست',
            'file.max' => 'حداکثر مجاز حجم فایل 20 مگابایت است',
        ]);

        if ($validator->fails()) {
            $result = array('status' => false, 'message' => $validator->errors()->first());
            return response()->json($result);
        }

        DB::beginTransaction();
        try {
            $ticket = new Ticket;
            $ticket->title = $request->subject;
            $ticket->unit = $request->unit;
            $ticket->id_order = $request->order;
            $ticket->id_user = Auth::user()->id;
            $ticket->save();

            $ticket_message = new TicketMessage;
            $ticket_message->id_ticket = $ticket->id;
            $ticket_message->message = $request->message;
            $ticket_message->save();

            if (isset($request->file)){

                //save image
                $file = $request->file('file');
                $extension = $file->getClientOriginalExtension();
                $just_name = str_replace(" ", "-", pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME));
                $just_name_hash = str_replace("/", "",bcrypt($just_name  .time()));
                $name = $just_name_hash.'.'.$extension;


                $directory = 'uploads/Users/'. Auth::user()->created_at->year.'/'. Auth::user()->created_at->month.'/'.  Auth::user()->id;
                $file_path = $directory .'/Ticket/'. $name;
                if (!file_exists(($file_path))) {
                    \File::makeDirectory($directory.'/Ticket/', $mode = 0777, true, true);
                    if($request->file('file')->move($directory.'/Ticket/',$name)){
                        $ticket_message->file_link = $directory . '/Ticket/' .$name;
                    }
                } else {
                    if($request->file('file')->move($directory.'/Ticket/',$just_name_hash.time() . '.' . $extension)){
                        $ticket_message->file_link = $directory . '/Ticket/' .$just_name_hash.time() . '.' . $extension;
                    }
                }
                $ticket_message->save();
            }

            DB::commit();
            $result = array('status' => true, 'message' => 'تیکت شما با موفقیت ثبت شد','id'=>$ticket->id);
            return response()->json($result);

        } catch (\Exception $e) {
            DB::rollback();
            $result = array('status' => false, 'message' => 'عملیات دچار مشکل شد' . $e);
        }
    }





    function singleIndex(Request $request)
    {
        $ticket = Ticket::where('id',$request->id)->where('id_user',Auth::user()->id)->first();
        if($ticket){
            $ticket->seen_user = 1;
            $ticket->timestamps = false;
            $ticket->save();

            $ticket->created = Jalali\CalendarUtils::strftime('Y/m/d H:i', strtotime($ticket->created_at));
            $ticket->updated = Jalali\CalendarUtils::strftime('Y/m/d H:i', strtotime($ticket->updated_at));

            $ticket_message = TicketMessage::where('id_ticket',$ticket->id)->orderBy('created_at')->get();
            foreach($ticket_message as $message){
                if(date('Y-m-d H:i:s') <date('Y-m-d H:i:s',strtotime('+6 day', strtotime($message->created_at))) ) {
                    $message->time = Jalali\Jalalian::forge($message->created_at)->ago();
                }else {
                    $message->time = Jalali\CalendarUtils::strftime('Y/m/d H:i', strtotime($message->created_at));
                    $message->class = 'sans-serif ltr-dir';
                }
            }

            if(isset($ticket->id_order)){
                $order = \App\Orders::where('id',$ticket->id_order)->first();
                $functions = new \App\functions;
                $detail = $functions->get_order_detail($order->id);

                $order->title =$detail->type .' '. $detail->title;
                $data["order"] = $order;
            }


            $data["ticket"] = $ticket;
            $data["ticket_message"] = $ticket_message;
        }else
            abort(404);


        $data['pageConfigs'] = [
            'pageHeader' => false,
            'bodyClass' => 'chat-application',
        ];

        return view('user.ticket-single',$data);
    }

    function single(Request $request)
    {
        $validator = \Validator::make($request->all(), [
            'message' => 'required',
            'file' => 'nullable|mimes:jpg,jpeg,png,pdf,doc,,docx,,zip,rar|max:20500',
        ], [
            'message.required' => 'پیغام خود را درج کنید',
            'file.mimes' => 'فرمت فایل مناسب نیست',
            'file.max' => 'حداکثر مجاز حجم فایل 20 مگابایت است',
        ]);

        if ($validator->fails()) {
            $result = array('status' => false, 'message' => $validator->errors()->first());
            return response()->json($result);
        }

        $ticket = Ticket::where('id',$request->id)->where('id_user',Auth::user()->id)->where('status','!=',3)->first();
        if($ticket):

            DB::beginTransaction();
            try {
                $ticket_message = new TicketMessage;
                $ticket_message->id_ticket = $request->id;
                $ticket_message->message = $request->message;
                $ticket_message->save();

                if (isset($request->file)){

                    //save image
                    $file = $request->file('file');
                    $extension = $file->getClientOriginalExtension();
                    $just_name = str_replace(" ", "-", pathinfo($file->getClientOriginalName(), PATHINFO_FILENAME));
                    $just_name_hash = str_replace("/", "",bcrypt($just_name  .time()));
                    $name = $just_name_hash.'.'.$extension;


                    $directory = 'uploads/Users/'. Auth::user()->created_at->year.'/'. Auth::user()->created_at->month.'/'.  Auth::user()->id;
                    $file_path = $directory .'/Ticket/'. $name;
                    if (!file_exists(($file_path))) {
                        \File::makeDirectory($directory.'/Ticket/', $mode = 0777, true, true);
                        if($request->file('file')->move($directory.'/Ticket/',$name)){
                            $ticket_message->file_link = $directory . '/Ticket/' .$name;
                        }
                    } else {
                        if($request->file('file')->move($directory.'/Ticket/',$just_name_hash.time() . '.' . $extension)){
                            $ticket_message->file_link = $directory . '/Ticket/' .$just_name_hash.time() . '.' . $extension;
                        }
                    }
                    $ticket_message->save();
                }

                $ticket->seen_admin = 0;
                $ticket->status = 0;
                $ticket->save();

                DB::commit();
                $result = array('status' => true, 'message' => 'تیکت شما با موفقیت ثبت شد');
                return response()->json($result);

            } catch (\Exception $e) {
                DB::rollback();
                $result = array('status' => 'false', 'message' => 'عملیات دچار مشکل شد' . $e);
            }
        else:
            $result = array('status' => 'false', 'message' => 'امکان پذیر نیست');
        endif;
        return response()->json($result);
    }

}
