<?php

namespace App\Http\Middleware;

use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken as Middleware;

class VerifyCsrfToken extends Middleware
{
    /**
     * Indicates whether the XSRF-TOKEN cookie should be set on the response.
     *
     * @var bool
     */
    protected $addHttpCookie = true;

    /**
     * The URIs that should be excluded from CSRF verification.
     *
     * @var array
     */
    protected $except = [
        'perfectmoney/sell/success',
        'perfectmoney/sell/failure',
        'perfectmoney/buy-product/*',
        'perfectmoney/buy/*',
        'wallet/callback',
        'wallet/callback/*',
        'PSVouchers/buy/*/callback',
        'PMvoucher/buy-product/*/callback',
        'PMvoucher/buy/*/callback',
        'paypal/buy-product/*/callback',
        'paypal/buy/*/callback',
        'skrill/buy-product/*/callback',
        'skrill/buy/*/callback',
        'webmoney/buy-product/*/callback',
        'webmoney/buy/*/callback',
        'bitcoin/buy/*/callback',
        'ethereum/buy/*/callback',
        'ripple/buy/*/callback',
        'tether/buy/*/callback',

        'api/v1/order/*/callback',
        'api/v1/wallet/increase/callback/*',
        'api/v1/perfectmoney/sell/',
        'api/v1/perfectmoney/sell/success',
        'api/v1/perfectmoney/sell/failure',

        'telegram/*'
    ];
}
