<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class KYCVerification extends Model
{
    protected $table = 'kyc_verifications';

    protected $fillable = [
        'user_id',
        'national_id',
        'first_name',
        'last_name',
        'birth_date',
        'id_card_front',
        'id_card_back',
        'selfie',
        'level',
        'status',
        'admin_note',
        'verified_at',
    ];

    protected $casts = [
        'birth_date' => 'date',
        'verified_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Check if KYC is approved
     */
    public function isApproved()
    {
        return $this->status === 'approved';
    }

    /**
     * Check if KYC is pending
     */
    public function isPending()
    {
        return $this->status === 'pending';
    }

    /**
     * Check if KYC is rejected
     */
    public function isRejected()
    {
        return $this->status === 'rejected';
    }
}
