<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Trade extends Model
{
    protected $fillable = [
        'order_id',
        'user_id',
        'market',
        'side',
        'price',
        'amount',
        'total',
        'fee',
        'fee_currency',
        'coinex_trade_id',
    ];

    protected $casts = [
        'price' => 'decimal:8',
        'amount' => 'decimal:8',
        'total' => 'decimal:8',
        'fee' => 'decimal:8',
    ];

    public function order()
    {
        return $this->belongsTo(Order::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
