<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTransactionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->unsignedBigInteger('order_id')->nullable();
            $table->decimal('final_price', 9,0)->nullable();
            $table->string('bank_name', 100)->nullable();
            $table->string('bank_recv', 100)->nullable();
            $table->string('bank_send', 100)->nullable();
            $table->mediumText('bank_log')->nullable();
            $table->enum('status', ['pending', 'confirm', 'cancel']);
            $table->mediumText('bank_raw')->nullable();
            $table->timestamp('expired_at');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('transactions');
    }
}
