<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProductOrdersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('product_orders', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id')->nullable();
            $table->unsignedBigInteger('product_id')->nullable();
            $table->string('product_title', '255')->nullable();
            $table->tinyInteger('quantity')->nullable();
            $table->decimal('price', 9,0)->nullable();
            $table->decimal('delivery_price', 9,0)->nullable();
            $table->decimal('final_price', 9,0)->nullable();
            $table->text('customer_note')->nullable();
            $table->text('admin_note')->nullable();
            $table->enum('status', [
                'payment-pending',
                'payment-confirm',
                'payment-cancel',
                'canceled',
                'cart',
                'done'
            ]);
            $table->enum('payment_method', ['wallet', 'gateway']);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('product_orders');
    }
}
