<?php
echo "<h1>Tetherland API Debug</h1>";

$url = "https://api.tetherland.com/currencies";
echo "<p>Fetching URL: $url</p>";

$chT = curl_init();
curl_setopt($chT, CURLOPT_URL, $url);
curl_setopt($chT, CURLOPT_RETURNTRANSFER, true);
curl_setopt($chT, CURLOPT_TIMEOUT, 10);
curl_setopt($chT, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($chT, CURLOPT_USERAGENT, 'Mozilla/5.0');
// Add verbose output
curl_setopt($chT, CURLOPT_VERBOSE, true);
$verbose = fopen('php://temp', 'w+');
curl_setopt($chT, CURLOPT_STDERR, $verbose);

$respT = curl_exec($chT);
$httpCode = curl_getinfo($chT, CURLINFO_HTTP_CODE);
$curlError = curl_error($chT);
curl_close($chT);

rewind($verbose);
$verboseLog = stream_get_contents($verbose);

echo "<p>HTTP Code: $httpCode</p>";

if ($curlError) {
    echo "<p style='color:red'>cURL Error: $curlError</p>";
}

echo "<h3>Verbose Log:</h3><pre>$verboseLog</pre>";

if ($respT) {
    echo "<h3>Response:</h3>";
    echo "<pre>" . htmlspecialchars($respT) . "</pre>";
    
    $dataT = json_decode($respT, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        echo "<p style='color:red'>JSON Decode Error: " . json_last_error_msg() . "</p>";
    } else {
        echo "<h3>Parsed Data:</h3>";
        if (isset($dataT['data']['currencies']['USDT']['price'])) {
            $price = $dataT['data']['currencies']['USDT']['price'];
            echo "<p style='color:green'>Found Price: $price</p>";
        } else {
             echo "<p style='color:red'>Price NOT found in expected path.</p>";
             print_r($dataT);
        }
    }
} else {
    echo "<p style='color:red'>Empty Response</p>";
}
