<?php
require __DIR__ . '/../vendor/autoload.php';

$app = require_once __DIR__ . '/../bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Http\Kernel::class);
$response = $kernel->handle(
    $request = Illuminate\Http\Request::capture()
);

use App\Settings;

echo "<h1>Kavenegar SMS Test</h1>";

// 1. Get API Key from DB
$dbKey = \App\Settings::where('name', 'KavehnegarKey')->first();
echo "<p><strong>DB Key:</strong> " . ($dbKey ? substr($dbKey->value, 0, 5) . '...' : 'Not Found') . "</p>";

// 2. Get Config Key
$configKey = config('kavenegar.apikey');
echo "<p><strong>Config Key:</strong> " . ($configKey ? substr($configKey, 0, 5) . '...' : 'Not Found') . "</p>";

// 3. Check Match
if ($dbKey && $dbKey->value === $configKey) {
    echo "<p style='color:green'>✅ Config matches DB setting.</p>";
} else {
    echo "<p style='color:red'>❌ Config does NOT match DB setting.</p>";
}

// 4. Try to Send (Mock or Real?)
// We won't actually send to avoid spam, but we can check if the class is instantiable
try {
    if (class_exists('Kavenegar')) {
        echo "<p>✅ Kavenegar class found.</p>";
    } else {
        echo "<p style='color:red'>❌ Kavenegar class NOT found.</p>";
    }
} catch (\Exception $e) {
    echo "<p style='color:red'>Error: " . $e->getMessage() . "</p>";
}
