@extends('admin.layouts.master')
@section('title', 'برداشت های در حال بررسی')

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">درخواست های تسویه</h4>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="card col-12">
            <div class="card-body">
                <div class="mb-4">
                    <div class="card-title mb-0">درخواست های تسویه</div>
                    <p class="mb-4">درخواست های برداشت از کیف پول را مشاهده میکنید و بعد از واریز بر روی تایید کلیک کنید.</p>
                </div>
                <div class="col-md-12">
                    <div class="row justify-content-between">
                        <div class="col-md-3">
                            <a class="btn btn-light mb-3" href="javascript:window.print()"><i class="mdi mdi-printer font-size-14"></i>پرینت اطلاعات صفحه</a>
                        </div>
                        <div class="col-md-3 d-flex">
                            <input type="text" id="myInput" class="form-control mb-3 bg-light me-2" onkeyup="myFunction()" placeholder="جست و جو کنید ...">
                        </div>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table align-middle mb-0 table-nowrap" id="myTable">
                        <thead class="table-light">
                        <tr>
                            <th>#</th>
                            <th>نام کاربر</th>
                            <th>نوع</th>
                            <th>مبلغ</th>
                            <th>موجودی</th>
                            <th>تاریخ و ساعت ثبت</th>
                            <th>شرح</th>
                            <th>وضعیت</th>
                            <th>جزئیات</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($finances as $finance)
                            <tr>
                                <td>{{ $finance->id }}</td>
                                <td>{{ $finance->name . ' ' . $finance->family }}</td>
                                <td>{{ $finance->type }}</td>
                                <td>{{ number_format($finance->amount) }}</td>
                                <td>{{ number_format($finance->wallet) }}</td>
                                <td>{{ $finance->created_at }}</td>
                                <td>{{ $finance->description }}</td>
                                <td>{{ $finance->status }}</td>
                                <td>
                                    <button type="button" class="btn btn-light" data-bs-toggle="modal" data-bs-target="#myModal{{ $finance->id }}">جزییات</button>
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>{{$finances->links()}}
                </div>
            </div>
        </div>
    </div>
    @foreach($finances as $finance)
        <div id="myModal{{ $finance->id }}" class="modal fade" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="myModalLabel">جزییات درخواست</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="text-muted text-center">
                            <p class="mb-2">مبلغ تراکنش</p>
                            <h5>{{ number_format($finance->amount) }} <span>تومان</span></h5>
                            <p class="mt-4 mb-0">وضعیت درخواست
                                <span class="badge badge-soft-warning">در دست اقدام</span>
                            </p>
                            <p class="mt-2 mb-0">آی پی:
                                <span class="bold">{{ $finance->ip }}</span>
                            </p>
                        </div>
                        <div class="table-responsive mt-4">
                            <table class="table align-middle mb-0">
                                <tbody>
                                <tr>
                                    <td colspan="2" class="text-center bg-light">
                                        <h5 class="text-muted mb-0">اطلاعات مشتری</h5>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="text-muted mb-0">نام و نام خانوادگی</p>
                                    </td>
                                    <td>
                                        <h6 class="mb-0">{{ $finance->name . ' ' . $finance->family }}</h6>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="text-muted mb-0">شماره تماس</p>
                                    </td>
                                    <td>
                                        <h6 class="mb-0">{{ $finance->mobile }}</h6>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2">
                                        <p class="text-muted text-center mb-0">این تراکنش در دست اقدام میباشد و بعد از بررسی میتوانید تایید و یا رد نمایید</p>
                                    </td>
                                </tr>
                                <tr>
                                    <td colspan="2" class="text-center bg-light">
                                        <h5 class="text-muted mb-0">اطلاعات حساب بانکی</h5>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="text-muted mb-0">نام بانک</p>
                                    </td>
                                    <td>
                                        <h6 class="mb-0">{{ $finance->bank_name }}</h6>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="text-muted mb-0">شماره کارت</p>
                                    </td>
                                    <td>
                                        <h6 class="mb-0">{{ $finance->card_number }}</h6>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="text-muted mb-0">شماره حساب</p>
                                    </td>
                                    <td>
                                        <h6 class="mb-0">{{ $finance->account_number }}</h6>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="text-muted mb-0">شماره شبا</p>
                                    </td>
                                    <td>
                                        <h6 class="mb-0">{{ $finance->shaba }}</h6>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="modal-footer d-flex justify-content-between">
                        <div>
                            <button type="button" onclick="confirm({{ $finance->id }})" data-bs-dismiss="modal" class="btn btn-success waves-effect">تایید و واریز شد</button>
                            <button type="button" onclick="reject({{ $finance->id }})" data-bs-dismiss="modal" class="btn btn-danger waves-effect waves-light">رد کردن</button>
                        </div>
                        <div>
                            <button type="button" class="btn btn-light waves-effect" data-bs-dismiss="modal">بستن</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endforeach
@stop

@section('script')
    <script>
        function confirm(financeId){
            Swal.fire({
                title: "از تایید اطمینان دارید؟",
                icon:'question',
                html:
                    'بعد از تایید سفارش امکان رد کردن آن وجود ندارد! همچنین میتوانید مبلغ پرداختی را تغییر دهید. و اگر تیک اتوماتیک را نزده باشید میبایست ابتدا به صورت دستی مبلغ را به حساب کاربر واریز نمایید و سپس تایید کنید' +
                    '<select class="swal2-input p-0" id="swal-input1" required>'+
                    '<option selected value="شبا">شبا</option>'+
                    '<option value="کارت به کارت">کارت به کارت</option>'+
                    '<option value="واریز">واریز</option>'+
                    '</select>' +
                    '<fieldset><fieldset><div class="vs-checkbox-con vs-checkbox-primary"><input type="checkbox" value="true" id="swal-input2">'+
                    '<label class="" for="swal-input2"> <span class="mx-1">اتوماتیک از api واریز شود؟</span> </label></div></fieldset>',

                inputAttributes: {
                    autocapitalize: 'off'
                },
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: "آره",
                confirmButtonColor:"#009904",
                cancelButtonText: "نه",
                preConfirm: () => {
                    if ( $('#swal-input2').is(':checked') )
                        autoDeposit = true;
                    else
                        autoDeposit = false;

                    return $.ajax({
                        url: "{{asset('').env('PanelPrefix')}}/finances/" + financeId + "/confirm",
                        type: 'put',
                        data: {_token: "{{ csrf_token() }}",via:$('#swal-input1').val(),autoDeposit:autoDeposit},
                    });
                }
            }).then((data) => {
                if(data.value.status==true){
                    Swal.fire({
                        title:'انجام شد!',
                        icon: 'success',
                        text: data.value.messege,
                    })
                }
                else{
                    Swal.fire("خطا",  data.value.message  , "error");
                }
            });
        }

        function reject(financeId){
            Swal.fire({
                title: "از رد کردن اطمینان دارید؟",
                text: "جهت رد کردن دلیلی را مشخص نمایید",
                icon: "info",
                input: "text",
                inputPlaceholder: 'دلیل رد شدن را ذکر کنید',
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: "آره",
                confirmButtonColor:"#991008",
                cancelButtonText: "نه",
                inputValidator: (value) => {
                    if (!value) {
                        return 'دلیل رد شدن را درج کنید'
                    }
                },
                preConfirm: (value) => {
                    return $.ajax({
                        url: "{{asset('').env('PanelPrefix')}}/finances/" + financeId + "/reject",
                        type: 'put',
                        data: {_token: "{{ csrf_token() }}",reason:value},
                    });
                }
            }).then((data) => {
                if(data.value.status==true){
                    Swal.fire({
                        title:'انجام شد!',
                        type: 'success',
                        text: data.value.message,
                    }).then(function () {
                        $('.alt-pagination').DataTable().ajax.reload();
                        $("#Info").modal('hide');
                    });
                }
                else{
                    Swal.fire("خطا",  data.value.message  , "error");
                }
            });
        }
    </script>
@stop
