@extends('admin.layouts.master')
@section('title', 'پرداخت گروهی')
@section('css')
    <link rel="stylesheet" type="text/css"
          href="{{asset('')}}app-assets/vendors/css/tables/datatable/datatables.min.css">
    <style>
        .selection-multiple-rows tbody.text-center tr.selected{
            background-color: rgb(122, 210, 116) !important;
        }
    </style>
@stop

@section('content')
<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-wrapper-before" style="background:#1C2135"></div>
        <div class="content-header row">
        </div>
        <div class="content-body">
            <div class="row">
                <div class="card mb-4 w-100">
                    <div class="card-body">
                        <table class="table table-striped table-bordered alt-pagination selection-multiple-rows dataex-fixh-basic w-100" id="tbl_confirm">
                            <thead>
                            <tr>
                                <th class="text-center w-1"></th>
                                <th class="text-center w-1">#</th>
                                <th class="text-center">نام مشتری</th>
                                <th class="text-center w-1">ارز</th>
                                <th class="text-center">نوع سفارش</th>
                                <th class="text-center">مقدار</th>
                                <th class="text-center">تاریخ و ساعت ثبت</th>
                                <th class="text-center">وضعیت</th>
                                <th class="text-center">مبلغ سفارش</th>
                                <th class="text-center w-1">جزئیات</th>
                            </tr>
                            </thead>
                            <tbody  class="text-center">
                            @foreach($result['orders'] as $order)
                            <tr class="selected">
                                <td>{{$order->id}}</td>
                                <td></td>
                                <td>{{$order->user->name .' '.$order->user->family}}</td>
                                <td><img src="{{asset('')}}app-assets/images/currency/{{$order->orders_model}}.svg" width="30wh"></td>
                                <td>{{$order->detail->type .' '. $order->detail->title}}</td>
                                <td>{{$order->detail->amount_dollar .' '. $order->detail->dollar}}</td>
                                <td>{{$order->date}}</td>
                                <td>
                                    @if($order->status == 'در حال پردازش')
                                        <span class="badge badge-pill badge-warning font-weight-light">در حال پردازش</span>
                                    @endif
                                </td>
                                <td>{{number_format($order->amount)}}</td>
                                <td><a href="{{asset('').env('PanelPrefix')}}/orders/{{$order->id}}" class="btn btn-outline-info btn-sm">Info</a></td>
                            </tr>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

@stop

@section('js')
    <script src="{{asset('')}}js/tables/datatable/datatables.min.js" type="text/javascript"></script>
@stop

@section('script')

<script>
    var multipleRowsTable = $('#tbl_confirm').DataTable({
        "pagingType": "full_numbers",
        "scrollX": true,
        "language": {
            "url": "{{asset('')}}js/tables/datatable/datatable-Persian.json"
        },
        "order": [[ 0, 'desc' ]],
        paging: false,
        dom: "<'top'><'row'<'col-md-5 col-12 mt-1'B><'col-md-7 col-12 d-flex ltr-dir'<'mx-1 mt-1'l><'rtl-dir'f>>><'bottom'>rt<'row'<'col-md-5 col-12'i><'col-md-7 col-12'p>><'clear'>",
        buttons: [
            {
                extend: 'print',
                text: '<i class="ft-printer"></i> Print',
                className: 'btn btn-outline-secondary',
                title: '',
                exportOptions: {
                    columns: [0, 1, 2, 3, 4, 5, {
                        'data': 'batch_notes', "render": function (data, type, row, meta) {
                            return data
                        },
                    }]
                }
            },
            {
                extend: 'excel',
                text: '<i class="ft-save"></i> Exel',
                className: 'btn btn-outline-secondary',
                exportOptions: {
                    columns: [1, 2, 3, 4, 5, {
                        'data': 'batch_notes', "render": function (data, type, row, meta) {
                            return data
                        },
                    }]
                }
            },
            {
                text: '<i class="ft-check"></i> تایید و پرداخت همه',
                className: 'btn btn-outline-warning',
                action: function ( e, dt, node, config ) {
                   configOrders();
                }
            }
        ],
        "columnDefs": [
            {
                "targets": 1,
                "searchable": false,
                "orderable": true,
                "data": null,
                "render": function (data, type, full, meta) {
                    return meta.settings._iDisplayStart + meta.row + 1;
                }
            },
            { 'visible': false, 'targets': [0] }
        ],
    });


    $('.selection-multiple-rows tbody').on('click', 'tr', function() {
        $(this).toggleClass('selected');
    });

    function configOrders() {
        var oData = multipleRowsTable.rows('.selected').data();
        var IDs = [];
        for (var i=0; i < oData.length ;i++){
            IDs.push( oData[i][0]);
        }

        swal({
            title: "از تایید و پرداخت همه انتخاب شده ها اطمینان دارید؟",
            text: "بعد از تایید سفارش امکان رد کردن آن وجود ندارد!",
            input:'select',
            inputOptions: {
                'شبا': 'شبا',
                'کارت به کارت': 'کارت به کارت',
                'واریز': 'واریز به حساب',
            },
            showCancelButton: true,
            confirmButtonText: 'تایید',
            showLoaderOnConfirm: true,
            inputValidator: (value) => {
                if (!value) {
                    return 'لطفا روش پرداخت را انتخاب کنید'
                }
            },
            preConfirm: (input) => {
                return $.ajax({
                    url: "{{asset('').env('PanelPrefix')}}/actions/orders/all-confirm",
                    type: 'post',
                    data: {_token: "{{ csrf_token() }}",status:'پرداخت شده',payment:input,IDs:JSON.stringify(IDs)},
                });
            }
        }).then((data) => {
            if(data.value.status==true){
                swal({
                    title:'انجام شد!',
                    type: 'success',
                    text: data.value.messege,
                }).then(function () {
                    location.reload();
                });
            }
            else{
                swal("Error",  data.value.messege  , "error");
                unloading();
            }
        });
    }

</script>
@stop
