@extends('admin.layouts.master')
@section('title', 'کاربران در دست بررسی')

@section('content')
@section('content')

    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">کاربران در انتظار تایید</h4>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="card col-12">
            <div class="card-body">
                <div class="mb-4">
                    <div class="card-title">کاربران در انتظار تایید</div>
                    <div class="mb-0">لیست کاربرانی که باید تایید شوند را مشاهده میکنید</div>
                </div>
                <div class="col-md-12">
                    <div class="row justify-content-between">
                        <div class="col-md-3">
                            <a class="btn btn-light mb-3" href="javascript:window.print()"><i class="mdi mdi-printer font-size-14"></i>پرینت اطلاعات صفحه</a>
                        </div>
                        <div class="col-md-3 d-flex">
                            <input type="text" id="myInput" class="form-control mb-3 bg-light me-2" onkeyup="myFunction()" placeholder="جست و جو کنید ...">
                        </div>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table align-middle mb-0 table-nowrap" id="myTable">
                        <thead class="table-light">
                        <tr>
                            <th>شناسه</th>
                            <th>نام و فامیل</th>
                            <th>کد ملی</th>
                            <th>موبایل</th>
                            <th>عضویت</th>
                            <th>موجودی</th>
                            <th>وضعیت</th>
                            <th>جزییات</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($users as $user)
                            <tr>
                                <td>{{$user->id}}</td>
                                <td>{{$user->name.' '.$user->family}}</td>
                                <td>
                                    @if($user->code_meli == null)
                                        ثبت نشده
                                    @else
                                        {{$user->code_meli}}
                                    @endif
                                </td>
                                <td>{{$user->mobile}}</td>
                                <td>{{$user->created_at}}</td>
                                <td>{{number_format($user->wallet)}}</td>
                                <td>
                                    @if($user->auth_img_confirm == 1 & $user->selfie_img_confirm == 1)
                                        <span class="badge badge-soft-success">تایید شده</span>
                                    @else
                                        <span class="badge badge-soft-warning">تایید نشده</span>
                                    @endif
                                </td>
                                <td><a class="btn btn-light" href="{{ asset('').env('PanelPrefix') }}/users/{{$user->id}}">مشاهده</a></td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>{{$users->links()}}
                </div>
            </div>
        </div>
    </div>
@stop
