@extends('admin.auth.master')
@section('title', 'ورود دو مرحله ای')

@section('content')
        <div class="content-body ">
            <section class="flexbox-container" >
                <div class="col-12 d-flex align-items-center justify-content-center">
                    <div class="col-lg-4 col-md-6 col-10 box-shadow-2 p-0">
                        @if(Session::has('Error'))
                            <div class="alert alert-card alert-danger alert-dismissible w-100" role="alert">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">×</span>
                                </button>
                                {{ Session::get('Error') }}
                            </div>
                        @endif
                        <div class="card border-grey border-lighten-3 px-1 py-1 m-0">
                            <div class="card-header border-0">
                                <div class="text-center mb-1">
                                    <img src="{{asset('')}}app-assets/images/logo/logo.png" width="50%" alt="{{ getSetting('app_name_farsi') }} logo">
                                </div>
                                <div class="font-small-3  text-center">
                                      ورود دو مرحله ای از طریق پیامک
                                </div>
                            </div>
                            <div class="card-content">

                                <div class="card-body p-0 p-md-2 ">
                                    <form method="POST" autocomplete="off" id="form_mobile" class="form-horizontal needs-validation" action="" novalidate>
                                        @csrf
                                        <div class="form-group">
                                            <input type="text" class="form-control text-center numbers ltr-dir round" required id="code" placeholder="کد پنج رقمی" name="code" maxlength="5" minlength="5">
                                            <div class="invalid-feedback">
                                                کد را بدرستی درج کنید
                                            </div>
                                        </div>

                                        <div class="text-center mt-1 mb-1">
                                            <a class="btn btn-bg-gradient-x-orange-yellow round btn-sm"  id="makingdifferenttimer"
                                               style="display: none;" onclick="resend()"> ارسال مجدد
                                            </a>
                                        </div>

                                        <div id="mdtimer" class="my-2  text-center">
                                            <b></b>
                                            <div class="text-17"><b> 00:<span>59</span></b></div>
                                        </div>

                                        <div class="form-group text-center">
                                            <button type="submit" class="btn round btn-block btn-glow btn-bg-gradient-x-purple-blue col-12 mr-1 mb-1">ورود</button>
                                        </div>

                                    </form>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </section>

        </div>


@stop

@section('script')
<script>
    jQuery(document).ready(function () {
        var sec = 58
        var timer = setInterval(function () {
            $("#mdtimer span").text(sec--);
            if (sec == 0) {
                $("#makingdifferenttimer").delay(1000).fadeIn(1000);
                $("#mdtimer").delay(600).fadeOut();
                clearInterval(timer);
            }
        }, 1000);
    });


    function resend() {
        $("#makingdifferenttimer").html('<span class="spinner-grow" role="status"></span> لطفا صبر کنید');
        $("#makingdifferenttimer").attr('onclick','');
        $(".box-button").attr('disabled','disabled');
        $.post("{{route("A-sms2faResend")}}",
            {
                _token: "{{ csrf_token() }}"
            },
            function(data){
                if(data.status == true){
                    toastr.success(data.message, "انجام شد!", {
                        positionClass: "toast-bottom-center",
                        progressBar: !0,
                    })

                    $("#makingdifferenttimer").delay(600).fadeOut();
                    $("#mdtimer").delay(1000).fadeIn();
                    $("#mdtimer span").text('59');
                    $(".box-button").removeAttr('disabled');
                    var sec = 58
                    var timer = setInterval(function () {
                        $("#mdtimer span").text(sec--);
                        if (sec == 0) {
                            $("#makingdifferenttimer").html('ارسال مجدد');
                            $("#makingdifferenttimer").attr('onclick','resend()');
                            $("#makingdifferenttimer").delay(1000).fadeIn(1000);
                            $("#mdtimer").delay(600).fadeOut();
                            clearInterval(timer);
                        }
                    }, 1000);


                }
                else{
                    $("#makingdifferenttimer").html('ارسال مجدد');
                    $("#makingdifferenttimer").attr('onclick','resend()');
                    $(".box-button").removeAttr('disabled');
                    swal("خطا",   data.message  , "error");
                }
            });
    }
</script>
@stop
