@extends('admin.layouts.master')
@section('title', 'کارت های بانکی')
@section('css')
@stop

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">کارت‌های بانکی</h4>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="card col-12">
            <div class="card-body">
                <div class="d-flex justify-content-between mb-4">
                    <div class="card-title mb-0">کارت‌های بانکی</div>
                </div>
                <div class="col-md-12">
                    <div class="row justify-content-between">
                        <div class="col-md-3">
                            <a class="btn btn-light mb-3" href="javascript:window.print()"><i class="mdi mdi-printer font-size-14"></i>پرینت اطلاعات صفحه</a>
                        </div>
                        <div class="col-md-3 d-flex">
                            <input type="text" id="myInput" class="form-control mb-3 bg-light me-2" onkeyup="myFunction()" placeholder="جست و جو کنید ...">
                        </div>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table align-middle mb-0 table-nowrap" id="myTable">
                        <thead class="table-light">
                        <tr>
                            <th>شناسه</th>
                            <th>نام کاربر</th>
                            <th>شماره کارت</th>
                            <th>شماره حساب</th>
                            <th>نام بانک</th>
                            <th>زمان ثبت</th>
                            <th>وضعیت</th>
                            <th>جزییات</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($cardbanks as $cardbank)
                            <tr>
                                <td>{{$cardbank->id}}</td>
                                <td>{{$cardbank->name.' '.$cardbank->family}}</td>
                                <td>{{$cardbank->card_number}}</td>
                                <td>{{$cardbank->account_number}}</td>
                                <td>{{$cardbank->bank_name}}</td>
                                <td>{{$cardbank->created_at}}</td>
                                <td>
                                    @if($cardbank->confirm == 0)
                                        <span class="badge badge-soft-warning">منتظر تایید</span>
                                    @elseif($cardbank->confirm == 1)
                                        <span class="badge badge-soft-success">تایید شده</span>
                                    @else
                                    <span class="badge badge-soft-danger">تایید نشده</span>
                                    @endif
                                </td>
                                <td><a class="btn btn-light" href="{{ asset('').env('PanelPrefix') }}/users/{{$cardbank->id_user}}">مشاهده</a></td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>{{$cardbanks->links()}}
                </div>
            </div>
        </div>
    </div>
@stop
