<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="rtl">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <title>@yield('title')</title>
    <link rel="shortcut icon" type="image/x-icon" href="{{ asset('images/logo/favicon.svg') }}">
    <link rel="manifest" href="{{asset('')}}js/manifest.json">
    <meta name="_token" content="{{ csrf_token() }}">
    <meta name="url" content="{{ asset('') }}">
    <meta name="firebase_token" content="{{ Auth::user()->firebase_token }}">
    <link href="https://fonts.googleapis.com/css?family=Muli:300,300i,400,400i,600,600i,700,700i%7CComfortaa:300,400,700"
          rel="stylesheet">

    @if(getSetting('admin_theme_color') == 'light')
        <link href="{{ asset('css/bootstrap-rtl.min.css') }}" id="bootstrap-style" rel="stylesheet" type="text/css" />
        <link href="{{ asset('css/app-rtl.min.css') }}" id="app-style" rel="stylesheet" type="text/css" />
    @elseif(getSetting('admin_theme_color') == 'dark')
        <link href="{{ asset('assets/css/bootstrap-dark-rtl.min.css') }}" id="bootstrap-style" rel="stylesheet" type="text/css" />
        <link href="{{ asset('assets/css/app-dark-rtl.min.css') }}" id="app-style" rel="stylesheet" type="text/css" />
    @endif

    <link href="{{ asset('/assets/libs/sweetalert2/sweetalert2.min.css') }}" id="bootstrap-style" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="{{ asset('css/icons.min.css') }}" rel="stylesheet" type="text/css" />
    <!-- Fonts Css-->
    <link href="{{ asset('css/font_iransans.css') }}" id="app-style" rel="stylesheet" type="text/css" />

    @yield('css')
</head>

<body data-topbar="dark" data-layout="horizontal" data-layout-size="boxed" style="font-family: IRANSans !important;">
    <div id="layout-wrapper" class="min-vh-100">
        <header id="page-topbar">
            <div class="navbar-header">
                <div class="d-flex">
                    <div class="navbar-brand-box">
                        <a href="{{asset('').env('PanelPrefix')}}" class="logo logo-dark">
                            <span class="logo-sm">
                                <img src="{{ asset('images/logo/logo.svg') }}" alt="" height="22">
                            </span>
                            <span class="logo-lg">
                                <img src="{{ asset('images/logo/logo-dark.svg') }}" alt="" height="17">
                            </span>
                        </a>
                        <a href="{{asset('').env('PanelPrefix')}}" class="logo logo-light">
                            <span class="logo-sm">
                                <img src="{{ asset('images/logo/logo.svg') }}" alt="" height="22">
                            </span>
                            <span class="logo-lg">
                                <img src="{{ asset('images/logo/logo-light.svg') }}" alt="" height="19">
                            </span>
                        </a>
                    </div>
                    <button type="button" class="btn btn-sm px-3 font-size-16 d-lg-none header-item waves-effect waves-light" data-bs-toggle="collapse" data-bs-target="#topnav-menu-content">
                        <i class="fa fa-fw fa-bars"></i>
                    </button>
                </div>
                <div class="d-flex">
                    <div class="dropdown d-none d-lg-inline-block ms-1">
                        <button type="button" class="btn header-item noti-icon waves-effect"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="bx bx-customize"></i>
                        </button>
                        <div class="dropdown-menu dropdown-menu-lg dropdown-menu-end">
                            <div class="px-lg-2">
                                <div class="ps-3 pt-2">
                                    <h6 class="m-0"> دسترسی سریع </h6>
                                </div>
                                <div class="row g-0">
                                    <div class="col">
                                        <a class="dropdown-icon-item" href="https://coinmarketcap.com/" target="_blank">
                                            <img src="{{ asset('images/brands/coinmarketcap.png') }}" alt="Github">
                                            <span>کوین مارکت کپ</span>
                                        </a>
                                    </div>
                                    <div class="col">
                                        <a class="dropdown-icon-item" href="https://coinex.com" target="_blank">
                                            <img src="{{ asset('images/brands/coinex.svg') }}" alt="bitbucket">
                                            <span>کوینکس</span>
                                        </a>
                                    </div>
                                    <div class="col">
                                        <a class="dropdown-icon-item" href="https://binance.com" target="_blank">
                                            <img src="{{ asset('images/brands/binance.svg') }}" alt="dribbble">
                                            <span>بایننس</span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="dropdown d-none d-lg-inline-block ms-1">
                        <button type="button" class="btn header-item noti-icon waves-effect" data-toggle="fullscreen">
                            <i class="bx bx-fullscreen"></i>
                        </button>
                    </div>
                    <div class="dropdown d-inline-block">
                        <button type="button" class="btn header-item noti-icon waves-effect" id="page-header-notifications-dropdown"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="bx bx-bell bx-tada"></i>

                            @if(($SumNotification = config('notification.CountOrders') + config('notification.CountTicket') + config('notification.CountUserPending') + config('notification.CountFinances') + config('notification.CountCardBank') + config('notification.CountWalletPending')) > 0)
                                <span class="badge bg-danger rounded-pill">
                                    {{$SumNotification}}
                                </span>
                            @endif
                        </button>
                        <div class="dropdown-menu dropdown-menu-lg dropdown-menu-end p-0"
                             aria-labelledby="page-header-notifications-dropdown">
                            <div class="p-3">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <h6 class="m-0"> اطلاعیه‌ها </h6>
                                    </div>
                                </div>
                            </div>
                            <ul class="py-0 list-unstyled" data-simplebar style="max-height: 230px;">
                                <li class="w-100">
                                    @if($SumNotification == 0)
                                        <div class="media">
                                            <div class="media-body">
                                                <h6 class="media-heading text-center text-muted mb-0">
                                                    اطلاعیه ای موجود نیست!
                                                </h6>
                                            </div>
                                        </div>
                                    @else
                                        @if(config('notification.CountOrders')>0)
                                            <a href="{{asset('').env('PanelPrefix')}}/actions/orders" data-sort='{{config('notification.SortOrder')}}' class="text-reset notification-item">
                                                <div class="d-flex">
                                                    <div class="avatar-xs me-3">
                                                        <span class="avatar-title bg-danger rounded-circle font-size-16">
                                                            <i class="bx bx-shopping-bag"></i>
                                                        </span>
                                                    </div>
                                                    <div class="flex-grow-1">
                                                        <h6 class="mb-1" key="t-your-order">
                                                        <span class="badge bg-info rounded-pill">
                                                            {{config('notification.CountOrders')}}
                                                        </span>
                                                            سفارش در انتظار
                                                        </h6>
                                                        <div class="font-size-12 text-muted">
                                                            <p class="mb-1" key="t-grammer">{{config('notification.SubjectOrder')}}</p>
                                                            <p class="mb-0"><i class="mdi mdi-clock-outline"></i> <span key="t-min-ago">{{config('notification.TimeOrder')}}</span></p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </a>
                                        @endif
                                        @if(config('notification.CountTicket')>0)
                                            <a href="{{asset('').env('PanelPrefix')}}/ticket" data-sort='{{config('notification.SortTicket')}}' class="text-reset notification-item">
                                                <div class="d-flex">
                                                    <div class="avatar-xs me-3">
                                                        <span class="avatar-title bg-primary rounded-circle font-size-16">
                                                            <i class="bx bx-chat"></i>
                                                        </span>
                                                    </div>
                                                    <div class="flex-grow-1">
                                                        <h6 class="mb-1" key="t-your-order">
                                                            <span class="badge bg-info rounded-pill">
                                                                {{config('notification.CountTicket')}}
                                                            </span>
                                                            تیکت خوانده نشده
                                                        </h6>
                                                        <div class="font-size-12 text-muted">
                                                            <p class="mb-1" key="t-grammer">{{config('notification.SubjectTicket')}}</p>
                                                            <p class="mb-0"><i class="mdi mdi-clock-outline"></i> <span key="t-min-ago">{{config('notification.TimeTicket')}}</span></p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </a>
                                        @endif

                                        @if(config('notification.CountUserPending')>0)
                                            <a href="{{asset('').env('PanelPrefix')}}/actions" data-sort='{{config('notification.SortUser')}}' class="text-reset notification-item">
                                                <div class="d-flex">
                                                    <div class="avatar-xs me-3">
                                                        <span class="avatar-title bg-warning rounded-circle font-size-16">
                                                            <i class="bx bx-user"></i>
                                                        </span>
                                                    </div>
                                                    <div class="flex-grow-1">
                                                        <h6 class="mb-1" key="t-your-order">
                                                            <span class="badge bg-info rounded-pill">
                                                                {{config('notification.CountUserPending')}}
                                                            </span>
                                                            کاربر تایید نشده
                                                        </h6>
                                                        <div class="font-size-12 text-muted">
                                                            <p class="mb-1" key="t-grammer">{{config('notification.NameUser')}}</p>
                                                            <p class="mb-0"><i class="mdi mdi-clock-outline"></i> <span key="t-min-ago">{{config('notification.TimeUser')}}</span></p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </a>
                                        @endif

                                        @if(config('notification.CountFinances')>0)
                                            <a href="{{asset('').env('PanelPrefix')}}/actions/finance" data-sort='{{config('notification.SortFinance')}}' class="text-reset notification-item">
                                                <div class="d-flex">
                                                    <div class="avatar-xs me-3">
                                                        <span class="avatar-title bg-success rounded-circle font-size-16">
                                                            <i class="bx bx-wallet"></i>
                                                        </span>
                                                    </div>
                                                    <div class="flex-grow-1">
                                                        <h6 class="mb-1" key="t-your-order">
                                                            <span class="badge bg-info rounded-pill">
                                                                {{config('notification.CountFinances')}}
                                                            </span>
                                                            درخواست برداشت از کیف پول
                                                        </h6>
                                                        <div class="font-size-12 text-muted">
                                                            <p class="mb-1" key="t-grammer">{{config('notification.NameUser')}}</p>
                                                            <p class="mb-0"><i class="mdi mdi-clock-outline"></i> <span key="t-min-ago">{{config('notification.FinanceTime')}}</span></p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </a>
                                        @endif

                                        @if(config('notification.CountCardBank')>0)
                                            <a href="{{asset('').env('PanelPrefix')}}/actions/cardbank" data-sort='{{config('notification.SortCard')}}' class="text-reset notification-item">
                                                <div class="d-flex">
                                                    <div class="avatar-xs me-3">
                                                        <span class="avatar-title bg-primary rounded-circle font-size-16">
                                                            <i class="bx bxs-bank"></i>
                                                        </span>
                                                    </div>
                                                    <div class="flex-grow-1">
                                                        <h6 class="mb-1" key="t-your-order">
                                                            <span class="badge bg-info rounded-pill">
                                                                {{config('notification.CountCardBank')}}
                                                            </span>
                                                            کارت بانکی تایید نشده
                                                        </h6>
                                                        <div class="font-size-12 text-muted">
                                                            <p class="mb-1" key="t-grammer">{{config('notification.SubjectCard')}}</p>
                                                            <p class="mb-0"><i class="mdi mdi-clock-outline"></i> <span key="t-min-ago">{{config('notification.TimeCardBank')}}</span></p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </a>
                                        @endif

                                        @if(config('notification.CountWalletPending')>0)
                                            <a href="{{asset('').env('PanelPrefix')}}/actions/wallet" data-sort='{{config('notification.SortWallet')}}' class="text-reset notification-item">
                                                <div class="d-flex">
                                                    <div class="avatar-xs me-3">
                                                        <span class="avatar-title bg-primary rounded-circle font-size-16">
                                                            <i class="bx bxs-bank"></i>
                                                        </span>
                                                    </div>
                                                    <div class="flex-grow-1">
                                                        <h6 class="mb-1" key="t-your-order">
                                                            <span class="badge bg-info rounded-pill">
                                                                {{config('notification.CountWalletPending')}}
                                                            </span>
                                                            کیف پول تایید نشده
                                                        </h6>
                                                        <div class="font-size-12 text-muted">
                                                            <p class="mb-1" key="t-grammer">{{config('notification.NameWallet')}}</p>
                                                            <p class="mb-0"><i class="mdi mdi-clock-outline"></i> <span key="t-min-ago">{{config('notification.TimeWallet')}}</span></p>
                                                        </div>
                                                    </div>
                                                </div>
                                            </a>
                                        @endif
                                    @endif
                                </li>
                            </ul>
                        </div>
                    </div>

                    <div class="dropdown d-inline-block">
                        <button type="button" class="btn header-item waves-effect" id="page-header-user-dropdown"
                                data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <img class="rounded-circle header-profile-user" src="{{ asset('images/users/user.png') }}"
                                 alt="Header Avatar">
                            <span class="d-none d-xl-inline-block ms-1" key="t-henry">{{Auth::user()->name}}</span>
                            <i class="mdi mdi-chevron-down d-none d-xl-inline-block"></i>
                        </button>
                        <div class="dropdown-menu dropdown-menu-end">
                            <a class="dropdown-item" href="{{asset('').env('PanelPrefix')}}/profile">
                                <i class="bx bx-user font-size-16 align-middle me-1"></i>
                                <span key="t-profile">پروفایل</span>
                            </a>
                            <a class="dropdown-item" href="{{asset('').env('PanelPrefix')}}/profile/two-factor-authentication">
                                <i class="bx bx-lock-open font-size-16 align-middle me-1"></i>
                                <span key="t-lock-screen">ورود دو مرحله ای</span>
                            </a>
                            <div class="dropdown-divider"></div>
                            <a class="dropdown-item text-danger" href="#" onclick="event.preventDefault();document.getElementById('logout-form').submit();">
                                <i class="bx bx-power-off font-size-16 align-middle me-1 text-danger"></i>
                                <span key="t-logout">خروج</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </header>

        @include('admin.layouts.menu')

        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    @yield('content')
                </div>
            </div>
        </div>

        @include('admin.layouts.footer')

    </div>


    <form id="logout-form" action="{{ Route('A-logout') }}" method="POST" style="display: none;">
        {{ csrf_field() }}
    </form>

    <!-- JAVASCRIPT -->
    <script src="{{ asset('js/jquery.min.js') }}" type="text/javascript"></script>
    <script src="{{ asset('js/bootstrap.bundle.min.js') }}" type="text/javascript"></script>
    <script src="{{ asset('js/metisMenu.min.js') }}" type="text/javascript"></script>
    <script src="{{ asset('js/simplebar.min.js') }}" type="text/javascript"></script>
    <script src="{{ asset('js/waves.min.js') }}" type="text/javascript"></script>
    <script src="{{ asset('js/sweetalert2.min.js') }}" type="text/javascript"></script>
    <script src="{{ asset('js/jquery.form.min.js') }}" type="text/javascript"></script>

    <!-- App js -->
    <script src="{{ asset('js/app.js') }}"></script>
    <script src="{{ asset('js/arzland.js') }}"></script>
    @yield('js')
    @yield('script')

    @if(Session::has('Success'))
        <script>
            toastr.success("{{ Session::get('Success') }}", "انجام شد!", {
                positionClass: "toast-bottom-center",
                progressBar: !0,
            })
        </script>
    @endif
    @if(Session::has('Error'))
        <script>
            toastr.error("{{ Session::get('Error') }}", "خطا!", {
                positionClass: "toast-bottom-center",
                progressBar: !0,
            })
        </script>
    @endif
</body>
