@extends('admin.layouts.master')
@section('title', 'اطلاعیه')

@section('content')

{{--    {{ dd($notifications) }}--}}

    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="card-title mb-0">اطلاعیه ها</div>
                <form  autocomplete="off" method="post" class="needs-validation" novalidate action="" enctype="multipart/form-data">
                    @csrf
                    <div class="row col-md-6 col-12 m-md-auto m-0 p-0">
                        <div class="col-md-12 p-0 pr-md-1 form-group mb-3">
                            <label for="picker1">نوع اطلاعیه</label>
                            <div class="row mt-2">
                                <div class="mb-2">
                                    <label class="switch switch-success" data-toggle="tooltip" data-original-title="به صورت یک یک کادر در بالای داشبورد ثابت و تا زمانی که اطلاعیه را حذف نکرده اید نمایش داده میشود">
                                        <input type="checkbox" value="1" name="head_fix">
                                        <span class="ms-1">هدر صفحات پنل ثابت</span>
                                        <span class="slider"></span>
                                    </label>
                                    <div id="head_fix" style="display: none" data-toggle="tooltip" data-original-title="رنگ بک گراند این اطلاعیه">
                                        <select class="form-control input-sm" name="color" id="color">
                                            <option value='info' selected>آبی (info)</option>
                                            <option value="danger">قرمز (danger)</option>
                                            <option value="warning">زرد (warning)</option>
                                            <option value="success">سبز (success)</option>
                                            <option value="dark">مشکی (dark)</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="mb-2">
                                    <label class="switch switch-success" data-toggle="tooltip" data-original-title="به صورت یک یک کادر در بالای داشبورد میباشد که دکمه بستن برای کاربر فراهم میباشد و تا زمانی که اطلاعیه را حذف نکرده اید نمایش داده میشود">
                                        <input type="checkbox" value="1" name="head_close">
                                        <span class="ms-1">هدر صفحات پنل فقط یکبار</span>
                                        <span class="slider"></span>
                                    </label>
                                    <div id="head_close" style="display: none" data-toggle="tooltip" data-original-title="رنگ بک گراند این اطلاعیه">
                                        <select class="form-control input-sm" name="color" id="color">
                                            <option value='info' selected>آبی (info)</option>
                                            <option value="danger">قرمز (danger)</option>
                                            <option value="warning">زرد (warning)</option>
                                            <option value="success">سبز (success)</option>
                                            <option value="dark">مشکی (dark)</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="mb-2">
                                    <label class="switch switch-success" data-toggle="tooltip" data-original-title="بهترین روش ارسال اطلاعیه میباشد که حتی با بسته بودن مرورگر باز هم اطلاعیه در ویندوز کاربر نمایش داده میشود اما باید کاربر از قبل دریافت نوتیفیکیشن را قبول کرده باشد">
                                        <input type="checkbox" value="0" name="notification">
                                        <span class="ms-1">از طریق نوتیفکیشن سایت</span>
                                        <span class="slider"></span>
                                    </label>
                                </div>
                                <div class="mb-2">
                                    <label class="switch switch-success" data-toggle="tooltip" data-original-title="ایمیل ممکن است به همه کاربران ارسال نشود و این به تنظمیات هاستینگ برای شما و ارسال تعداد ایمیل در هر ثانیه برمیگردد.">
                                        <input type="checkbox" value="0" name="email">
                                        <span class="ml-3">از طریق ایمیل</span>
                                        <span class="slider"></span>
                                    </label>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-12 p-0 form-group mb-3">
                            <label>کاربران</label>
                            <select class="form-control" name="category" id="category">
                                <option value='-1' selected>همه کاربران</option>
                                <option value="0">کاربرانی که تا الان سفارشی نداشته اند</option>
                                <option value="1">کاربرانی که تا الان حداقل یک سفارش ثبت کرده اند</option>
                                <option value="2">کاربرانی که تا الان سفارش ووچرز ثبت کرده اند</option>
                                <option value="3">کاربرانی که تا الان سفارش پی پل ثبت کرده اند</option>
                                <option value="4">کاربرانی که تا الان سفارش اسکریل ثبت کرده اند</option>
                                <option value="5">کاربرانی که تا الان سفارش وب مانی ثبت کرده اند</option>
                                <option value="6">کاربرانی که تا الان سفارش پرفکت مانی ثبت کرده اند</option>
                                <option value="11">کاربرانی که تا الان سفارش ووچرز پرفکت مانی ثبت کرده اند</option>
                                <option value="7">کاربرانی که تا الان سفارش بیت کوین ثبت کرده اند</option>
                                <option value="8">کاربرانی که تا الان سفارش اتریوم ثبت کرده اند</option>
                                <option value="9">کاربرانی که تا الان سفارش ریپل ثبت کرده اند</option>
                                <option value="10">کاربرانی که تا الان سفارش تتر ثبت کرده اند</option>

                            </select>
                            <small class="text-10">این دسته بندی برای آلرت های هدر ها کاربردی ندارد و برای همه نشان میدهد</small>
                        </div>

                        <div class="col-md-12 p-0 form-group mb-3">
                            <label for="firstName1">عنوان اطلاعیه</label>
                            <input type="text" class="form-control" name="subject" id="subject" maxlength="100" required placeholder="موضوع خود را درج کنید">
                            <div class="invalid-feedback">موضوع خود را انتخاب کنید</div>
                            <small class="text-10">عنوان برای sms کاربردی ندارد</small>
                        </div>

                        <div class="col-md-12 p-0 form-group mb-3">
                            <label for="phone">پیغام</label>
                            <textarea rows="5"  name="message" maxlength="300" id="message" class="form-control" required placeholder="پیغام خود را درج کنید"></textarea>
                            <div class="invalid-feedback">پیغام خود را درج کنید</div>
                            <small class="text-10">پیغام برای sms های الگوهای کاوه نگار کاربردی ندارد</small>
                        </div>

                        <div class="col-md-4 m-auto">
                            <button type="submit" class="btn btn-primary btn-block">ثبت و ارسال</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="card mb-4 w-100">
            <div class="card-body">
                <div class="card-title">لیست اطلاعیه های ارسال شده</div>
                <div class="col-md-3 d-flex">
                    <input type="text" id="myInput" class="form-control mb-3 bg-light me-2" onkeyup="myFunction()" placeholder="جست و جو کنید ...">
                </div>
                <div class="table-responsive">
                    <div class="col-md-12">
                        <div class="row justify-content-between">
                        </div>
                    </div>
                    <table class="table align-middle mb-0 table-nowrap" id="myTable">
                        <thead class="table-light">
                        <tr>
                            <th>#</th>
                            <th>موضوع</th>
                            <th>پبغام</th>
                            <th>نوع اطلاعیه</th>
                            <th>ارسال</th>
                            <th>حذف</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($notifications as $notification)
                            <tr>
                                <td>{{$notification->id}}</td>
                                <td>{{$notification->title}}</td>
                                <td>{{$notification->message}}</td>
                                <td>{{$notification->title}}</td>
                                <td>{{$notification->created_at}}</td>
                                <td>
                                    <button class="text-danger btn btn-light" onclick="remove({{$notification->id}})">حذف</button>
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

@stop

@section('script')
    <script>

        $('input[type=checkbox][name=head_fix]').change(function () {
            if (this.checked) {
                $('#head_fix').slideDown();
                $('#head_fix select').prop('disabled', false);
                $('input[type=checkbox][name=head_close]').prop('checked', false);
                $('#head_close').slideUp();
                $('#head_close select').prop('disabled', true);
            } else{
                $('#head_fix').slideUp();
                $('#head_fix select').prop('disabled', true);
            }
        });

        $('input[type=checkbox][name=head_close]').change(function () {
            if (this.checked) {
                $('#head_close').slideDown();
                $('#head_close select').prop('disabled', false);
                $('input[type=checkbox][name=head_fix]').prop('checked', false);
                $('#head_fix').slideUp();
                $('#head_fix select').prop('disabled', true);
            } else{
                $('#head_close').slideUp();
                $('#head_close select').prop('disabled', true);
            }
        });

        $('input[type=checkbox][name=sms]').change(function () {
            if (this.checked) {
                $('#kavenegar').slideDown();
            } else{
                $('#kavenegar').slideUp();
            }
        });

        $(document).ready(function () {
            $('form').ajaxForm({
                beforeSend: function () {
                    loading();
                },
                complete: function (data) {
                    data = data.responseJSON;
                    $('form').removeClass('disable-block');
                    if (data.status == true) {
                        swal.fire({
                            icon: 'success',
                            title: "انجام شد",
                            html: data.message,
                            confirmButtonText: "تایید",
                            onClose: () => {
                                location.reload()
                            }
                        });
                    } else {
                        swal.fire({
                            icon: 'error',
                            title: "توجه",
                            html: data.message,
                            confirmButtonText: "تایید",
                        })
                    }
                    unloading();
                }
            });
        });


        function remove(id){
            swal.fire({
                title: "از حدف اطمینان دارید؟",
                icon: "info",
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: "آره",
                confirmButtonColor:"#d22346",
                cancelButtonText: "نه",
                preConfirm: () => {
                    return $.ajax({
                        url: "{{asset('').env('PanelPrefix')}}/notification",
                        type: 'DELETE',
                        data: {_token: "{{ csrf_token() }}",id:id},
                    });
                }
            }).then((data) => {
                if(data.value.status==true){
                    swal.fire({
                        title:'انجام شد!',
                        icon: 'success',
                        text: data.value.messege,
                    }).then(function () {
                        location.reload()
                    });
                }
                else{
                    swal("خطا",  data.value.messege  , "error");
                }
            });
        }

    </script>
@stop
