@extends('admin.layouts.master')
@section('title', 'سفارشات')
@section('css')
    <link rel="stylesheet" type="text/css" href="{{asset('')}}app-assets/vendors/css/tables/datatable/datatables.min.css">
    <link rel="stylesheet" href="{{asset('')}}app-assets/css/plugins/persian-datepicker.min.css">
@stop

@section('content')
    <div class="row">
        <div class="card mb-4 w-100">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div class="card-title mb-3">سفارشات</div>
                    <button class="btn btn-light" type="button" data-bs-toggle="collapse" data-bs-target="#collapseExample" aria-expanded="false" aria-controls="collapseExample">
                        <i class="mdi mdi-filter"></i> فیلترکردن
                    </button>
                </div>
                <div class="collapse mt-4" id="collapseExample">
                    <div class="card border shadow-none card-body text-muted mb-0">
                        <div class="row">
                            <div class="col-md-2 mb-2 form-group mb-md-0 offset-md-2">
                                <label>نوع سفارش</label>
                                <select class="form-control" id="model">
                                    <option value="" selected>خرید و فروش</option>
                                    <option value="buy">خرید</option>
                                    <option value="sell">فروش</option>
                                </select>
                            </div>
                            <div class="col-md-2 mb-2 form-group mb-md-0">
                                <label>نوع ارز</label>
                                <select class="form-control" id="currency">
                                    <option value="" selected>همه ارزها</option>
                                    <option value="PSVouchers">ووچرز</option>
                                    <option value="perfectmoney">پرفکت مانی</option>
                                    <option value="PMvoucher">ووچر پرفکت مانی</option>
                                    <option value="webmoney">وب مانی</option>
                                    <option value="bitcoin">بیتکوین</option>
                                </select>
                            </div>
                            <div class="col-md-2 mb-2 form-group mb-md-0">
                                <label class="ul-form__label">از تاریخ</label>
                                <div class="input-group">
                                    <input type="text" class="form-control text-center font-small-2 px-0" id="date_start" placeholder="تاریخ">
                                    <span class="input-group-text"><i class="mdi mdi-calendar"></i></span>
                                </div>
                            </div>
                            <div class="col-md-2 mb-2 form-group mb-md-0">
                                <label class="ul-form__label">تا تاریخ</label>
                                <div class="input-group">
                                    <input type="text" class="form-control text-center font-small-2 px-0" id="date_stop" placeholder="تاریخ">
                                    <span class="input-group-text"><i class="mdi mdi-calendar"></i></span>
                                </div>
                            </div>
                            <div class="clearfix w-100"></div>
                            <div class="col-md-2 mb-2 form-group mb-md-0 mt-md-2 offset-md-2 d-none">
                                <label>وضعیت سفارش</label>
                                <select class="form-control" id="status">
                                    <option value="" selected>همه</option>
                                    <option value="معلق">معلق</option>
                                    <option value="پرداخت شده">پرداخت شده</option>
                                    <option value="در حال انتقال ارز">در حال انتقال ارز</option>
                                    <option value="منتقل شده">منتقل شده</option>
                                    <option value="در حال پردازش">در حال پردازش</option>
                                    <option value="رد شده">رد شده</option>
                                    <option value="در دست اقدام">در دست اقدام (خرید محصول)</option>
                                    <option value="انجام شده">انجام شده (خرید محصول)</option>
                                    <option value="معلق,پرداخت شده">معلق و پرداخت شده</option>
                                    <option value="معلق,عودت">معلق و عودت شده</option>
                                </select>
                            </div>
                            <div class="col-md-2 mb-2 form-group mb-md-0 mt-md-2 offset-md-2">
                                <label>مبلغ از</label>
                                <input type="text" class="form-control text-center ltr-dir" id="amount_start" placeholder="مبلغ از">
                            </div>
                            <div class="col-md-2 mb-2 form-group mb-md-0 mt-md-2">
                                <label>تا مبلغ</label>
                                <input type="text" class="form-control text-center ltr-dir" id="amount_stop" placeholder="تا مبلغ">
                            </div>

                            <div class="col-md-2 mb-2 form-group mb-md-0 mt-md-2">
                                <label>بانک</label>
                                <select name="bank_name" id="bank_name" class="form-control text-center">
                                    <option value="" selected>همه</option>
                                    <option value="بانک ملی">بانک ملی</option>
                                    <option value="بانک ملت">بانک ملت</option>
                                    <option value="غیر ملت">غیر از بانک ملت</option>
                                    <option value="بانک سپه">بانک سپه</option>
                                    <option value="بانک تجارت">بانک تجارت</option>
                                    <option value="بانک مسکن">بانک مسکن</option>
                                    <option value="بانک صادرات">بانک صادرات</option>
                                    <option value="بانک کشاورزی">بانک کشاورزی</option>
                                    <option value="بانک رفاه">بانک رفاه</option>
                                    <option value="بانک سامان">بانک سامان</option>
                                    <option value="بانک پارسیان">بانک پارسیان</option>
                                    <option value="بانک پاسارگاد">بانک پاسارگاد</option>
                                    <option value="بانک سینا">بانک سینا</option>
                                    <option value="بانک دی">بانک دی</option>
                                    <option value="بانک شهر">بانک شهر</option>
                                    <option value="بانک سرمایه">بانک سرمایه</option>
                                    <option value="بانک اقتصاد نوین">بانک اقتصاد نوین</option>
                                    <option value="بانک مهر اقتصاد">بانک مهر اقتصاد</option>
                                    <option value="بانک قرض الحسنه مهر ایران">بانک قرض الحسنه مهر ایران</option>
                                    <option value="بانک انصار">بانک انصار</option>
                                    <option value="بانک ایران زمین">بانک ایران زمین</option>
                                    <option value="بانک حکمت ایرانیان">بانک حکمت ایرانیان</option>
                                    <option value="پست بانک">پست بانک</option>
                                    <option value="بانک گردشگری">بانک گردشگری</option>
                                    <option value="بانک کارآفرین">بانک کارآفرین</option>
                                    <option value="بانک قوامین">بانک قوامین</option>
                                    <option value="بانک توسعه صادرات ایران">بانک توسعه صادرات ایران</option>
                                    <option value="بانک توسعه تعاون">بانک توسعه تعاون</option>
                                    <option value="موسسه اعتباری کوثر">موسسه اعتباری کوثر</option>
                                    <option value="موسسه اعتباری توسعه">موسسه اعتباری توسعه</option>
                                    <option value="سایر">سایر</option>
                                </select>
                            </div>
                            <div class="clearfix w-100"></div>
                            <div class="col-md-2 mb-2 form-group mb-md-0 mt-md-2 offset-md-4 d-none">
                                <label>سفارش از طریق</label>
                                <select class="form-control" id="via">
                                    <option value="" selected>همه</option>
                                    <option value="website">وب سایت</option>
                                    <option value="robot">ربات تلگرام</option>
                                    <option value="android">اپلیکیشن اندروید</option>
                                </select>
                            </div>
                            <div class="my-4 text-center">
                                <label for="picker1"></label>
                                <button class="btn btn-info" onclick="search()">فیلتر</button>
                            </div>
                        </div>
                    </div>
                </div>

                <p class="text-center font-weight-bold mt-4 mb-4">
                    جمع کل مبلغ: <span id="TotalAmount"> 0 </span>
                    <br>
                    <small class="text-11">جمع کل رکورد های صفحه جاری را مشاهده میکنید و برای جمع کل همه نمایش تعدا را روی All بگذارید</small>
                    <span id="shaba"></span>
                </p>

                <table class="table table-striped alt-pagination dataex-fixh-basic w-100">
                    <thead class="table-light">
                    <tr>
                        <th class="text-center w-1">#</th>
                        <th class="text-center">نام مشتری</th>
                        <th class="text-center w-1">ارز</th>
                        <th class="text-center">نوع سفارش</th>
                        <th class="text-center">مقدار</th>
                        <th class="text-center">تاریخ و ساعت ثبت</th>
                        <th class="text-center">وضعیت</th>
                        <th class="text-center">مبلغ سفارش</th>
                        <th class="text-center w-1">جزئیات</th>
                    </tr>
                    </thead>
                    <tbody  class="text-center">

                    </tbody>
                </table>

            </div>
        </div>
    </div>
@stop

@section('js')
    <script src="{{asset('')}}js/tables/datatable/datatables.min.js" type="text/javascript"></script>
    <script src="{{asset('')}}app-assets/vendors/js/persian-date.min.js" type="text/javascript"></script>
    <script src="{{asset('')}}app-assets/vendors/js/persian-datepicker.min.js" type="text/javascript"></script>
    <script src="{{asset('')}}app-assets/vendors/js/digitbox.min.js"></script>
@stop

@section('script')
    <script>
        $('#amount_start,#amount_stop').digitbox({separator:',', grouping:1, truevalue:1});


        $('#date1').persianDatepicker({
            altField: '#date_start',
            altFormat: 'YYYY/MM/DD HH:mm',
            initialValue: false,
            observer: true,
            format: 'YYYY/MM/DD HH:mm',
            timePicker: {
                enabled: true,
                second:{
                    enabled: false,
                }
            }
        });

        $('#date2').persianDatepicker({
            altField: '#date_stop',
            altFormat: 'YYYY/MM/DD HH:mm',
            initialValue: false,
            observer: true,
            format: 'YYYY/MM/DD HH:mm',
            timePicker: {
                enabled: true,
                second:{
                    enabled: false,
                }
            }
        });


        $('.alt-pagination').DataTable({
            "pagingType": "full_numbers",
            "scrollX": true,
            "language": {
                "url": "{{asset('')}}app-assets/vendors/js/datatable-Persian.json",
            },
            "order": [[ 5, 'desc' ]],
            "ajax": '{{asset('').env('PanelPrefix')}}/orders/list',
            "processing": true,
            "serverSide": true,
            "columns": [
                { "data": "0"},
                { "data": function ( data) {return data['1']+' '+data['11']}, "orderable":false},
                { "data": "2","searchable": false},
                { "data": "3" },
                { "data": "4"},
                { "data": "5" },
                { "data": "6" },
                { "data": "7" },
                { "data": "8" , "orderable":false},
            ],
            "columnDefs": [
                {
                    "targets": 0,
                    "searchable": false,
                    "orderable": true,
                    "data": null,
                    "render": function (data, type, full, meta) {
                        return meta.settings._iDisplayStart + meta.row + 1;
                    }
                }
            ],
            "displayLength": 25,
            dom: "<'top'><'row'<'col-md-5 col-12 mt-1'B><'col-md-7 col-12 d-flex ltr-dir'<'mx-1 mt-1'l><'rtl-dir'f>>><'bottom'>rt<'row'<'col-md-5 col-12'i><'col-md-7 col-12'p>><'clear'>",
            buttons: [
                {
                    extend: 'print',
                    text: '<i class="mdi mdi-printer"></i> پرینت',
                    className: 'btn btn-outline-secondary',
                    title: '',
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5, {
                            'data': 'batch_notes', "render": function (data, type, row, meta) {
                                return data
                            },
                        }]
                    }
                },
                {
                    extend: 'excel',
                    text: '<i class="mdi mdi-file-excel"></i> اکسل',
                    className: 'btn btn-outline-secondary',
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5, {
                            'data': 'batch_notes', "render": function (data, type, row, meta) {
                                return data
                            },
                        }]
                    }
                },
                {
                    text: '<i class="ft-trash-2"></i> حذف همه معلق ها',
                    className: 'btn btn-outline-secondary',
                    action: function () {
                        RemoveAllMoalagh();
                    }
                }
            ],
            aLengthMenu: [
                [25, 50, 100, 200, -1],
                [25, 50, 100, 200, "All"]
            ],
            "fnDrawCallback": function(oSettings) {
                page = $('.alt-pagination').DataTable().page.info()['page'];
                if (page ==0 && $('.alt-pagination tr').length < 25) {
                    $('.dataTables_paginate,.dataTables_info').hide();
                }else
                    $('.dataTables_paginate,.dataTables_info').show();

            },"footerCallback": function ( row, data, start, end, display ) {
                var api = this.api(), data;

                // converting to interger to find total
                var intVal = function ( i ) {
                    return typeof i === 'string' ?
                        i.replace(/[\$,]/g, '')*1 :
                        typeof i === 'number' ?
                            i : 0;
                };

                // computing column Total of the complete result
                var AmountTotal = api
                    .column( 7 )
                    .data()
                    .reduce( function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0 );
                $('#TotalAmount').html(AmountTotal);


                $('#shaba').html('<br><button type="button" class="btn btn-sm btn-light" onclick="hesab()">لیست حساب </button>');
                $('#shaba').append('<button type="button" class="btn btn-sm btn-light m-1" onclick="shaba()" data-toggle="modal" data-target=".bd-example-modal-xl">لیست شبا</button>');
                $('#shaba').append('<button type="button" class="btn btn-sm btn-light" onclick="confirm()" data-toggle="modal" data-target=".bd-example-modal-xl">پرداخت گروهی</button>');


            },
        });

        var tableselectionDelete = $('.alt-pagination').DataTable();
        $('.selection-deletion-row tbody').on('click', 'tr', function () {
            if ($(this).hasClass('selected')) {
                $(this).removeClass('selected');
            } else {
                tableselectionDelete.$('tr.selected').removeClass('selected');
                $(this).addClass('selected');
            }
        });


        function search(){
            var tbl = $('.alt-pagination').DataTable();
            tbl.ajax.url("{{asset('').env('PanelPrefix')}}/orders/list?model="+ $("#model").val() + "&currency="+ $("#currency").val()+ "&via="+ $("#via").val()
                + "&date_start="+ $("#date_start").val() + "&date_stop="+ $("#date_stop").val() + "&status="+ $("#status").val()
                + "&amount_start="+ $("#amount_start").val() + "&amount_stop="+ $("#amount_stop").val() + "&bank_name="+ $("#bank_name").val() ).load();
        }

        function hesab() {
            var oData = tableselectionDelete.rows().data();
            var IDs = [];
            for (var i=0; i < oData.length ;i++){
                IDs.push( oData[i][0]);
            }
            window.open("{{asset('').env('PanelPrefix')}}/orders/hesab?IDs="+IDs+'&time='+ new Date().getTime(), '_blank');
        }

        function shaba() {
            var oData = tableselectionDelete.rows().data();
            var IDs = [];
            for (var i=0; i < oData.length ;i++){
                IDs.push( oData[i][0]);
            }
            window.open("{{asset('').env('PanelPrefix')}}/orders/shaba?IDs="+IDs+'&time='+ new Date().getTime(), '_blank');
        }

        function confirm() {
            var oData = tableselectionDelete.rows().data();
            var IDs = [];
            for (var i=0; i < oData.length ;i++){
                IDs.push( oData[i][0]);
            }
            window.open("{{asset('').env('PanelPrefix')}}/actions/orders/all-confirm?IDs="+IDs+'&time='+ new Date().getTime(), '_blank');
        }


        function RemoveAllMoalagh() {
            swal.fire({
                title: "از حذف همه سفارشات معلق دارید؟",
                text: "تمام سفارشات معلقی که 15 دقیقه از ثبت آن گذشته باشد حذف میشود!",
                icon: "info",
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: "آره",
                confirmButtonColor:"#d22346",
                cancelButtonText: "نه",
                preConfirm: () => {
                    return $.post("{{asset('').env('PanelPrefix')}}/orders/remove-all-moalagh",
                        { _token: "{{ csrf_token() }}"});
                }
            }).then((data) => {
                if(data.value.status==true){
                    swal.fire({
                        title:'انجام شد!',
                        icon: 'success',
                        text: data.value.messege,
                    }).then(function () {
                        $('.alt-pagination').DataTable().ajax.reload();
                    });
                }
                else{
                    swal("خطا",  data.value.messege  , "error");
                }
            });
        }
    </script>
@stop
