@extends('admin.layouts.master')
@section('title', 'گزارشات')
@section('css')
    <link rel="stylesheet" href="{{asset('')}}app-assets/css/plugins/persian-datepicker.min.css">

    <style>
        .height-500 {
            height: 500px !important;
        }
        .height-400 {
            height: 400px !important;
        }
        .height-300 {
            height: 300px !important;
        }
    </style>
@stop

@section('content')
    <div class="row">
        <div class="card mb-4 w-100">
            <div class="card-body">
                <div class="card-title mb-0">گزارشات در بازه زمانی</div>
                <p class="text-small text-muted">گزارشات داشبورد را در بازه زمانی مورد نظر مشاهده کنید</p>
                <div class="row mx-auto">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="ul-form__label"> گزارش از تاریخ</label>
                            <div class="input-group">
                                <input type="text" class="form-control text-center font-small-2 px-0" value="{{$date->start1}}" id="date_start" placeholder="تاریخ">
                                <span class="input-group-text"><i class="mdi mdi-calendar"></i></span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label class="ul-form__label">تا تاریخ</label>
                            <div class="input-group">
                                <input type="text" class="form-control text-center font-small-2 px-0" value="{{$date->stop1}}" id="date_stop" placeholder="تاریخ">
                                <span class="input-group-text"><i class="mdi mdi-calendar"></i></span>
                            </div>
                        </div>
                    </div>
                    <div class="my-4 text-center">
                        <button class="btn btn-primary btn btn-block" onclick="loading();load()">نمایش</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div id="load" style="display: none"></div>
@stop

@section('js')
    <script src="{{asset('')}}app-assets/vendors/js/persian-date.min.js" type="text/javascript"></script>
    <script src="{{asset('')}}app-assets/vendors/js/persian-datepicker.min.js" type="text/javascript"></script>
    <script src="{{asset('')}}app-assets/vendors/js/charts/chart.min.js" type="text/javascript"></script>
@stop

@section('script')
    <script>


        $(window).on("load", function(){
            loading();
            load();
        });

        new persianDate().format();

        $('#date1').persianDatepicker({
            altField: '#date_start',
            altFormat: 'YYYY/MM/DD HH:mm',
            initialValue: false,
            observer: true,
            format: 'YYYY/MM/DD HH:mm',
            initialValueType: 'persian',
            timePicker: {
                enabled: true,
                second:{
                    enabled: false,
                }
            }
        });

        $('#date2').persianDatepicker({
            altField: '#date_stop',
            altFormat: 'YYYY/MM/DD HH:mm',
            initialValue: false,
            observer: true,
            format: 'YYYY/MM/DD HH:mm',
            initialValueType: 'persian',
            timePicker: {
                enabled: true,
                second:{
                    enabled: false,
                }
            }
        })



        function load(){
            $('#load').load("{{asset('').env('PanelPrefix')}}/reports/load?date_start="+ $("#date_start").val().replace(" ", "%20") + "&date_stop="+ $("#date_stop").val().replace(" ", "%20") );
            $('#load').fadeOut()
            $('#load').fadeIn();
            unloading();
        }


    </script>
@stop
