@extends('admin.layouts.master')
@section('title', $result->user->name .' '.$result->user->family)

@section('css')
    <link rel="stylesheet" type="text/css" href="{{asset('')}}app-assets/vendors/css/charts/chartist.css">
    <link rel="stylesheet" type="text/css" href="{{asset('')}}app-assets/vendors/css/charts/chartist-plugin-tooltip.css">
    <link rel="stylesheet" type="text/css" href="{{asset('')}}app-assets/vendors/css/tables/datatable/datatables.min.css">
    <link rel="stylesheet" type="text/css" href="{{asset('')}}app-assets/css-rtl/plugins/charts/chartist.min.css">
    <link rel="stylesheet" href="{{asset('')}}app-assets/css/plugins/persian-datepicker.min.css">
    <link rel="stylesheet" href="{{asset('')}}app-assets/vendors/css/dropify.min.css">
    <style>
        .height-400 {
            height: 250px;
        }
    </style>
@stop

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">مشخصات</h4>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-4 col-xl-3">
            <div class="card overflow-hidden">
                <div class="card-body">
                    <div class="row">
                        <h5 class="font-size-15 text-truncate">{{$result->user->name .' '. $result->user->family}}</h5>
                        <p class="text-muted mb-0 text-truncate mb-3 ">{{ $result->user->mobile }}</p>
                        <div class="btn-group d-flex">
                            @if($result->user->access == 0)
                                <a class="btn btn-warning" href="#" onclick="unBlock()"><i class="ft-check"></i> آنبلاک</a>
                            @elseif($result->user->access == 1)
                                <a class="btn btn-warning" href="#" onclick="Block()"><i class="ft-x"></i> بلاک</a>
                            @endif
                                <button type="button" class="btn btn-danger btn-block btn  text-14" onclick="DeleteUser()">حذف کاربر</button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">مدیریت بخش‌های کاربری</h4>
                    <div class="nav flex-column nav-pills" id="v-pills-tab" role="tablist" aria-orientation="vertical">
                        <a class="nav-link mb-2 active" id="v-profile-tab" data-bs-toggle="pill" href="#v-profile" role="tab" aria-controls="v-profile" aria-selected="true">اطلاعات کلی کاربر</a>
                        <a class="nav-link mb-2" id="v-kyc-tab" data-bs-toggle="pill" href="#v-kyc" role="tab" aria-controls="v-kyc" aria-selected="false">مدارک شناسایی / احراز هویت</a>
                        <a class="nav-link mb-2" id="v-card-bank-tab" data-bs-toggle="pill" href="#v-card-bank" role="tab" aria-controls="v-card-bank" aria-selected="false">اطلاعات کارت های بانکی</a>
                        <a class="nav-link mb-2" id="v-wallet-tab" data-bs-toggle="pill" href="#v-wallet" role="tab" aria-controls="v-wallet" aria-selected="false">کیف پول های ارزی</a>
                        <a class="nav-link mb-2 " id="v-orders-tab" data-bs-toggle="pill" href="#v-orders" role="tab" aria-controls="v-orders" aria-selected="false">سفارشات کاربر</a>
                        <a class="nav-link mb-2" id="v-transactions-tab" data-bs-toggle="pill" href="#v-transactions" role="tab" aria-controls="v-transactions" aria-selected="false">تراکنش های مالی کاربر</a>
                        <a class="nav-link mb-2" id="v-referrals-tab" data-bs-toggle="pill" href="#v-referrals" role="tab" aria-controls="v-referrals" aria-selected="false">کسب درآمد کاربر</a>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-8 col-xl-9">
            @if($result->user->access == 0)
                <div class="row">
                    <div class="col-12">
                        <div class="w-100 alert alert-card alert-danger text-center" role="alert">
                            دسترسی این کاربر به دلیل "{{$result->user->access_reason}}" بلاک میباشد! <button class="btn btn  btn-warning mr-1" onclick="unBlock()">آنبلاک</button>
                        </div>
                    </div>
                </div>
            @endif

            @if($result->user->auth_img_confirm == 2)
                <div class="row">
                    <div class="col-12">
                        <div class="w-100 alert alert-card alert-warning text-center" role="alert">
                            مدرک شناسایی این کاربر آپلود شده است و منتظر تایید شما میباشد.
                        </div>
                    </div>
                </div>
            @elseif($result->user->auth_img_confirm == 3)
                <div class="row">
                    <div class="col-12">
                        <div class="w-100 alert alert-card alert-danger text-center" role="alert">
                            مدرک شناسایی این کاربر به علت "{{$result->user->auth_img_reason}}" رد شده است.
                        </div>
                    </div>
                </div>
            @endif
                <form id="edit" autocomplete="off" method="post" class="needs-validation" novalidate action="{{asset('').env('PanelPrefix')}}/users/{{$result->user->id}}/edit">
                    @csrf
                    <div class="tab-content text-muted mt-4 mt-md-0" id="v-pills-tabContent">
                        <div class="tab-pane fade show active" id="v-profile" role="tabpanel" aria-labelledby="v-profile-tab">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="">
                                        <div class="card mini-stats-wid">
                                            <div class="card-body">
                                                <div class="d-flex">
                                                    <div class="flex-shrink-0 me-3 align-self-center">
                                                        <i class="mdi mdi-shopping h2 text-success mb-0"></i>
                                                    </div>
                                                    <div class="flex-grow-1">
                                                        <p class="text-muted mb-2">تعداد خریدها</p>
                                                        <h5 class="mb-0">{{($result->CountBuy)}}</h5>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="">
                                        <div class="card mini-stats-wid">
                                            <div class="card-body">
                                                <div class="d-flex">
                                                    <div class="flex-shrink-0 me-3 align-self-center">
                                                        <i class="mdi mdi-send-circle h2 text-warning mb-0"></i>
                                                    </div>
                                                    <div class="flex-grow-1">
                                                        <p class="text-muted mb-2">تعداد فروش ها</p>
                                                        <h5 class="mb-0">{{($result->CountSell)}}</h5>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="">
                                        <div class="card mini-stats-wid">
                                            <div class="card-body">
                                                <div class="d-flex">
                                                    <div class="flex-shrink-0 me-3 align-self-center">
                                                        <i class="mdi mdi-cash-100 h2 text-info mb-0"></i>
                                                    </div>
                                                    <div class="flex-grow-1">
                                                        <p class="text-muted mb-2">مبلغ کل خرید ها</p>
                                                        <h5 class="mb-0">{{number_format($result->SumBuy)}}</h5>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="">
                                        <div class="card mini-stats-wid">
                                            <div class="card-body">
                                                <div class="d-flex">
                                                    <div class="flex-shrink-0 me-3 align-self-center">
                                                        <i class="mdi mdi-cash h2 text-info mb-0"></i>
                                                    </div>
                                                    <div class="flex-grow-1">
                                                        <p class="text-muted mb-2">مبلغ کل فروش ها</p>
                                                        <h5 class="mb-0">{{number_format($result->SumSell)}}</h5>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card">
                                    <div class="card-body">
                                        <h5 class="card-title mb-4">مشخصات فردی <small class="text-11">(ثبت نام از طریق: {{$result->user->register_via}} ) (کاربر:{{isset($result->user->telegram_id)? 'Telegram,':''}} {{isset($result->user->device)? 'Android,':''}} {{isset($result->user->remember_token) || $result->user->register_via=='Website'? 'WebSite,':''}})</small></h5>
                                        <div class="row">
                                            <div class="col-md-8 col-12 mx-auto">
                                                <div class="row my-3">
                                                    <div class="col-md-6 col-12 form-group mb-3">
                                                        <label>نام</label>
                                                        <input type="text" class="form-control text-center" name="name" required value="{{$result->user->name}}">
                                                    </div>
                                                    <div class="col-md-6 col-12 form-group mb-3">
                                                        <label>فامیل</label>
                                                        <input type="text" class="form-control text-center" name="family" required value="{{$result->user->family}}">
                                                    </div>
                                                    <div class="col-md-6 form-group mb-3">
                                                        <label>موبایل</label>
                                                        <input type="text" class="form-control text-center  numbers ltr-dir" name="mobile" required value="{{$result->user->mobile}}">
                                                    </div>
                                                    <div class="col-md-6 form-group mb-3">
                                                        <label>ایمیل</label>
                                                        <input type="email" class="form-control text-center ltr-dir" name="email" value="{{$result->user->email}}" placeholder="ایمیل">
                                                    </div>
                                                    <div class="col-md-12 form-group mb-3">
                                                        <label>تلفن ثابت <small>پر بودن این فیلد یعنی از طریق تماس تایید شده است</small></label>
                                                        <input type="text" name="phone" id="phone"
                                                               class="form-control numbers text-center ltr-dir"
                                                               placeholder="تلفن 02123456789" maxlength="11" minlength="11" value="{{$result->user->phone}}"/>
                                                        <div class="invalid-feedback">تلفن را درج کنید</div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-8 mx-auto">
                                                <div class="col-md-12 p-0 form-group mb-3">
                                                    <label>موجودی</label>
                                                    <input type="text" name="wallet" id="wallet"
                                                           class="form-control text-center ltr-dir"
                                                           placeholder="موجودی" required maxlength="13" value="{{number_format($result->user->wallet)}}"/>
                                                    <div class="invalid-feedback">موجودی را درج کنید</div>
                                                </div>
                                                <div class="col-md-12 p-0 form-group mb-3">
                                                    <label>حداکثر خرید روزانه</label>
                                                    <input type="text" name="daily_buy" id="daily_buy"
                                                           class="form-control text-center comma ltr-dir"
                                                           placeholder="حداکثر خرید روزانه" required maxlength="13" value="{{ $result->user->daily_buy }}"/>
                                                    <div class="invalid-feedback">حداکثر خرید روزانه را درج کنید</div>
                                                    <div class="text-center mt-1">
                                                        <button type="button" class="btn btn-sm btn-outline-secondary " onclick="ChangeDailyBuy(1000000)">1 میلیون </button>
                                                        <button type="button" class="btn btn-sm btn-outline-secondary" onclick="ChangeDailyBuy(3000000)">3 میلیون </button>
                                                        <button type="button" class="btn btn-sm btn-outline-secondary" onclick="ChangeDailyBuy(5000000)">5 میلیون </button>
                                                        <button type="button" class="btn btn-sm btn-outline-secondary" onclick="ChangeDailyBuy(20000000)">20 میلیون </button>
                                                        <button type="button" class="btn btn-sm btn-outline-secondary" onclick="ChangeDailyBuy(50000000)">50 میلیون </button>
                                                        <button type="button" class="btn btn-sm btn-outline-secondary" onclick="ChangeDailyBuy(100000000)">100 میلیون </button>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-6 pl-md-1 form-group mb-3">
                                                        <label>تغییر رمز عبور<span class="text-10">(در صورت نیاز)</span></label>
                                                        <input type="text" name="password" id="password"
                                                               class="form-control text-center ltr-dir"
                                                               placeholder="رمز عبور"/>
                                                    </div>
                                                    <div class="col-md-6 pr-md-1 form-group mb-3">
                                                        <label>ورود دو مرحله ای</label>
                                                        <select class="city form-control" name="twofa" id="twofa">
                                                            <option value="" @if($result->user->sms2fa == 0 && $result->user->google2fa =='') selected @endif>غیر فعال</option>
                                                            <option value="google2fa" @if($result->user->google2fa !='') selected @endif>از طریق گوگل</option>
                                                            <option value="sms2fa" @if($result->user->sms2fa ==1) selected @endif>از طریق پیامک</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-md-12 p-0 form-group">
                                                    <label>موبایل معرف <span class="text-10">(برای حذف معرف فیلد را خالی بگذارید و برای تغییر شماره موبایل معرف را درج کنید)</span></label>
                                                    <input type="text" name="invitation" id="invitation"
                                                           class="form-control numbers text-center ltr-dir"
                                                           placeholder="موبایل معرف" value="{{$result->user->invitation}}"/>
                                                    @if(isset($result->user->invitationName))نام معرف: {{$result->user->invitationName}} @endif
                                                </div>
                                                <div class="progress mt-3 w-100" style="display: none">
                                                    <div class="progress-bar bg-info progress-bar-striped progress-bar-animated" role="progressbar"
                                                         aria-valuemax="100" style="width:100%">0%
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row d-flex mt-3">
                                            <div class="text-center">
                                                <button type="submit" class="btn btn-primary">ثبت تغییرات</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="v-kyc" role="tabpanel" aria-labelledby="v-kyc-tab">
                            <div class="row">
                                <div class="card">
                                    <div class="card-body">
                                        <h5 class="card-title mb-4">احراز هویت</h5>
                                        <div class="row">
                                            <div class="mb-3 mx-auto">
                                                <div class="card-title mb-0">مدارک شناسایی
                                                    @if($result->user->auth_img_confirm == 1)<span class="badge bg-success"><i class="icon-check"></i> تایید شده</span>
                                                    @elseif($result->user->auth_img_confirm == 2)
                                                        <span class="badge bg-warning"> در انتظار بررسی</span>
                                                    @elseif($result->user->auth_img_confirm == 3)
                                                        <span class="badge bg-danger" data-toggle="tooltip" data-original-title="{{$result->user->auth_img_reason}}"> رد شده</span>
                                                    @endif
                                                </div>
                                                <div class="row mb-5">
                                                    <div class="col-md-6 form-group mb-3">
                                                        <label>کد ملی</label>
                                                        <input type="text" class="form-control text-center numbers ltr-dir" value="{{$result->user->code_meli}}" name="codemeli" id="codemeli" placeholder="کد ملی">
                                                        <div class="invalid-feedback">کد ملی را درج کنید</div>
                                                    </div>

                                                    <div class="col-md-6 form-group mb-3">
                                                        <label>تاریخ تولد</label>
                                                        <div class="input-group">
                                                            <input type="text" class="form-control ltr-dir text-center font-small-3 px-0" name="DateBirth" id="DateBirth" value="{{$result->user->date_birth}}">
                                                            <span class="input-group-text"><i class="mdi mdi-calendar"></i></span>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-8 mx-auto">
                                                        <label class="w-100"> تصویر مدارک @if($result->user->auth_img)
                                                                <a href="{{asset('')}}{{$result->user->auth_img}}" target="_blank">(<i class="icon-cloud-download"></i>دانلود)</a>@endif
                                                        </label>
                                                        <input type="file" id="auth_img" name="auth_img" class="dropify" data-height="200"
                                                               data-allowed-file-extensions="jpg jpeg png"
                                                               @if($result->user->auth_img) data-default-file="{{asset('')}}{{$result->user->auth_img}}"@endif/>
                                                        <div class="invalid-feedback">تصویر کارت ملی را درج کنید(jpg,png)</div>
                                                        @if($result->user->auth_img)
                                                            <div class="text-center mt-1">
                                                                @if($result->user->auth_img_confirm != 1)
                                                                    <button type="button" class="btn btn-outline-success btn-sm" onclick="confirmImage('auth_img',1)">تایید</button>
                                                                @endif
                                                                @if($result->user->auth_img_confirm != 3)
                                                                    <button type="button" class="btn btn-outline-danger btn-sm" onclick="confirmImage('auth_img',3)">رد کردن</button>
                                                                @endif
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>
                                                <div class="row my-3">
                                                    <div class="card-title mb-0">تصویر سلفی
                                                        @if($result->user->selfie_img_confirm == 1)<span class="badge bg-success"><i class="icon-check"></i> تایید شده</span>
                                                        @elseif($result->user->selfie_img_confirm == 2)
                                                            <span class="badge bg-warning"> در انتظار بررسی</span>
                                                        @elseif($result->user->selfie_img_confirm == 3)
                                                            <span class="badge bg-danger" data-bs-toggle="tooltip" data-original-title="{{$result->user->selfie_img_reason}}"> رد شده</span>
                                                        @endif
                                                    </div>
                                                    <div class="col-lg-8 mx-auto">
                                                        <div class="mb-3">
                                                            <label class="w-100 mt-1"> تصویر سلفی @if($result->user->selfie_img)
                                                                    <a href="{{asset('')}}{{$result->user->selfie_img}}" target="_blank">(<i class="icon-cloud-download"></i>دانلود)</a>@endif
                                                            </label>
                                                            @if($result->user->selfie_img)
                                                                <img src="{{asset('')}}{{$result->user->selfie_img}}" width="500px">
                                                            @else
                                                                <input type="file" id="selfie_img" name="selfie_img" class="dropify" data-height="280"
                                                                       data-allowed-file-extensions="jpg jpeg png"
                                                                       @if($result->user->selfie_img) data-default-file="{{asset('')}}{{$result->user->selfie_img}}"@endif/>
                                                                <div class="invalid-feedback">تصویر کارت ملی را درج کنید(jpg,png)</div>
                                                            @endif

                                                            @if($result->user->selfie_img)
                                                                <div class="text-center mt-1">
                                                                    @if($result->user->selfie_img_confirm != 1)
                                                                        <button type="button" class="btn btn-outline-success btn-sm" onclick="confirmImage('selfie_img',1)">تایید</button>
                                                                    @endif
                                                                    @if($result->user->selfie_img_confirm != 3)
                                                                        <button type="button" class="btn btn-outline-danger btn-sm" onclick="confirmImage('selfie_img',3)">رد کردن</button>
                                                                    @endif
                                                                </div>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row d-flex mt-3">
                                            <div class="text-center">
                                                <button type="submit" class="btn btn-primary">ثبت تغییرات</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="v-card-bank" role="tabpanel" aria-labelledby="v-card-bank-tab">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex mb-4 justify-content-between">
                                        <div class="card-title mb-0">اطلاعات کارت های بانکی</div>
                                        <button type="button" class="btn btn-light" data-bs-toggle="modal" data-bs-target="#AddCardBank">افزودن کارت بانکی</button>
                                    </div>
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-hover">
                                            <thead class="thead-default">
                                            <tr>
                                                <th class="text-center">#</th>
                                                <th class="text-center">بانک</th>
                                                <th class="text-center">شماره کارت</th>
                                                <th class="text-center">تاریخ ثبت</th>
                                                <th class="text-center">وضعیت</th>
                                                <th class="text-center">عملیات</th>
                                            </tr>
                                            </thead>
                                            <tbody class="text-center">
                                            @php $i=1 @endphp
                                            @foreach($result->card as $card)
                                                <tr>
                                                    <td scope="row" class="sans-serif">{{$i}}</td>
                                                    <td>{{$card->bank_name}}</td>
                                                    <td class="sans-serif text-12">{{$card->card_number}}</td>
                                                    <td class=" text-12">{{$card->date}} {{$card->via}}</td>
                                                    @if($card->confirm == 0)
                                                        <td><span class="badge badge-pill bg-warning font-weight-light">منتظر تایید</span></td>
                                                    @elseif($card->confirm == 1)
                                                        <td>
                                                            <span class="badge badge-pill bg-success font-weight-light">تایید شده</span>
                                                            @if(isset($card->admin))<p class="m-0"><small>توسط {{$card->admin->name}}</small></p>@endif
                                                        </td>
                                                    @else
                                                        <td>
                                                            <span class="badge badge-pill bg-danger font-weight-light">رد شده</span>
                                                            @if(isset($card->admin))<p class="m-0"><small>توسط {{$card->admin->name}}</small></p>@endif
                                                        </td>
                                                    @endif
                                                    <td>
                                                        <div class="btn-group">
                                                            <button type="button" class="btn btn-outline-primary btn-sm" data-bs-toggle="modal" data-bs-target="#myModal{{ $card->id }}">
                                                                <span class="caret">عملیات</span>
                                                            </button>
                                                        </div>
                                                    </td>
                                                </tr>
                                                @php $i++ @endphp
                                            @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="v-wallet" role="tabpanel" aria-labelledby="v-wallet-tab">
                            <div class="card mb-4 w-100">
                                <div class="card-body">
                                    <div class="card-title mb-2">اطلاعات کیف پول های ارزی</div>
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-hover">
                                            <thead class="thead-default">
                                            <tr>
                                                <th class="text-center">#</th>
                                                <th class="text-center">نام ارز</th>
                                                <th class="text-center">آدرس کیف پول</th>
                                                <th class="text-center">تاریخ ثبت</th>
                                                <th class="text-center">وضعیت</th>
                                                <th class="text-center">عملیات</th>
                                            </tr>
                                            </thead>
                                            <tbody class="text-center">
                                            @php $i=1 @endphp
                                            @foreach($result->wallet as $wallet)
                                                <tr>
                                                    <td scope="row" class="sans-serif">{{ $i }}</td>
                                                    <td>{{ $wallet->coin_name }}</td>
                                                    <td>{{ $wallet->wallet }}</td>
                                                    <td class=" text-12">{{$wallet->date}} {{ $wallet->via }}</td>
                                                    @if($wallet->confirm == 0)
                                                        <td><span class="badge bg-warning font-weight-light">منتظر تایید</span></td>
                                                    @elseif($wallet->confirm == 1)
                                                        <td>
                                                            <span class="badge bg-success font-weight-light">تایید شده</span>
                                                            @if(isset($wallet->admin))<p class="m-0"><small>توسط {{ $wallet->admin->name }}</small></p>@endif
                                                        </td>
                                                    @else
                                                        <td>
                                                            <span class="badge bg-danger font-weight-light">رد شده</span>
                                                            @if(isset($wallet->admin))<p class="m-0"><small>توسط {{ $wallet->admin->name }}</small></p>@endif
                                                        </td>
                                                    @endif
                                                    <td>
                                                        <div class="btn-group">
                                                            <button type="button" class="btn btn-outline-primary btn-sm" data-bs-toggle="modal" data-bs-target="#myModal{{ $wallet->id }}">
                                                                <span class="caret">عملیات</span>
                                                            </button>
                                                        </div>
                                                    </td>
                                                </tr>
                                                @php $i++ @endphp
                                            @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane fade " id="v-orders" role="tabpanel" aria-labelledby="v-orders-tab">
                            <div class="card">
                                <div class="card-body">
                                    <div class="card-title mb-4">سفارشات کاربر</div>
                                    <table class="table table-striped table-bordered alt-pagination selection-deletion-row w-100" id="orders">
                                        <thead>
                                        <tr>
                                            <th class="text-center w-1">#</th>
                                            <th class="text-center w-1">ارز</th>
                                            <th class="text-center ">نوع سفارش</th>
                                            <th class="text-center">مقدار</th>
                                            <th class="text-center">تاریخ و ساعت ثبت</th>
                                            <th class="text-center">وضعیت</th>
                                            <th class="text-center">مبلغ سفارش</th>
                                            <th class="text-center">جزئیات</th>
                                        </tr>
                                        </thead>
                                        <tbody  class="text-center">

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="v-transactions" role="tabpanel" aria-labelledby="v-transactions-tab">
                            <div class="card">
                                <div class="card-body">
                                    <div class="card-title mb-3">تراکنش های مالی کاربر</div>
                                    <table class="table table-striped table-bordered alt-pagination selection-deletion-row dataex-fixh-basic w-100"
                                           id="finance">
                                        <thead>
                                        <tr>
                                            <th class="text-center">#</th>
                                            <th class="text-center ">نام کاربر</th>
                                            <th class="text-center ">نوع</th>
                                            <th class="text-center">مبلغ</th>
                                            <th class="text-center">موجودی</th>
                                            <th class="text-center">تاریخ و ساعت ثبت</th>
                                            <th class="text-center">شرح</th>
                                            <th class="text-center">وضعیت</th>
                                            <th class="text-center">جزئیات</th>
                                        </tr>
                                        </thead>
                                        <tbody  class="text-center">
                                        </tbody>
                                    </table>
                                    <div id="areaGradient" class="height-400"></div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="v-referrals" role="tabpanel" aria-labelledby="v-referrals-tab">
                            <div class="card">
                                <div class="card-body">
                                    <div class="card-title mb-0">کسب درآمد کاربر</div>
                                    <p class=" mt-3">لیست کاربرانی که این کاربر معرفی کرده است</p>
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-hover">
                                            <thead class="thead-default">

                                            <tr>
                                                <th class="text-center">#</th>
                                                <th class="text-left">نام و فامیل</th>
                                                <th class="text-center">موبایل</th>
                                                <th class="text-center">عضویت</th>
                                                <th class="text-center">تعداد خرید</th>
                                            </tr>
                                            </thead>
                                            <tbody class="text-center">
                                            @php $i=1 @endphp
                                            @foreach($result->invitationUser as $invitation)
                                                <tr>
                                                    <td scope="row" class="sans-serif">{{$i}}</td>
                                                    <td>{{$invitation->name}} {{$invitation->family}}</td>
                                                    <td><a class="typo_link text-info" href="{{asset('').env('PanelPrefix')}}/users/{{$invitation->id}}">{{$invitation->mobile}}</a></td>
                                                    <td>{{$invitation->date}}</td>
                                                    <td>{{$invitation->order}}</td>
                                                </tr>
                                                @php $i++ @endphp
                                            @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                    <p class="mt-5">لیست پورسانت های دریافت شده این کاربر از طریق معرفی را مشاهده میکنید.</p>
                                    <table class="table table-striped table-bordered alt-pagination selection-deletion-row dataex-fixh-basic w-100"
                                           id="tbl-invitation">
                                        <thead>
                                        <tr>
                                            <th class="text-center">#</th>
                                            <th class="text-center">نام و فامیل</th>
                                            <th class="text-center">موبایل</th>
                                            <th class="text-center">سفارش</th>
                                            <th class="text-center">مبلغ سفارش</th>
                                            <th class="text-center">پورسانت کاربر</th>
                                            <th class="text-center">تاریخ و ساعت ثبت</th>
                                        </tr>
                                        </thead>
                                        <tbody class="text-center">

                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
        </div>
    </div>

    <!-- Transaction Modal -->
    @foreach($result->card as $card)
        <div id="myModal{{ $card->id  }}" class="modal fade" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="myModalLabel">جزییات درخواست</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="text-center">
                            <h5>وضعیت اطلاعات بانکی</h5>
                            <span class="text-center">
                                @if($card->confirm == 0)
                                    <span class="badge badge-pill bg-warning font-weight-light">منتظر تایید</span>
                                @elseif($card->confirm == 1)
                                    <span class="badge badge-pill bg-success font-weight-light">تایید شده</span>
                                    @if(isset($card->admin))
                                        <p class="m-0"><small>توسط {{$card->admin->name}}</small></p>
                                    @endif
                                @else
                                    <span class="badge badge-pill bg-danger font-weight-light">رد شده</span>
                                    @if(isset($card->admin))
                                        <p class="m-0"><small>توسط {{$card->admin->name}}</small></p>
                                    @endif
                                @endif
                            </span>
                        </div>
                        <div class="table-responsive mt-4">
                            <table class="table align-middle mb-0">
                                <tbody>
                                <tr>
                                    <td colspan="2" class="text-center bg-light">
                                        <h5 class="text-muted mb-0">اطلاعات حساب بانکی</h5>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="text-muted mb-0">نام بانک</p>
                                    </td>
                                    <td>
                                        <h6 class="mb-0">{{ $card->bank_name }}</h6>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="text-muted mb-0">شماره کارت</p>
                                    </td>
                                    <td>
                                        <h6 class="mb-0">{{ $card->card_number }}</h6>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="text-muted mb-0">شماره حساب</p>
                                    </td>
                                    @if(isset($card->account_number) && isset($card->shaba))
                                        <td class="sans-serif text-12">{{$card->account_number}}</td>
                                    @else
                                        <td colspan="2"><p class="text-primary cursor-pointer" onclick="finotechCardBank({{$card->id}},'iban')">گرفتن از api</p></td>
                                    @endif
                                </tr>
                                <tr>
                                    <td>
                                        <p class="text-muted mb-0">شماره شبا</p>
                                    </td>
                                    @if(isset($card->account_number) && isset($card->shaba))
                                        <td class="sans-serif text-12">{{ $card->shaba }}</td>
                                    @else
                                        <td colspan="2"><p class="text-primary cursor-pointer" onclick="finotechCardBank({{$card->id}},'iban')">گرفتن از api</p></td>
                                    @endif
                                </tr>
                                <tr>
                                    <td>
                                        <p class="text-muted mb-0">تاریخ ثبت</p>
                                    </td>
                                    <td>
                                        <h6 class="mb-0">{{$card->date}} {{$card->via}}</h6>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="modal-footer d-flex justify-content-between">
                        <div>
                            @if($card->confirm != 1)
                                <button type="button" class="btn btn-success" onclick="CardConform({{$card->id}},1)">تایید</button>
                            @endif
                            @if($card->confirm != 3)
                                <button type="button" class="btn btn-danger" onclick="CardConform({{$card->id}},3)">رد کردن</button>
                            @endif
                        </div>
                        <div>
                            <button type="button" class="btn btn-light waves-effect" data-bs-toggle="modal" data-bs-target="#EditCardModal" onclick="CardEdit({{$card->id}})">ویرایش</button>
                            <button type="button" class="btn btn-light waves-effect" data-bs-dismiss="modal">بستن</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endforeach

    @foreach($result->wallet as $wallet)
        <div id="myModal{{ $wallet->id  }}" class="modal fade" tabindex="-1" aria-labelledby="myModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="myModalLabel">جزییات درخواست</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="text-center">
                            <h5>وضعیت کیف پول ارزی</h5>
                            <span class="text-center">
                                @if($wallet->confirm == 0)
                                    <td><span class="badge bg-warning font-weight-light">منتظر تایید</span></td>
                                @elseif($wallet->confirm == 1)
                                    <td>
                                        <span class="badge bg-success font-weight-light">تایید شده</span>
                                        @if(isset($wallet->admin))<p class="m-0"><small>توسط {{$wallet->admin->name}}</small></p>@endif
                                    </td>
                                @else
                                    <td>
                                        <span class="badge bg-danger font-weight-light">رد شده</span>
                                        @if(isset($wallet->admin))<p class="m-0"><small>توسط {{$wallet->admin->name}}</small></p>@endif
                                    </td>
                                @endif
                            </span>
                        </div>
                        <div class="table-responsive mt-4">
                            <table class="table align-middle mb-0">
                                <tbody>
                                <tr>
                                    <td colspan="2" class="text-center bg-light">
                                        <h5 class="text-muted mb-0">اطلاعات کیف پول</h5>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="text-muted mb-0">نام ارز</p>
                                    </td>
                                    <td>
                                        <h6 class="mb-0">{{ $wallet->coin_name }}</h6>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <p class="text-muted mb-0">آدرس کیف پول</p>
                                    </td>
                                    <td>
                                        <h6 class="mb-0">{{ $wallet->wallet }}</h6>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="modal-footer d-flex justify-content-between">
                        <div>
                            @if($wallet->confirm != 1)
                                <button type="button" class="btn btn-success" onclick="WalletConform({{$wallet->id}},1)">تایید</button>
                            @endif
                            @if($wallet->confirm != 3)
                                <button type="button" class="btn btn-warning" onclick="WalletConform({{$wallet->id}},3)">رد کردن</button>
                            @endif
                        </div>
                        <div>
                            <button type="button" class="btn btn-light waves-effect" data-bs-dismiss="modal">بستن</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endforeach

    <!-- Edit Card Modal -->
    <div class="modal fade" id="EditCardModal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="myModalLabel">ویرایش کارت</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="text-center"><span class="spinner-glow spinner-glow-info"></span></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light waves-effect" data-bs-dismiss="modal">بستن</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Add Card Modal -->
    <div class="modal fade" id="AddCardBank" role="dialog" aria-labelledby="AddCardBank" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="myModalLabel">افزودن کارت بانکی جدید</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="cardbank" autocomplete="off" method="post" action="{{asset('').env('PanelPrefix')}}/users/{{$result->user->id}}/cardbank/add" class="needs-validation col-md-10 mx-auto" novalidate >
                        @csrf
                        <div class="row">
                            <div class="form-group mb-3">
                                <label>نام بانک</label>
                                <select name="bank_name" id="bank_name" required class="form-control text-center">
                                    <option value="" disabled hidden selected>انتخاب کنید</option>
                                    <option value="بانک ملی">بانک ملی</option>
                                    <option value="بانک ملت">بانک ملت</option>
                                    <option value="بانک مسکن">بانک مسکن</option>
                                    <option value="بانک آینده">بانک آینده</option>
                                    <option value="بانک صادرات">بانک صادرات</option>
                                    <option value="بانک کشاورزی">بانک کشاورزی</option>
                                    <option value="بانک سامان">بانک سامان</option>
                                    <!--<option value="بانک پارسیان">بانک پارسیان</option>
                                    <option value="بانک پاسارگاد">بانک پاسارگاد</option>-->
                                    <option value="بانک دی">بانک دی</option>
                                    <option value="بانک رسالت">بانک رسالت</option>
                                    <option value="بانک شهر">بانک شهر</option>
                                    <option value="بانک سرمایه">بانک سرمایه</option>
                                    <option value="بانک اقتصاد نوین">بانک اقتصاد نوین</option>
                                    <option value="بانک انصار">بانک انصار</option>
                                    <option value="بانک تجارت">بانک تجارت</option>
                                    <option value="بانک ایران زمین">بانک ایران زمین</option>
                                    <option value="سایر">سایر</option>
                                </select>
                                <div class="invalid-feedback"> بانک را انتخاب کنید</div>
                            </div>
                            <div class="form-group mb-3">
                                <label>شماره کارت</label>
                                <input type="text" class="form-control   text-center numbers ltr-dir" name="card_number" maxlength="16" minlength="16" placeholder="شماره کارت" required>
                                <div class="invalid-feedback">شماره کارت بصورت صحیح درج شود</div>
                            </div>

                            <div class="form-group mb-3">
                                <label>شماره حساب</label>
                                <input type="text" class="form-control   text-center numbers ltr-dir" name="account_number" maxlength="16" minlength="9" placeholder="شماره حساب">
                                <div class="invalid-feedback">شماره حساب درج شود</div>
                            </div>

                            <div class="form-group mb-3">
                                <label>شماره شبا بدون IR</label>
                                <input type="text" class="form-control   text-center numbers ltr-dir" name="iban" maxlength="30" minlength="10" placeholder="شماره شبا بدون IR">
                                <div class="invalid-feedback">شماره شبا درج شود</div>
                            </div>

                            <div class="text-center">
                                <button type="submit" class="btn btn-success btn-block">ثبت کارت
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light waves-effect" data-bs-dismiss="modal">بستن</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Add Transaction Modal -->
    <div class="modal fade" id="ModalAddFinance" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">افزودن تراکنش</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="finance_add" autocomplete="off" method="post" action="{{asset('').env('PanelPrefix')}}/users/{{$result->user->id}}/finance/add" class="mt-2 needs-validation col-md-12 mx-auto" novalidate >
                        @csrf
                        <div class="col-md-12 p-0 text-left mb-3 form-group">
                            <label>نوع تراکنش</label>
                            <select name="type" id="type" required onchange="calculation_stock()" class="form-control   text-center">
                                <option value="" disabled hidden selected>انتخاب کنید</option>
                                <option value="واریز">واریز</option>
                                <option value="برداشت">برداشت</option>
                            </select>
                            <div class="invalid-feedback"> نوع تراکنش را انتخاب کنید</div>
                        </div>
                        <div class="col-md-12 p-0 text-left mb-3 form-group">
                            <label>مبلغ تراکنش</label>
                            <input type="text" class="form-control   text-center numbers ltr-dir" onkeyup="calculation_stock()" name="amount" id="amount" placeholder="مبلغ" required>
                            <div class="invalid-feedback"> مبلغ را درج کنید</div>
                        </div>

                        <div class="col-md-12 p-0 text-left mb-3 form-group">
                            <label>موجودی بعد تراکنش</label>
                            <input type="text" value="{{number_format($result->user->wallet)}}" id="stock" class="form-control   text-center numbers ltr-dir" disabled placeholder="موجودی">
                        </div>

                        <div class="col-md-12 p-0 text-left mb-3 form-group">
                            <label>توضیحات تراکنش</label>
                            <input type="text" class="form-control   text-center" name="description" maxlength="100" placeholder="توضیحات کوتاه" required>
                            <div class="invalid-feedback"> توضیحات را درج کنید</div>
                        </div>

                        <div class="mx-auto my-4">
                            <button type="submit" class="btn btn-primary btn-block">ثبت تراکنش</button>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light waves-effect" data-bs-dismiss="modal">بستن</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Transaction Data Modal -->
    <div class="modal fade" id="Info" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">اطلاعات تراکنش</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="text-center">
                        <div class="spinner-grow" style="width: 5rem; height: 5rem;" role="status">
                            <span class="sr-only">Loading...</span>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-light waves-effect" data-bs-dismiss="modal">بستن</button>
                </div>
            </div>
        </div>
    </div>
@stop

@section('js')
    <script src="{{asset('')}}app-assets/vendors/js/persian-date.min.js" type="text/javascript"></script>
    <script src="{{asset('')}}app-assets/vendors/js/persian-datepicker.min.js" type="text/javascript"></script>
    <script src="{{asset('')}}app-assets/vendors/js/digitbox.min.js"></script>
    <script src="{{asset('')}}app-assets/vendors/js/tables/datatable/datatables.min.js" type="text/javascript"></script>
    <script src="{{asset('')}}app-assets/vendors/js/charts/chartist.min.js" type="text/javascript"></script>
    <script src="{{asset('')}}app-assets/vendors/js/charts/chartist-plugin-tooltip.min.js" type="text/javascript"></script>
    <script src="{{asset('')}}app-assets/vendors/js/dropify.min.js"></script>

@stop
@section('script')
    <script>

        $('#date1,#DateBirth').persianDatepicker({
            altField: '#DateBirth',
            initialValueType: 'persian',
            maxDate: new persianDate().subtract('year', 18).valueOf(),
            altFormat: 'YYYY/MM/DD',
            initialValue: false,
            viewMode: 'year',
            observer: true,
            format: 'YYYY/MM/DD',
            toolbox:{
                enabled: false,
            },
            timePicker: {
                enabled: false,
                second:{
                    enabled: false,
                }
            }
        });

        $('#wallet,#finance_add #amount,.comma').digitbox({grouping: 1, separator: ','});

        function Block(){

            swal.fire({
                title: "از بلاک کردن این کاربر اطمینان دارید؟",
                input: 'text',
                inputAttributes: {
                    autocapitalize: 'off'
                },
                showCancelButton: true,
                confirmButtonText: 'بلاک',
                cancelButtonText: 'لغو',
                showLoaderOnConfirm: true,
                inputAttributes: {
                    maxlength: 200,
                    placeholder: 'دلیلی برای بلاک درج کنید'
                },
                inputValidator: (value) => {
                    if (!value) {
                        return 'لطفا دلیل بلاک را درج کنید'
                    }
                },
                preConfirm: (input) => {
                    return $.post("{{asset('').env('PanelPrefix')}}/users/{{$result->user->id}}/block",
                        {
                            block:"0",
                            reason:input,
                            _token: "{{ csrf_token() }}"
                        });

                }
            }).then((data) => {
                if(data.value.status=="true"){
                    swal.fire({
                        title:'انجام شد!',
                        icon: 'success',
                        text: data.value.messege,
                    }).then(function () {
                        location.reload();
                    });
                }
                else{
                    swal("Error",  data.value.messege  , "error");
                    unloading();
                }
            });
        }

        function DeleteUser(){
            swal.fire({
                title: "از حذف این کاربر اطمینان دارید؟",
                text: "تمام اطلاعات کاربر از جمله تراکنش ها، سفارشات، پوسانت ها، معرفی ها، کارت ها، تیکت ها پاک خواهند شد!",
                icon: "info",
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: "آره",
                confirmButtonColor:"#d22346",
                cancelButtonText: "نه",
                preConfirm: () => {
                    return $.post("{{asset('').env('PanelPrefix')}}/users/{{$result->user->id}}/delete",
                        { _token: "{{ csrf_token() }}"});
                }
            }).then((data) => {
                if(data.value.status=="true"){
                    swal.fire({
                        title:'انجام شد!',
                        icon: 'success',
                        text: data.value.messege,
                    }).then(function () {
                        location.href = "{{asset('').env('PanelPrefix')}}/users";
                    });
                }
                else{
                    swal.fire("خطا",  data.value.messege  , "error");
                }
            });
        }

        function unBlock(){
            swal.fire({
                title: "از آنبلاک کردن این کاربر اطمینان دارید؟",
                icon: "info",
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: "آره",
                cancelButtonText: "نه",
                preConfirm: () => {
                    return $.post("{{asset('').env('PanelPrefix')}}/users/{{$result->user->id}}/block",
                        {
                            block:"1",
                            _token: "{{ csrf_token() }}"
                        });
                }
            }).then((data) => {
                if(data.value.status=="true"){
                    swal.fire({
                        title:'انجام شد!',
                        icon: 'success',
                        text: data.value.messege,
                    }).then(function () {
                        location.reload();
                    });
                }
                else{
                    swal("Error",  data.value.messege  , "error");
                }
            });
        }


        $(document).ready(function () {
            var bar = $('#edit .progress-bar');
            var percent = $('#edit .progress-bar');
            $('form#edit').ajaxForm({
                beforeSend: function () {
                    loading();
                },
                uploadProgress: function (event, position, total, percentComplete) {
                    $('#edit .progress').fadeIn();
                    var percentVal = '0%';
                    bar.width(percentVal);
                    percent.html(percentVal);
                    if($('#img_codemeli').get(0).files.length !=0 || $('#img_shenasname').get(0).files.length !=0){
                        var percentVal = percentComplete + '%';
                        bar.width(percentVal);
                        percent.html(percentVal);
                    }
                },
                complete: function (data) {
                    data = data.responseJSON;
                    if (data.status == true) {
                        swal.fire({
                            icon: 'success',
                            title: "انجام شد",
                            html: data.message,
                            confirmButtonText: "تایید",
                        }).then(function () {
                            location.reload();
                        });
                    } else {
                        swal.fire({
                            icon: 'error',
                            title: "توجه",
                            html: data.message,
                            confirmButtonText: "تایید",
                        })
                    }
                    unloading();
                }
            });

            $('a[data-bs-toggle="pill"]').on("shown.bs.tab", function(){
                if($(this).attr("href") == '#v-orders' || $(this).attr("href") == '#v-referrals' || $(this).attr("href") == '#v-transactions') {
                    $($.fn.dataTable.tables(true)).DataTable()
                        .columns.adjust();

                }
            });
        });

        function CardEdit(id) {
            $('#EditCardModal .modal-body').load("{{asset('').env('PanelPrefix')}}/users/{{$result->user->id}}/cardbank/"+id).fadeIn();
        }

        $('#EditCardModal').on('hidden.bs.modal', function () {
            $('#EditCardModal .modal-body').html('<div class="text-center"><span class="spinner-glow spinner-glow-info"></span></div>');
        })

        function CardConform(id,status){
            loading();
            $.post("{{asset('').env('PanelPrefix')}}/users/{{$result->user->id}}/cardbank",
                {
                    id_card: id,
                    status: status,
                    _token: "{{ csrf_token() }}",
                },
                function(data){
                    if(data.status=="true"){
                        swal.fire({
                            title:'انجام شد!',
                            icon: 'success',
                            text: data.messege,
                        }).then(function () {
                            location.reload();
                        });
                    }
                    else{
                        swal("خطا",  data.messege  , "error");
                    }
                    unloading();
                });
        }

        function CardRemove(id){
            swal.fire({
                title: "از حدف این کارت اطمینان دارید؟",
                icon: "info",
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: "آره",
                confirmButtonColor:"#d22346",
                cancelButtonText: "نه",
                preConfirm: () => {
                    return $.post("{{asset('').env('PanelPrefix')}}/users/{{$result->user->id}}/cardbank/remove",
                        {
                            id_card: id,
                            _token: "{{ csrf_token() }}"
                        });
                }
            }).then((data) => {
                if(data.value.status=="true"){
                    swal.fire({
                        title:'انجام شد!',
                        icon: 'success',
                        text: data.value.messege,
                    }).then(function () {
                        location.reload();
                    });
                }
                else{
                    swal("خطا",  data.value.messege  , "error");
                }
            });
        }

        function WalletConform(id,status){
            loading();
            $.post("{{asset('').env('PanelPrefix')}}/users/{{$result->user->id}}/wallet",
                {
                    id_wallet: id,
                    status: status,
                    _token: "{{ csrf_token() }}",
                },
                function(data){
                    if(data.status=="true"){
                        swal.fire({
                            title:'انجام شد!',
                            icon: 'success',
                            text: data.messege,
                        }).then(function () {
                            location.reload();
                        });
                    }
                    else{
                        swal("خطا",  data.messege  , "error");
                    }
                    unloading();
                });
        }

        $(document).ready(function () {
            var bar = $('#cardbank .progress-bar');
            var percent = $('#cardbank .progress-bar');
            $('form#cardbank').ajaxForm({
                beforeSend: function () {
                    loading();
                },
                uploadProgress: function (event, position, total, percentComplete) {
                    $('#cardbank .progress').fadeIn();
                    var percentVal = '0%';
                    bar.width(percentVal);
                    percent.html(percentVal);
                },
                complete: function (data) {
                    data = data.responseJSON;
                    if (data.status == true) {
                        swal.fire({
                            icon: 'success',
                            title: "انجام شد",
                            html: data.message,
                            confirmButtonText: "تایید",
                        }).then(function () {
                            location.reload();
                        });
                    } else {
                        swal.fire({
                            icon: 'error',
                            title: "توجه",
                            html: data.message,
                            confirmButtonText: "تایید",
                        })
                    }
                    unloading();
                }
            });
        });

        $(window).on("load", function() {
                new Chartist.Line("#areaGradient", {
                        labels: [@foreach($result->finance as $finance) '{{$finance->date}}', @endforeach], series: [[@foreach($result->finance as $finance)  {{$finance->stock}} , @endforeach]]
                    }
                    , {
                        lineSmooth:Chartist.Interpolation.simple( {
                                divisor: 2
                            }
                        ), fullWidth:!0, showArea:!0, chartPadding: {
                            right: -20,
                            left: -20
                        }
                        , axisX: {
                            showGrid: !1,
                            showLabel: false,
                        }
                        , axisY: {
                            showLabel: false,
                            scaleMinSpace: 40
                        }
                        , plugins:[Chartist.plugins.tooltip( {
                                appendToBody: !0, pointClass: "ct-point-circle"
                            }
                        )], low:0, onlyInteger:!0
                    }
                ).on("draw", function(e) {
                        //console.log(e);
                        if("point"===e.type) {
                            var t=new Chartist.Svg("circle", {
                                    cx: e.x, cy: e.y, "ct:value": e.value.y.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",") + ' تومان'+'<br>'+ e.axisX.ticks[e.index], r: 2, class: "ct-point-circle ct-point"
                                }
                            );
                            e.element.replace(t)
                        }
                        "line"!==e.type&&"area"!=e.type||e.element.animate( {
                                d: {
                                    begin: 1e3, dur: 1e3, from: e.path.clone().scale(1, 0).translate(0, e.chartRect.height()).stringify(), to: e.path.clone().stringify(), easing: Chartist.Svg.Easing.easeOutQuint
                                }
                            }
                        )
                    }
                )
            }

        );

        $('input[type=checkbox][name=sms]').change(function () {
            if (this.checked) {
                $('#kavenegar').slideDown();
            } else{
                $('#kavenegar').slideUp();
            }
        });


        $(document).ready(function () {
            $('#form_notification').ajaxForm({
                beforeSend: function () {
                    loading();
                },
                complete: function (data) {
                    data = data.responseJSON;
                    if (data.status == true) {
                        swal.fire({
                            icon: 'success',
                            title: "انجام شد",
                            html: data.message,
                            confirmButtonText: "تایید",
                            onClose: () => {
                                location.reload()
                            }
                        });
                    } else {
                        swal.fire({
                            icon: 'error',
                            title: "توجه",
                            html: data.message,
                            confirmButtonText: "تایید",
                        })
                    }
                    unloading();
                }
            });
        });



        function ChangeDailyBuy(daily_buy){
            loading();
            $.post("{{asset('').env('PanelPrefix')}}/users/{{$result->user->id}}/daily_buy",
                {
                    daily_buy: daily_buy,
                    _token: "{{ csrf_token() }}",
                },
                function(data){
                    if(data.status=="true"){
                        swal.fire({
                            title:'انجام شد!',
                            icon: 'success',
                            text: data.messege,
                        }).then(function () {
                            location.reload();
                        });
                    }
                    else{
                        swal("خطا",  data.messege  , "error");
                    }
                    unloading();
                });
        }



        function calculation_stock() {
            var stock = {{$result->user->wallet}};
            var amount = parseInt($('#amount').val().replace(/\,/g, ''));


            if($('#type').val() == 'واریز' )
                $('#stock').val(stock+amount).digitbox({grouping: 1, separator: ','});
            else{
                if(amount>stock){
                    alert('خطا: مبلغ بیشتر از موجودی است');
                    $('#amount').val(stock).digitbox({grouping: 1, separator: ','});
                    $('#stock').val(0);
                    return false;
                }
                $('#stock').val(stock-amount).digitbox({grouping: 1, separator: ','});
            }
            if($('#amount').val() == '')
                $('#stock').val(stock).digitbox({grouping: 1, separator: ','});
        };

        function confirmImage(image,status){
            Swal.fire({
                title: "آیا از تغییر وضعیت اطمینان دارید؟",
                text:'چه تایید و چه رد کنید مجدد قابل تغییر است',
                icon: "info",
                input: 'text',
                inputAttributes: {
                    maxlength: 200,
                    placeholder: 'دلیلی برای تغییر وضعیت درج کنید'
                },
                inputValidator: (value) => {
                    if (!value && status != 1) {
                        return 'لطفا دلیل رد کردن را درج کنید'
                    }
                },
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: "آره",
                cancelButtonText: "لغو",
                preConfirm: (input) => {
                    return $.post("{{asset('').env('PanelPrefix')}}/users/{{$result->user->id}}/images",
                        {
                            image: image,
                            status: status,
                            reason:input,
                            _token: "{{ csrf_token() }}"
                        });
                }
            }).then((data) => {
                if(data.value.status=="true"){
                    Swal.fire({
                        icon: 'success',
                        title: "انجام شد",
                        html: data.message,
                        confirmButtonText: "تایید",
                        onClose: () => {
                            location.reload()
                        }
                    });
                }
                else{
                    Swal.fire("خطا",  data.value.messege  , "error");
                }
            });
        }


        function Info(id){
            $('#Info .modal-body').load("{{asset('').env('PanelPrefix')}}/finances/"+id+'/?'+ new Date().getTime()).fadeIn();
        }

        $(document).ready(function () {
            $('#finance_add').ajaxForm({
                beforeSend: function (xhr, opts) {
                    if($('#amount').val() <=0 ){
                        swal('خطا','مبلغ را بیش از صفر درج کنید','warning');
                        xhr.abort();
                        return false;
                    }
                    loading();
                },
                complete: function (data) {
                    data = data.responseJSON;
                    if (data.status == true) {
                        swal.fire({
                            icon: 'success',
                            title: "انجام شد",
                            html: data.message,
                            confirmButtonText: "تایید",
                            onClose: () => {
                                location.reload()
                            }
                        });
                    } else {
                        swal.fire({
                            icon: 'error',
                            title: "توجه",
                            html: data.message,
                            confirmButtonText: "تایید",
                        })
                    }
                    unloading();
                }
            });
        });

        $('#Info').on('hidden.bs.modal', function () {
            $('#Info .modal-body').html('<div class="text-center"><span class="spinner-glow spinner-glow-info"></span></div>');
        })


        $(".ostan").on("change", function () {
            if ($("#Province").find(":selected").val() != '') {
                var id = $("#Province").find(":selected").val();
                $.post("{{asset('').env('PanelPrefix')}}cities",
                    {
                        id: id,
                        _token: "{{ csrf_token() }}",
                    },
                    function(data){
                        $("#city").html('<option value="" disabled selected>شهر را انتخاب کنید</option>');
                        $.each(data, function(k, v) {
                            $("#city").append(new Option(v.name, v.id));
                        });
                    });
            } else
                $("#City").html('');
        });

        $('#orders').DataTable({
            "pagingType": "full_numbers",
            "scrollX": true,
            "language": {
                "url": "{{asset('')}}app-assets/vendors/js/datatable-Persian.json",
            },
            "ajax": '{{asset('').env('PanelPrefix')}}/users/{{$result->user->id}}/orders',
            "columns": [
                { "data": "1"},
                { "data": "9","searchable": false},
                { "data": "2" },
                { "data": function ( data) {return data['3']+data['8'];}},
                { "data": "4" },
                { "data": "5" },
                { "data": "6" },
                { "data": "7" , "orderable":false},
            ],
            "columnDefs": [
                {
                    "targets": 0,
                    "searchable": false,
                    "orderable": true,
                    "data": null,
                    "render": function (data, type, full, meta) {
                        return meta.settings._iDisplayStart + meta.row + 1;
                    }
                }
            ],
            "displayLength": 10,
            dom: "<'top'><'row'<'col-md-5 col-12 mt-1'B><'col-md-7 col-12 d-flex ltr-dir'<'mx-1 mt-1'l><'rtl-dir'f>>><'bottom'>rt<'row'<'col-md-5 col-12'i><'col-md-7 col-12'p>><'clear'>",
            buttons: [
                {
                    extend: 'print',
                    text: '<i class="mdi mdi-printer text-dark"> پرینت</i>',
                    className: 'btn btn-light',
                    title: '',
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5, {
                            'data': 'batch_notes', "render": function (data, type, row, meta) {
                                return data
                            },
                        }]
                    }
                },
                {
                    extend: 'excel',
                    text: '<i class="mdi mdi-file-excel text-dark"> اکسل</i>',
                    className: 'btn btn-light',
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5, {
                            'data': 'batch_notes', "render": function (data, type, row, meta) {
                                return data
                            },
                        }]
                    }
                }
            ],
            "initComplete":function(){
                if ($('#orders tr').length < 10) {
                    $('#orders .dataTables_paginate,#orders .dataTables_info').hide();

                }
            }
        });
        function search(){
            var tbl = $('#orders').DataTable();
            tbl.ajax.url("<{{asset('').env('PanelPrefix')}}/users/{{$result->user->id}}/orders?model="+ $("#model").val() + "&currency="+ $("#currency").val() ).load();
            unloading();
        }

        $('#finance').DataTable({
            "pagingType": "full_numbers",
            "scrollX": true,
            "language": {
                "url": "{{asset('')}}app-assets/vendors/js/datatable-Persian.json",
            },
            "ajax": '{{asset('').env('PanelPrefix')}}/finances/list?id_user={{$result->user->id}}',
            "order": [[ "5", 'desc' ]],
            "processing": true,
            "serverSide": true,
            "columns": [
                { "data": "0" },
                { "data": function ( data) {return data['1']+' '+data['22']}},
                { "data": "2" },
                { "data": "3" },
                { "data": "4" },
                { "data": "5" },
                { "data": "6" },
                { "data": "7" },
                { "data": "8" },
            ],
            "columnDefs": [
                {
                    "targets": 0,
                    "searchable": false,
                    "orderable": true,
                    "data": null,
                    "render": function (data, type, full, meta) {
                        return meta.settings._iDisplayStart + meta.row + 1;
                    }
                }
            ],
            "displayLength": 10,
            dom: "<'top'><'row'<'col-md-6 col-12 mt-1'B><'d-flex col-md-6 col-12 '<'w-100'f> l>><'bottom'>rt<'row'<'col-md-5 col-12'i><'col-md-7 col-12'p>><'clear'>",
            buttons: [
                {
                    extend: 'print',
                    text: '<span class="mdi mdi-printer text-dark"> پرینت</span',
                    className: 'btn btn-light',
                    title: '',
                    exportOptions: {
                        columns: [0,2,3,4,5,6, {'data': 'batch_notes', "render": function ( data, type, row, meta ) { return data },}]
                    }
                },
                {
                    extend: 'excelHtml5',
                    text: '<span class="mdi mdi-file-excel text-dark"> اکسل</span>',
                    className: 'btn btn-light',
                    exportOptions: {
                        columns: [0,2,3,4,5,6, {'data': 'batch_notes', "render": function ( data, type, row, meta ) { return data },}]
                    }
                },
                {
                    text: 'ثبت تراکنش',
                    className: 'btn text-dark',
                    action: function () {
                        $('#ModalAddFinance').modal('show');
                    }
                }
            ]
        });

        $('#tbl-invitation').DataTable({
            "pagingType": "full_numbers",
            "scrollX": true,
            "language": {
                "url": "{{asset('')}}app-assets/vendors/js/datatable-Persian.json",
            },
            "ajax": '{{asset('').env('PanelPrefix')}}/users/{{$result->user->id}}/invitation',
            "columns": [
                { "data": "1" },
                { "data": "2" },
                { "data": "3" },
                { "data": "4" },
                { "data": "5" },
                { "data": "6" },
                { "data": "7" },
            ],
            "columnDefs": [
                {
                    "targets": 0,
                    "searchable": false,
                    "orderable": true,
                    "data": null,
                    "render": function (data, type, full, meta) {
                        return meta.settings._iDisplayStart + meta.row + 1;
                    }
                }
            ],
            "displayLength": 10,
            dom: "<'top'><'row'<'col-md-5 col-12 mt-1'B><'col-md-7 col-12 d-flex ltr-dir'<'mx-1 mt-1'l><'rtl-dir'f>>><'bottom'>rt<'row'<'col-md-5 col-12'i><'col-md-7 col-12'p>><'clear'>",
            buttons: [
                {
                    extend: 'print',
                    text: '<span class="mdi mdi-printer text-dark"> پرینت</span',
                    className: 'btn btn-light',
                    title: '',
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5, {
                            'data': 'batch_notes', "render": function (data, type, row, meta) {
                                return data
                            },
                        }]
                    }
                },
                {
                    extend: 'excel',
                    text: '<span class="mdi mdi-file-excel text-dark"> اکسل</span>',
                    className: 'btn btn-light',
                    exportOptions: {
                        columns: [1, 2, 3, 4, 5, {
                            'data': 'batch_notes', "render": function (data, type, row, meta) {
                                return data
                            },
                        }]
                    }
                }
            ],
            "fnDrawCallback": function(oSettings) {
                if ($('#tbl-invitation tr').length < 10) {
                    $('#tbl-invitation .dataTables_paginate,#tbl-invitation .dataTables_info').hide();

                }
            }
        });

        $('#auth_img,#selfie_img').dropify({
            messages: {
                'default': 'تصویر را در این قسمت درج کنید',
                'replace': 'Drag and drop or click to replace',
                'remove': 'حذف',
                'error': 'اوه! مشکلی بوجود آمده است'
            }
        });
    </script>
@stop
