@extends('applications/fullLayoutMasterApplications')
@section('title', 'نتیجه پرداخت')

@section('content')


    <div class="row">
        <div class="col-md-12 mx-auto">
            <div class="card o-hidden mb-0">

                @if($result->status == true)
                    <div class="card-body text-center box-payment border-{{$result->color ?? 'success'}}" style="min-height: 100vh">

                        <img src="{{asset('')}}app-assets/images/icons/success.png" width="130px">
                        <h2 class="mt-2">{!!$result->message ?? 'با موفقیت انجام شد!' !!}</h2>
                        @if(isset($result->sell) && $result->sell == true)
                            @if(isset($result->wallet))
                                @if(isset($result->walletMessage))
                                    {!!$result->walletMessage !!}
                                @else
                                    <p>مبلغ {{number_format($result->amount)}} تومان با موفقیت به کیف پول شما اضافه شد.</p>
                                @endif
                            @else
                                <p class="col-md-8 mx-auto">مبلغ {{number_format($result->amount)}} تومان با موفقیت ثبت گردید و بعد از تایید تا چند ساعت دیگر به حساب شما واریز میگردد و در بخش سفارشات قابل پیگیری است.</p>
                            @endif
                        @endif
                        <div class="table-responsive">
                            <table class="table table-bordered col-md-8 mx-auto mt-3">
                                <tbody>
                                @foreach($result->rowData as $rowData)
                                    <tr>
                                        <th scope="row">{{$rowData->name}}</th>
                                        <td class="sans-serif sans-serif text-center cursor-pointer" data-toggle="tooltip" data-original-title="کلیک و کپی" onclick="copyToClipboard(this)">
                                            <i class="feather icon-copy"></i>  <span>{{$rowData->value}}</span>
                                        </td>
                                    </tr>
                                @endforeach

                                @if(isset($result->RefID))
                                <tr>
                                    <th scope="row">کد پیگیری خرید</th>
                                    <td class="sans-serif text-center cursor-pointer">
                                        <span>{{$result->RefID}}</span>
                                    </td>
                                </tr>
                                @endif
                                <tr>
                                    <th scope="row">تاریخ</th>
                                    <td class="text-center">
                                        <span>{{$result->date}}</span>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="btn-payment">
                            @if(isset($result->robot) && $result->robot == true)
                                <a class="btn btn-warning round" href="tg://" onclick="window.location='tg:resolve'">بازشگت به ربات</a>
                            @else
                                <a class="btn btn-warning round" href="arz8x://com.arz8x.app.arz8x">بازشگت به اپلیکیشن</a>
                            @endif
                        </div>

                    </div>
                @elseif($result->status == false)
                    <div class="card-body text-center box-payment" style="min-height: 100vh">
                        <img src="{{asset('')}}app-assets/images/icons/error.png" width="130px">
                        <h3 class="mt-3">{!!$result->message!!}</h3>
                        <div class="btn-payment">
                            @if(isset($result->robot) && $result->robot == true)
                                <a class="btn btn-warning round" href="tg://" onclick="window.location='tg:resolve'">بازشگت به ربات</a>
                            @else
                                <a class="btn btn-warning round" href="arz8x://com.arz8x.app.arz8x">بازشگت به اپلیکیشن</a>
                            @endif
                        </div>
                    </div>
                @endif
            </div>
        </div>

    </div>

@stop
