@extends('user.login.master')
@section('title', 'بازیابی رمز عبور')

@section('head')
    <script src='https://www.google.com/recaptcha/api.js?hl=fa'></script>
@endsection

@section('content')
    <div class="row justify-content-center">
        <div class="col-md-8 col-lg-6 col-xl-5">
            <div class="card overflow-hidden">
                <div class="row pt-5 pb-3 text-center">
                    <h3>بازیابی رمز عبور</h3>
                </div>
                <div class="card-body pt-0">
                    <div class="text-center mb-1"><small>لطفا مطمئن شوید آدرس مرورگرتان منطبق با آدرس زیر باشد.</small></div>
                    <div class="text-center mb-4">
                        <span class="border border-1 py-1 px-4 rounded-pill">
                            <span class="text-success">https://</span>{{ getSetting('app_url') }}<i class="mdi mdi-lock font-size-16 text-success ms-1"></i>
                        </span>
                    </div>
                    <div class="p-2">
                        <form method="POST" autocomplete="off" class="form-horizontal needs-validation" action="" novalidate>
                            @csrf
                            <div class="mb-3">
                                <label for="mobile" class="form-label">شماره موبایل</label>
                                <input type="text" class="form-control" required
                                       id="username" placeholder=" شماره همراه 09123456789" name="mobile" maxlength="11" minlength="11"/>
                                <div class="invalid-feedback">شماره موبایل را بدرستی وارد کنید</div>
                            </div>
                            <div class="form-group text-center my-3">
                                <div class="g-recaptcha d-flex justify-content-center" data-sitekey="{{ env('NOCAPTCHA_SITEKEY') }}"></div>
                                @if ($errors->has('g-recaptcha-response'))
                                    <span class="invalid-feedback" style="display: block;">
                                        <strong>{{ $errors->first('g-recaptcha-response') }}</strong>
                                    </span>
                                @endif
                            </div>
                            <div class="box_code text-center mb-1" style="display:none ;">
                                <fieldset class="form-group form-group position-relative has-icon-left">
                                    <input type="text" class="form-control" id="code"
                                           maxlength="5" minlength="5" name="code" placeholder="کد 5 رقمی احراز هویت" >
                                    <div class="invalid-feedback">
                                        کد 5 رقمی را بدرستی درج کنید
                                    </div>
                                </fieldset>
                                <div>
                                    <a class="text-info text-17" id="makingdifferenttimer"
                                       style="display: none;" onclick="resend()"><i class="ft-navigation"></i> ارسال مجدد
                                    </a>
                                </div>
                                <div id="mdtimer" class="">
                                    <b></b>
                                    <div class="text-17"><b><span>59</span></b></div>
                                </div>
                            </div>
                            <div class="text-end">
                                <button type="submit" class="btn btn-block btn-primary col-12 mr-1 mb-1" id="BtnRegister" onclick="onSubmitform">ارسال کد</button>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
            <div class="mt-5 text-center">
                <p>رمز عبور خود را به خاطر دارید؟ <a href="{{route('login')}}" class="fw-medium text-primary"> وارد شوید</a> </p>
                <p>© <script>document.write(new Date().getFullYear())</script> ساخته شده با <i class="mdi mdi-heart text-danger"></i> توسط تیم {{ getSetting('app_name_farsi') }}</p>
            </div>
        </div>
    </div>
@stop

@section('script')
    <script>
        function onSubmitform() {
            if ($("form:invalid").length == 1){
                $('form').addClass('was-validated');
                ElementUnBlock('form button');
            }
            else
                $('form').submit();
        }
        $(document).ready(function () {
            $('form').ajaxForm({
                beforeSend: function() {

                },
                uploadProgress: function(event, position, total, percentComplete) {
                },
                complete: function(data) {
                    data = data.responseJSON;
                    if (data.status == true) {
                        if(data.redirect != null){
                            location.href = (data.redirect);
                            return false
                        }
                        Swal.fire({
                            icon: 'success',
                            title: "انجام شد",
                            html: data.message,
                            confirmButtonText: "تایید",
                        }).then(function () {
                        });
                        $('.box_code').slideDown();
                        $('#mobile').attr('readonly','readonly');
                        $('#code').attr('required','required');
                        $('form button').html('تایید کد');
                        timerResend()

                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: "توجه",
                            html: data.message,
                            confirmButtonText: "تایید",
                        })
                    }
                    ElementUnBlock('#BtnRegister');
                }
            });


        });

        function resend() {
            ElementBlock('#makingdifferenttimer');
            $.post("{{Route('ReSendSmsForget')}}",{_token: "{{csrf_token()}}"},
                function(data){
                    if(data.status == true){
                        toastr.success(data.message, "انجام شد!", {
                            positionClass: "toast-bottom-center",
                            progressBar: !0,
                        });

                    }else{
                        toastr.error(data.message, "خطا!", {
                            positionClass: "toast-bottom-center",
                            progressBar: !0,
                        })
                    }
                    timerResend();
                    ElementUnBlock('#makingdifferenttimer');
                });
        }
    </script>
@stop
