@extends('user.layouts.master')
@section('title', 'فروشگاه محصولات')

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">{{ $product->title }}</h4>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="card">
            <div class="card-body">
                @if( isset($product) )
                    <form method="POST" action="{{ asset('') }}add-to-cart/{{$product->id}}">
                        @csrf
                        <div class="row">
                            <div class="col-xl-6">
                                <div class="product-detai-imgs">
                                    <div class="row">
                                        <div class="tab-content" id="v-pills-tabContent">
                                            <div class="active">
                                                <div>
                                                    <img src="{{ asset($product->image) }}" alt="Product" class="img-fluid mx-auto d-block">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="text-center">
                                            <a href="{{ asset('') }}products" class="btn btn-light waves-effect  mt-2 waves-light">
                                                <i class="bx bx-shopping-bag me-2"></i>بازگشت به فروشگاه
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-xl-6">
                                <div class="mt-4 mt-xl-3">
                                    <a href="{{ asset('') }}products?category={{ $product->category->id }}" class="text-primary mb-1">{{ $product->category->title }}</a>
                                    <h4 class="mt-1 mb-4">{{ $product->title }}</h4>

                                    <h5 class="mb-4">قیمت : <b>{{ number_format($product->product_price) }} تومان</b></h5>
                                    <p class="text-muted mb-4">{{ $product->description }}</p>
                                    <div class="row mb-3">
                                        <div class="col-md-6">
                                            <div>
                                                <p class="text-muted"><i class="bx bx-link font-size-16 align-middle text-primary me-1"></i> تحویل بین ۱ - ۳ ساعت کاری</p>
                                                <p class="text-muted"><i class="bx bx-shape-triangle font-size-16 align-middle text-primary me-1"></i> پرداخت آسان</p>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div>
                                                <p class="text-muted"><i class="bx bx-user-voice font-size-16 align-middle text-primary me-1"></i> پشتیبانی ۲۴ ساعته</p>
                                                <p class="text-muted"><i class="bx bx-money font-size-16 align-middle text-primary me-1"></i> ضمانت بازگشت وجه</p>
                                            </div>
                                        </div>
                                    </div>
                                    <button type="submit" class="btn btn-success waves-effect waves-light mt-2 me-1">
                                        <i class="bx bx-cart me-2"></i> خرید محصول
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                @endif
            </div>
        </div>
    </div>
@stop

@section('script')
<script>
    $(document).ready(function () {
        $('form').ajaxForm({
            complete: function (data) {
                data = data.responseJSON;
                if(data != undefined) {
                    $('form').removeClass('disable-block');
                    if (data.status == true) {
                        swal.fire({
                            icon: 'success',
                            title: "انجام شد",
                            html: data.message,
                            confirmButtonText: "تایید",
                            onClose: () => {
                                location.href = "{{ asset('') }}cart";
                            }
                        });
                    } else {
                        swal.fire({
                            icon: 'error',
                            title: "توجه",
                            html: data.message,
                            confirmButtonText: "تایید",
                            onClose: () => {
                                location.href = "{{ asset('') }}cart";
                            }
                        })
                        $('.progress').fadeOut();
                    }
                    $('form button').removeAttr('disabled');
                }
            }
        });
    });
</script>
@stop
