@extends('user.layouts.master')
@section('title', 'فروشگاه محصولات')
@section('css')
    <link href="{{ asset('libs/ion-rangeslider/css/ion.rangeSlider.min.css') }}" rel="stylesheet" type="text/css" />
@stop

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">فروشگاه محصولات</h4>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-3">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">فیلتر بر اساس</h4>
                    <div>
                        <h5 class="font-size-14 mb-3">دسته بندی</h5>
                        <ul class="list-unstyled product-list">
                            <li>
                                <a href="{{ asset('') }}products">
                                    <i class="mdi mdi-chevron-right me-1"></i>
                                    نمایش همه
                                </a>
                            </li>
                            @foreach( $categories as $category )
                                <li>
                                    <a href="{{ asset('') }}products?category={{ $category->id . '-' . $category->title }}">
                                        <i class="mdi mdi-chevron-right me-1"></i>
                                        {{ $category->title }}
                                    </a>
                                </li>
                            @endforeach
                        </ul>
                    </div>
{{--                    <div class="mt-4 pt-3">--}}
{{--                        <div class="row">--}}
{{--                            <div class="p-3">--}}
{{--                                <h5 class="font-size-14 mb-3">محدوده قیمت</h5>--}}
{{--                                <input type="text" id="range_03">--}}
{{--                            </div>--}}
{{--                        </div>--}}
{{--                    </div>--}}
                </div>
            </div>
        </div>
        <div class="col-lg-9">
            <div class="row">
                @foreach( $products as $product )
                    <div class="col-xl-4 col-sm-6">
                        <div class="card">
                            <div class="card-body">
                                <div class="product-img position-relative">
                                    <img src="{{ asset($product->image) }}" alt="" class="img-fluid mx-auto d-block">
                                </div>
                                <div class="mt-4 text-center">
                                    <h5 class="mb-3 text-truncate">
                                        <a href="{{ asset('') }}product/{{ $product->id . '-' .  $product->title }}" class="text-dark">{{ $product->title }}</a>
                                    </h5>
                                    <h5 class="my-0">{{ number_format($product->product_price) }} تومان</h5>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
@stop

@section('script')
@stop
