@extends('user.layouts.master')
@section('title', 'حساب کاربری')
<head>
    <link rel="stylesheet" href="{{asset('libs/dropzone/min/dropzone.min.css')}}">
    <link rel="stylesheet" href="{{asset('')}}app-assets/css/plugins/persian-datepicker.min.css">
</head>

@section('content')
    <div class="row" id="AppLocation">
        <div class="col-xl-3">
            @include('user.profile.profile-detail')

            @if(Auth::user()->auth_img_confirm != 1 || Auth::user()->selfie_img_confirm != 1)
                <div class="card border border-danger">
                    <div class="card-header bg-transparent border-danger">
                        <span class="my-0 text-danger"><i class="mdi mdi-alert me-3"></i>احراز هویت شما کامل نشده!</span>
                    </div>
                </div>
            @else
                <div class="card border border-success">
                    <div class="card-header bg-transparent border-success">
                        <span class="my-0 text-success"><i class="mdi mdi-check-all me-3"></i>احراز هویت شما با موفقیت انجام شده است!</span>
                    </div>
                </div>
            @endif
        </div>
        <div class="col-xl-9">
            @include('user.profile.menu')

            <div class="card border
                        @if(Auth::user()->auth_img_confirm == 1)border-success
                        @elseif(Auth::user()->auth_img_confirm == 2)border-warning
                        @elseif(Auth::user()->auth_img_confirm == 3)border-danger
                        @endif">
                <div class="card-body">
                    <div class="card-title mb-3">اطلاعات کارت ملی
                    <small class="ps-1">
                        @if(Auth::user()->auth_img_confirm == 1)<span class="text-success"><i class="icon-check"></i> تایید شده</span>
                        @elseif(Auth::user()->auth_img_confirm == 2)
                            <span class="text-warning"> در انتظار بررسی</span>
                        @elseif(Auth::user()->auth_img_confirm == 3)
                            <span class="text-danger"> رد شده</span>
                        @endif
                    </small>
                    </div>
                    <p class="text-small text-muted">تصویر کارت ملی خود را آپلود نمایید و بعد از آپلود تصویر در انتظار بررسی توسط اپراتور قرار میگیرد و لطفا تصویر مناسب و واضح ارائه کنید. در صورتی که عکس رد شود بایستی مجدد آپلود نمایید. برای مشاهده نمونه عکس <a href="{{asset('app-assets/images/sample-1.jpg')}}">اینجا</a> کلیک کنید.
                    @if(isset(Auth::user()->auth_img_reason) && Auth::user()->auth_img_confirm == 3)
                        <div class="alert m-1 bg-warning text-center alert-icon-left alert-dismissible mb-2" role="alert">
                            <span class="alert-icon">
                                <i class="ft-user-x"></i>
                            </span>
                            تصویر به دلیل "{{Auth::user()->auth_img_reason}}" متاسفانه تایید نشد.
                        </div>
                    @endif
                    <form id="nationalCard" method="POST" autocomplete="off" class="form-horizontal needs-validation text-center @if(Auth::user()->auth_img_confirm != 2 && Auth::user()->auth_img_confirm != 1) dropzone @endif" novalidate action="profile/national-card" enctype="multipart/form-data">
                        @csrf

                        <div class="col-lg-4 col-md-6 col-sm-8 mx-auto">
                            <div class="col-md-12 form-group p-0 mb-3">
                                <label>کد ملی</label>
                                <input type="text" class="form-control numbers text-center ltr-dir" maxlength="11" minlength="8" id="codemeli"
                                       @if(!isset(Auth::user()->code_meli) || Auth::user()->auth_img_confirm == 3 || Auth::user()->auth_img_confirm == 0) name="codemeli" required @else value="{{Auth::user()->code_meli}}" readonly  @endif>
                            </div>
                            <div class="col-md-12 form-group mb-3">
                                <label>تاریخ تولد <small>(هجده سال به بالا امکان ثبت وجود دارد)</small></label>
                                <div class="input-group">
                                    <input type="text" class="form-control ltr-dir text-center font-small-3 px-0" id="DateBirth" placeholder="تاریخ"
                                           @if(!isset(Auth::user()->date_birth) || Auth::user()->auth_img_confirm == 3  || Auth::user()->auth_img_confirm == 0)
                                           name="DateBirth" required @else value="{{Auth::user()->date_birth}}" readonly @endif>
                                    <span class="input-group-text"><i class="mdi mdi-calendar"></i></span>
                                </div>
                            </div>
                        </div>
                        @if(isset(Auth::user()->auth_img) && Auth::user()->auth_img_confirm != 3)
                            <img src="{{asset('')}}{{Auth::user()->auth_img}}" width="350px">
                        @else
                            <div class="fallback">
                                <input name="auth_img" type="file" id="auth_img" accept="image/*" required>
                            </div>
                            <div class="dz-message needsclick">
                                <div class="mb-3">
                                    <i class="display-4 text-muted bx bxs-cloud-upload"></i>
                                </div>
                                <h4>عکس کارت ملی را اینجا رها کنید یا برای بارگذاری کلیک کنید. </h4>
                            </div>
                        @endif

                        <div class="progress w-100" style="display: none">
                            <div class="progress-bar bg-primary progress-bar-striped progress-bar-animated" role="progressbar"
                                 aria-valuemax="100" style="width:0%">
                                0%
                            </div>
                        </div>
                        @if(Auth::user()->auth_img_confirm == 0 || Auth::user()->auth_img_confirm==3)
                            <div class="col-md-12 m-auto text-center">
                                <button type="button" class="btn btn-primary px-3 nationalCard-start">ارسال تصویر</button>
                            </div>
                        @endif
                    </form>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="card border
                        @if(Auth::user()->selfie_img_confirm == 1)border-success
                        @elseif(Auth::user()->selfie_img_confirm == 2)border-warning
                        @elseif(Auth::user()->selfie_img_confirm == 3)border-danger
                        @endif">
                        <div class="card-body">
                            <div class="card-title mb-3">ثبت تصویر اطلاعات
                                <small class="ps-1">
                                    @if(Auth::user()->selfie_img_confirm == 1)<span class="text-success"><i class="icon-check"></i> تایید شده</span>
                                    @elseif(Auth::user()->selfie_img_confirm == 2)
                                        <span class="text-warning"> در انتظار بررسی</span>
                                    @elseif(Auth::user()->selfie_img_confirm == 3)
                                        <span class="text-danger"> رد شده</span>
                                    @endif
                                </small>
                            </div>
                            <p class="text-small text-muted">عکس سلفی خود رامطابق استاندارد خواسته شده در نمونه عکس آپلود نمایید و بعد از آپلود تصویر در انتظار بررسی توسط اپراتور قرار میگیرد و لطفا تصویر مناسب و واضح ارائه کنید. در صورتی که عکس رد شود بایستی مجدد آپلود نمایید.  برای مشاهده نمونه عکس <a href="{{asset('app-assets/images/verification.jpeg')}}">اینجا</a> کلیک کنید.
                            @if(isset(Auth::user()->selfie_reason) && Auth::user()->selfie_img_confirm == 3)
                                <div class="alert m-1 bg-warning text-center alert-icon-left alert-dismissible mb-2" role="alert">
                            <span class="alert-icon">
                                <i class="ft-user-x"></i>
                            </span>
                                    تصویر به دلیل "{{Auth::user()->selfie_img_reason}}" متاسفانه تایید نشد.
                                </div>
                            @endif
                            <form id="selfieImg" method="POST" autocomplete="off" class="form-horizontal needs-validation text-center @if(isset(Auth::user()->selfie_img) == 0) dropzone @endif" novalidate action="profile/selfie" enctype="multipart/form-data">
                                @csrf
                                @if(isset(Auth::user()->selfie_img) && Auth::user()->selfie_img_confirm != 3)
                                    <img src="{{asset('')}}{{Auth::user()->selfie_img}}" width="350px">
                                @else
                                    <div class="fallback">
                                        <input type="file" id="selfie_img" name="selfie_img" accept="image/*" required>
                                    </div>
                                    <div class="dz-message needsclick">
                                        <div class="mb-3">
                                            <i class="display-4 text-muted bx bxs-cloud-upload"></i>
                                        </div>
                                        <h4>عکس سلفی را اینجا رها کنید یا برای بارگذاری کلیک کنید. </h4>
                                    </div>
                                @endif
                                <div class="progress w-100" style="display: none">
                                    <div class="progress-bar bg-primary progress-bar-striped progress-bar-animated" role="progressbar"
                                         aria-valuemax="100" style="width:0%">
                                        0%
                                    </div>
                                </div>
                                @if(Auth::user()->selfie_img_confirm == 0 || Auth::user()->selfie_img_confirm==3)
                                    <div class="col-md-12 m-auto text-center my-3">
                                        <button type="button" class="btn btn-primary selfieImg-start px-3">ارسال تصویر</button>
                                    </div>
                                @endif
                            </form>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card border
                        @if(isset(Auth::user()->phone))border-success
                        @else()border-danger
                        @endif">
                        <div class="card-body">
                            <div class="card-title mb-3">تلفن ثابت(صرفا برای افزایش سقف خرید)
                                <small class="ps-1">
                                    @if(isset(Auth::user()->phone))<span class="text-success"><i class="icon-check"></i> تایید شده</span>
                                    @else()<span class="text-danger">تایید نشده</span>
                                    @endif
                                </small>
                            </div>
                            <p class="text-small text-muted">
                                این بخش مربوط به احراز هویت نمیباشد و در صورت تمایل برای افزایش سقف خرید روزانه خود میتوایند تلفن ثابت را درج کنید و با تماس اتوماتیکی که صورت میگیرد تایید نمایید.
                            </p>
                            <form autocomplete="off" method="post" class="needs-validation mt-1 @if(isset(Auth::user()->phone)) disable-block @endif" id="address-ownership" novalidate action="profile/address-ownership">
                                @csrf
                                <div class="row">
                                    <div class="col-md-6 col-12 form-group mx-auto mb-3">
                                        <label for="firstName1">تلفن ثابت(اختیاری)</label>
                                        <input type="text" name="phone" id="phone" value="{{isset(Auth::user()->phone)? Auth::user()->phone: null}}"
                                               class="form-control numbers text-center ltr-dir"
                                               :readonly="ShowVerifyPhone ? true :false" v-model="phone"
                                               placeholder="تلفن 02123456789" maxlength="11" minlength="11" />
                                        <div class="invalid-feedback">تلفن خود را صحیح درج کنید</div>
                                        <small>به منظور افزایش سطح خرید روزانه میتوانید تلفن را تکمیل نمایید!</small>
                                    </div>
                                    <div class="w-100"></div>

                                    <transition name="slide">
                                        <div class="col-md-6 mx-auto form-group mb-3" v-if="ShowVerifyPhone" id="box_phone">
                                            <input type="text" class="form-control numbers text-center ltr-dir"
                                                   :required="ShowVerifyPhone ? true :false" v-model="verifyPhone"
                                                   maxlength="4" minlength="4" name="verify_phone" id="verify_phone" placeholder="کد تماس را درج کنید" >
                                            <div class="invalid-feedback">کد 4 رقمی تماس را درج نمایید</div>
                                        </div>
                                    </transition>

                                    @if(!isset(Auth::user()->phone))
                                        <div class="col-md-12 m-auto text-center">
                                            <button type="submit" class="btn btn-primary px-3">
                                                @{{ verifyPhone ? 'ثبت نهایی':'تایید تلفن'  }}
                                            </button>
                                        </div>
                                    @endif
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop

@section('js')
    <script src="{{asset('libs/dropzone/min/dropzone.min.js')}}"></script>
    <script src="{{asset('')}}app-assets/vendors/js/persian-date.min.js" type="text/javascript"></script>
    <script src="{{asset('')}}app-assets/vendors/js/persian-datepicker.min.js" type="text/javascript"></script>
    <script src="{{ asset('js/vue.min.js') }}"></script>
@stop

@section('script')
<script>

    Dropzone.autoDiscover = false;


    var url = $('meta[name=url]').attr("content");
    var csrf = $('meta[name=_token]').attr("content");

    const vm1 = new Vue({
        el: '#AppLocation',
        data: {
            ostan: '{{Auth::user()->id_province??''}}',
            city: '',
            phone: '{{Auth::user()->phone}}',
            cityList: [],
            ShowVerifyPhone: false,
            verifyPhone: null
        },
        methods: {
            LoadedCity: function () {
                fetch(url +"cities",
                    {
                        method: 'POST',
                        mode: 'cors',
                        cache: 'no-cache',
                        headers: {
                            'Content-Type': 'application/json',
                            'Connection': 'keep-alive',
                        },
                        body: JSON.stringify({_token: csrf , id: this.ostan})
                    }
                ).then(res => {
                    return res.json()
                })
                .then(data => {
                    this.city = '';
                    this.cityList = data;
                    if(this.ostan !=''){
                        this.city = '{{Auth::user()->id_city}}';
                    }
                });
            },
        },
        watch: {
            ostan: function () {
                this.LoadedCity()
            }
        },
        mounted() {
            if(this.ostan !=''){
                this.LoadedCity();
                this.city = '{{Auth::user()->id_city}}';
            }

        },
    })

    $('#DateBirth,#date1').attr( 'data-date',new persianDate().subtract('year', 20).format('YYYY/MM/DD'));

    $('#date1,#DateBirth').persianDatepicker({
        altField: '#DateBirth',
        initialValueType: 'persian',
        maxDate: new persianDate().subtract('year', 18).valueOf(),
        altFormat: 'YYYY/MM/DD',
        initialValue: false,
        viewMode: 'year',
        observer: true,
        autoClose: true,
        format: 'YYYY/MM/DD',
        toolbox:{
            enabled: false,
        },
        timePicker: {
            enabled: false,
            second:{
                enabled: false,
            }
        }
    });
    $(document).ready(function () {

        var nationalCard = new Dropzone(document.querySelector('#nationalCard'), {
            paramName: "auth_img",
            addRemoveLinks: true,
            autoProcessQueue: false,
            dictRemoveFile: "حذف تصویر",
            maxFiles: 1,
            init: function() {
                this.on('addedfile', function(file) {
                    if (this.files.length > 1) {
                        this.removeFile(this.files[0]);
                    }
                });
            },

            success: function (file, response) {
                file.previewElement.classList.add("dz-success");
                Swal.fire({
                    icon: 'success',
                    title: "انجام شد",
                    text: "مدارک شما با موفقیت ارسال شد. منتظر بررسی بمانید.",
                    acceptedFiles: ".jpeg,.jpg,.png,.gif",
                    confirmButtonText: "تایید",
                }).then(function () {
                    location.reload();
                });
            },
            error: function (file, response) {
                file.previewElement.classList.add("dz-error");
            }
        })
        $('.nationalCard-start').click(function () {
            nationalCard.processQueue();
        });


        var selfimg = new Dropzone(document.querySelector('#selfieImg'), {
            paramName: "selfie_img",
            addRemoveLinks: true,
            autoProcessQueue: false,
            dictRemoveFile: "حذف تصویر",
            maxFiles: 1,
            init: function() {
                this.on('addedfile', function(file) {
                    if (this.files.length > 1) {
                        this.removeFile(this.files[0]);
                    }
                });
            },

            success: function (file, response) {
                file.previewElement.classList.add("dz-success");
                Swal.fire({
                    icon: 'success',
                    title: "انجام شد",
                    text: "مدارک شما با موفقیت ارسال شد. منتظر بررسی بمانید.",
                    acceptedFiles: ".jpeg,.jpg,.png,.gif",
                    confirmButtonText: "تایید",
                }).then(function () {
                    location.reload();
                });
            },
            error: function (file, response) {
                file.previewElement.classList.add("dz-error");
            }
        });
        $('.selfieImg-start').click(function () {
            selfimg.processQueue();
        });


        (function () {
            var bar = $('#nationalCard .progress-bar');
            var percent = $('#nationalCard .progress-bar');
            $('#nationalCard').ajaxForm({
                beforeSend: function() {
                    $('#nationalCard .progress').fadeIn();
                    var percentVal = '0%';
                    bar.width(percentVal);
                    percent.html(percentVal);
                    $('#nationalCard button').attr('disabled','disabled');
                },
                uploadProgress: function(event, position, total, percentComplete) {
                    var percentVal = percentComplete + '%';
                    bar.width(percentVal);
                    percent.html(percentVal);
                },
                complete: function(data) {
                    data = data.responseJSON;
                    if (data.status == true) {
                        Swal.fire({
                            icon: 'success',
                            title: "انجام شد",
                            html: data.message,
                            confirmButtonText: "تایید",
                        }).then(function () {
                            location.reload();
                        });
                    } else {
                        $('#nationalCard .progress').fadeOut();
                        Swal.fire({
                            icon: 'error',
                            title: "خطا",
                            html: data.message,
                            confirmButtonText: "تایید",
                        })

                    }
                    $('#nationalCard button').removeAttr('disabled');
                }
            });
        })();
    });

    $(document).ready(function () {
        $('#address-ownership').ajaxForm({
            beforeSend: function(xhr, opts) {
                //loading();
                if (vm1.ShowVerifyPhone && vm1.verifyPhone.length < 4) {
                    xhr.abort();
                    return false;
                }
                ElementBlock('#address-ownership button');

            },
            complete: function(data) {
                data = data.responseJSON;
                //unloading();
                if (data.status == true) {
                    swal.fire({
                        icon: 'success',
                        title: "انجام شد",
                        html: data.message,
                        confirmButtonText: "تایید",
                    }).then(function () {
                        if (!vm1.ShowVerifyPhone && vm1.phone != ''){
                            vm1.ShowVerifyPhone = true;
                            $('#address-ownership button').html('تایید و ثبت نهایی');
                        }else
                            location.reload()
                    });
                } else {
                    swal.fire({
                        icon: 'error',
                        title: "توجه",
                        html: data.message,confirmButtonText: "تایید",
                    })
                    //$('#address-ownership button').html('تایید مشخصات');
                }
                ElementUnBlock('#address-ownership button');

            }
        });
    });

    $(document).ready(function () {
        (function () {
            var bar = $('#selfieImg .progress-bar');
            var percent = $('#selfieImg .progress-bar');
            $('#selfieImg').ajaxForm({
                beforeSend: function() {
                    $('#selfieImg .progress').fadeIn();
                    var percentVal = '0%';
                    bar.width(percentVal);
                    percent.html(percentVal);
                    ElementBlock('#selfieImg button');
                },
                uploadProgress: function(event, position, total, percentComplete) {
                    var percentVal = percentComplete + '%';
                    bar.width(percentVal);
                    percent.html(percentVal);
                },
                complete: function(data) {
                    data = data.responseJSON;
                    if (data.status == true) {
                        Swal.fire({
                            icon: 'success',
                            title: "انجام شد",
                            html: data.message,
                            confirmButtonText: "تایید",
                        }).then(function () {
                            location.reload();
                        });
                    } else {
                        $('#nationalCard .progress').fadeOut();
                        Swal.fire({
                            icon: 'error',
                            title: "خطا",
                            html: data.message,
                            confirmButtonText: "تایید",
                        })

                    }
                    ElementUnBlock('#selfieImg button');
                }
            });
        })();
    });


</script>
@stop
