@extends('user.layouts.master')
@section('title', 'نتیجه پرداخت')
@section('css')

@stop

@section('content')

<div class="app-content content">
    <div class="content-wrapper">
        <div class="content-header row">
        </div>
        <div class="content-body">


            <div class="row mb-4">
            <div class="col-md-11 mb-4 mx-auto">
                <div class="card o-hidden">

                    @if($result->status == true)
                        <div class="card-body text-center box-payment border-success">

                            <img src="{{asset('')}}app-assets/images/icons/success.png" width="130px">
                            <h2 class="mt-2">پرداخت با موفقیت انجام شد!</h2>
                            <div class="table-responsive">
                                <table class="table table-bordered col-md-8 mx-auto mt-3">
                                    <tbody>
                                    <tr>
                                        <th scope="row">موجودی</th>
                                        <td class="text-center">
                                            <span class="sans-serif"> {{number_format($result->user_finance->stock)}}</span> تومان
                                        </td>
                                    </tr>
                                    @if(isset($result->RefID))
                                        <tr>
                                            <th scope="row">کد پیگیری خرید</th>
                                            <td class="sans-serif text-center cursor-pointer">
                                                <span>{{$result->RefID}}</span>
                                            </td>
                                        </tr>
                                    @endif
                                    <tr>
                                        <th scope="row">تاریخ پرداخت</th>
                                        <td class="text-center">
                                            <span>{{$result->date}}</span>
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="btn-payment">
                                <a class="btn btn-primary round" href="{{asset('')}}">داشبورد</a>
                                <a class="btn btn-primary round" href="{{asset('')}}ticket">پشتیبانی</a>
                            </div>

                        </div>
                    @elseif($result->status == false)
                        <div class="card-body height-500 text-center box-payment">
                            <img src="{{asset('')}}app-assets/images/icons/error.png" width="130px">
                            <h3 class="mt-5">{!!$result->message!!}</h3>
                            <div class="btn-payment">
                                <a class="btn btn-primary round" href="{{asset('')}}">داشبورد</a>
                                <a class="btn btn-primary round" href="{{asset('')}}ticket">پشتیبانی</a>
                            </div>
                        </div>
                    @endif
                </div>
            </div>

        </div>
        </div>
    </div>
</div>
@stop

@section('js')

@stop

@section('script')
@stop
