@extends('user.layouts.master')
@section('title', 'واریز به کیف پول')
@section('css')

@endsection


@section('content')
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">واریز به کیف پول</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{asset('')}}">داشبورد</a></li>
                        <li class="breadcrumb-item active">واریز-کیف-پول</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    @if($result->count_card <= 0 )
        <div class="alert alert-card alert-danger w-100" role="alert">
            <i class="ft-alert-triangle"></i>
            هنوز کارت تایید شده ای ندارید و جهت مشاهده لیست کارت ها و وضعیت آنها به بخش <a href="{{asset('')}}profile/financial">اطلاعات مالی</a> در حساب کاربری خود مراجعه کنید
        </div>
    @endif
    <div class="row">
        <div class="col-xl-6">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex flex-wrap align-items-start">
                        <h5 class="card-title text-muted mb-3 me-2">کیف پول ریالی</h5>
                    </div>
                    <div class="d-flex flex-wrap">
                        <div>
                            <p class="text-muted mb-1">موجودی</p>
                            <div class="d-flex">
                                <h4 class="mb-3">{{number_format(Auth::user()->wallet)}}</h4>
                                <p class="text-muted">  تومان</p>
                            </div>
                            <p class="text-success mb-0"><span><i class="mdi mdi-arrow-top-right ms-1"></i></span></p>
                        </div>
                        <div class="ms-auto align-self-end">
                            <i class="bx bx-money display-4 text-light"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">شارژ کیف پول</h4>
                    <form id="wallet_increase" class="mt-2 needs-validation" novalidate action="" autocomplete="off" method="post">
                        @csrf
                        <div class="row mb-4">
                            <label class="col-sm-3 col-form-label">مبلغ</label>
                            <div class="col-sm-9">
                                <input type="number" max="50000000" id="amount" name="amount" class="form-control text-center ltr-dir" required placeholder="مبلغ به تومان">
                                <div class="invalid-feedback">مبلغ را درج کنید</div>
                            </div>
                        </div>
                        <div class="row mb-4">
                            <label class="col-sm-3 col-form-label">توضیحات اضافه</label>
                            <div class="col-sm-9">
                                <textarea rows="3" class="form-control text-center" id="description" name="description" maxlength="300"></textarea>
                            </div>
                        </div>
                        <div class="row justify-content-end">
                            <div class="col-sm-9">
                                <div>
                                    <button type="submit" class="btn btn-primary w-md">ثبت و پرداخت</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-xl-6">
            <div class="card">
                <div class="card-body">
                    <div class="card-title mb-1 pb-1 border-bottom"><i class="feather icon-info"></i> نکات و هشدارها </div>
                    <div class="text-14 pb-3 my-4">
                        <p>موجودی کیف پول به شما این امکان را می دهد تا در مواردی که درگاه بانکی مشکل دارد سریعتر خرید کنید و هر بار نیاز به وارد کردن اطلاعات حساب بانکی نباشد.</p>
                        <p>جهت استفاده از موجودی کیف پول در هنگام پرداخت فاکتور، می بایست گزینه پرداخت با «کیف پول» را انتخاب نمایید.</p>
                        <p>تنها زمانی می توانید از اعتبار کیف پول برای پرداخت فاکتور استفاده کنید که کیف پول شما موجودی کافی داشته باشد.</p>
                        <p>چنان چه کیف پول خود را توسط چندین کارت بانکی شارژ می کنید، به منظور جلوگیری از تأخیر در انجام سفارش، اطلاعات کارت بانکی خود را در بخش&nbsp;<a href="{{asset('')}}profile/financial" target="_blank">کارت های بانکی من</a> ثبت نمایید.</p>
                    </div>
                </div>
            </div>
            @if($result->count_card <= 0 )
                <div class="card border border-danger py-1">
                    <div class="card-header bg-transparent border-danger">
                        <h5 class="my-0 text-danger"><i class="mdi mdi-alert-outline me-3"></i>کارت بانکی تایید شده ندارید!</h5>
                    </div>
                    <div class="card-body">
                        <p class="card-text">شما کارت بانکی تایید شده ندارید و یا هنوز توسط مدیریت تایید نشده است. شما می توانید از بخش مالی نسبت به ثبت کارت بانکی اقدام نمایید.</p>
                        <a href="{{asset('')}}profile/financial" target="_blank" class="btn btn-outline-danger waves-effect waves-light">ثبت کارت بانکی</a>
                    </div>
                </div>
            @else
                <div class="card border border-success py-1">
                    <div class="card-header bg-transparent border-danger">
                        <h5 class="my-0 text-success"><i class="mdi mdi-check-all me-3"></i>کارت‌ بانکی ثبت شده</h5>
                    </div>
                    <div class="card-body">
                        <p class="card-text">شما هم اکنون کارت بانکی تایید شده دارید. همچنین شما می توانید با ثبت کارت های بانکی دیگر میزان شارژ حساب کاربری خود در طول روز را افزایش دهید.</p>
                        <a href="{{asset('')}}profile/financial" target="_blank" class="btn btn-outline-success waves-effect waves-light">مدیریت کارت‌های بانکی</a>
                    </div>
                </div>
            @endif
        </div>
    </div>
@stop
@section('js')

@stop

@section('script')
    <script>
        var CountCardBank = {{$result->count_card}};
        $(document).on('submit','#wallet_increase',function(e){
            e.preventDefault();
            if(CountCardBank <= 0 ){
                swal.fire({
                    icon: 'warning',
                    title: "امکان پذیر نیست",
                    html: 'شما هنوز کارت بانکی تاییده شده ای ندارید',
                    confirmButtonText: "تایید",
                })
                return false;
            }
            if($('#wallet_increase #amount').val().replace(/\,/g, '') < 1000){
                swal.fire({
                    icon: 'warning',
                    title: "توجه",
                    html: 'حداقل مبلغ قابل شارژ 1,000 تومان میباشد!',
                    confirmButtonText: "تایید",
                })
                return false;
            }

            this.submit();
        });
    </script>
@stop
