<?php $__env->startSection('title', 'کیف پول'); ?>
<?php $__env->startSection('css'); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">برداشت از کیف پول</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(asset('')); ?>">داشبورد</a></li>
                        <li class="breadcrumb-item active">واریز-کیف-پول</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <?php if($result->count_card <= 0 ): ?>
        <div class="alert alert-card alert-danger w-100" role="alert">
            <i class="ft-alert-triangle"></i>
            هنوز کارت تایید شده ای ندارید و جهت مشاهده لیست کارت ها و وضعیت آنها به بخش <a href="<?php echo e(asset('')); ?>profile/financial">اطلاعات مالی</a> در حساب کاربری خود مراجعه کنید
        </div>
    <?php endif; ?>
    <div class="row">
        <div class="col-xl-6">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex flex-wrap align-items-start">
                        <h5 class="card-title text-muted mb-3 me-2">کیف پول ریالی</h5>
                    </div>
                    <div class="d-flex flex-wrap">
                        <div>
                            <p class="text-muted mb-1">قابل برداشت</p>
                            <div class="d-flex">
                                <h4 class="mb-3"><?php echo e(number_format(Auth::user()->wallet)); ?></h4>
                                <p class="text-muted">  تومان</p>
                            </div>
                            <p class="text-danger mb-0"><span><i class="mdi mdi-arrow-bottom-right ms-1"></i></span></p>
                        </div>
                        <div class="ms-auto align-self-end">
                            <i class="bx bx-money display-4 text-light"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="alert alert-secondary alert-dismissible fade show" role="alert">
                <i class="mdi mdi-grease-pencil me-2"></i>
                حداقل مبلغ قابل برداشت <?php echo e(number_format($result->Withdraw_value_min)); ?> تومان است.
            </div>
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title mb-4">برداشت از کیف پول</h4>
                    <form id="wallet_decrement" class="mt-2 needs-validation" novalidate action="" autocomplete="off" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="row mb-4">
                            <label class="col-sm-3 col-form-label">مبلغ</label>
                            <div class="col-sm-9">
                                <input type="text" id="amount" name="amount" class="form-control text-center ltr-dir" required placeholder="مبلغ به تومان">
                                <div class="invalid-feedback">مبلغ را درج کنید</div>
                            </div>
                        </div>
                        <div class="row mb-4">
                            <label class="col-sm-3 col-form-label">کارت بانکی جهت واریز</label>
                            <div class="col-sm-9">
                                <select class="form-control" name="cardbank" id="cardbank" required="">
                                    <option value="" disabled="" selected="">کارت بانکی را انتخاب کنید</option>
                                    <?php $__currentLoopData = $result->cardbank; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cardbank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($cardbank->id); ?>"><?php echo e($cardbank->card_number); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <div class="invalid-feedback">کارت بانکی را انتخاب کنید </div>
                                <small class="mr-2">لیست کارت بانکی های تایید شده را مشاهده میکنید.
                                    <?php if(count($result->cardbank)==0): ?>
                                        <span class="text-danger">کارت بانکی تایید شده ای ندارید!</span>
                                    <?php endif; ?>
                                </small>
                            </div>
                        </div>
                        <div class="row mb-4">
                            <label class="col-sm-3 col-form-label">توضیحات اضافه</label>
                            <div class="col-sm-9">
                                <textarea rows="3" class="form-control text-center" id="description" name="description" maxlength="300"></textarea>
                            </div>
                        </div>
                        <div class="row justify-content-end">
                            <div class="col-sm-9">
                                <div>
                                    <button type="submit" class="btn btn-primary w-md">درخواست برداشت</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-xl-6">
            <div class="card">
                <div class="card-body">
                    <div class="card-title mb-1 pb-1 border-bottom"><i class="feather icon-info"></i> نکات و هشدارها </div>
                    <div class="text-14 pb-3 my-4">
                        <p>دقت نمایید پس از ثبت درخواست، امکان لغو درخواست وجود نداشته و وجه درخواستی بلافاصله از کیف پول شما کسر می گردد.</p>
                        <p>پس از ثبت، درخواست شما به واحد مالی اعلام شده و مبلغ درخواستی به حساب بانکی شما واریز خواهد شد.</p>
                        <p>برای پیگیری درخواست میتوانید به بخش تیکت ها و یا لیست تراکنش ها مراجعه کنید.</p>
                    </div>
                </div>
            </div>
            <?php if($result->count_card <= 0 ): ?>
                <div class="card border border-danger py-1">
                    <div class="card-header bg-transparent border-danger">
                        <h5 class="my-0 text-danger"><i class="mdi mdi-alert-outline me-3"></i>کارت بانکی تایید شده ندارید!</h5>
                    </div>
                    <div class="card-body">
                        <p class="card-text">شما کارت بانکی تایید شده ندارید و یا هنوز توسط مدیریت تایید نشده است. شما می توانید از بخش مالی نسبت به ثبت کارت بانکی اقدام نمایید.</p>
                        <a href="<?php echo e(asset('')); ?>profile/financial" target="_blank" class="btn btn-outline-danger waves-effect waves-light">ثبت کارت بانکی</a>
                    </div>
                </div>
            <?php else: ?>
                <div class="card border border-success py-1">
                    <div class="card-header bg-transparent border-danger">
                        <h5 class="my-0 text-success"><i class="mdi mdi-check-all me-3"></i>کارت‌ بانکی ثبت شده</h5>
                    </div>
                    <div class="card-body">
                        <p class="card-text">شما هم اکنون کارت بانکی تایید شده دارید. همچنین شما می توانید با ثبت کارت های بانکی دیگر میزان شارژ حساب کاربری خود در طول روز را افزایش دهید.</p>
                        <a href="<?php echo e(asset('')); ?>profile/financial" target="_blank" class="btn btn-outline-success waves-effect waves-light">مدیریت کارت‌های بانکی</a>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        var wallet = <?php echo e(Auth::user()->wallet); ?>;
        var Withdraw_value_min = <?php echo e($result->Withdraw_value_min); ?>;

        $(document).ready(function () {
            $('#wallet_decrement').ajaxForm({
                beforeSend: function (xhr, opts) {
                    if($('#wallet_decrement #amount').val().replace(/\,/g, '') < Withdraw_value_min){
                        Swal.fire({
                            icon: 'warning',
                            title: "توجه",
                            html: 'حداقل مبلغ قابل برداشت '+ addCommas(Withdraw_value_min) +' تومان میباشد!',
                            confirmButtonText: "تایید",
                        })
                        return false;
                        xhr.abort();
                    }
                    if($('#wallet_decrement #amount').val().replace(/\,/g, '') > wallet){
                        Swal.fire({
                            icon: 'warning',
                            title: "خطا",
                            html: 'مبلغ درخواستی از موجودی کیف پول شما بیشتر است ',
                            confirmButtonText: "تایید",
                        })
                        return false;
                        xhr.abort();
                    }
                    loading();
                },
                complete: function (data) {
                    data = data.responseJSON;
                    if (data.status == true) {
                        location.href = data.url;
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: "توجه",
                            html: data.message,
                            confirmButtonText: "تایید",
                        })

                    }
                    unloading();
                }
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/towinex/engine/resources/views/user/wallet/wallet-decrement.blade.php ENDPATH**/ ?>