<?php $__env->startSection('title', 'محصولات'); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">محصولات فروشگاه</h4>
            </div>
        </div>
    </div>
    <?php if(\Session::has('success')): ?>
        <div class="alert alert-success">
            <ul>
                <li><?php echo \Session::get('success'); ?></li>
            </ul>
        </div>
    <?php endif; ?>
    <div class="row">
        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between mb-4">
                    <div class="card-title">محصولات</div>
                    <div>
                        <a href="product-index" class="btn btn-light"><i class="mdi mdi-cart-arrow-right me-1"></i>اضافه کردن محصول جدید</a>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table align-middle mb-0 table-nowrap">
                        <thead class="table-light">
                        <tr>
                            <th>عکس محصول</th>
                            <th>نام محصول</th>
                            <th>دسته بندی</th>
                            <th>قیمت</th>
                            <th>تعداد فروش</th>
                            <th>درآمد فروش</th>
                            <th></th>
                        </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><img src="<?php echo e(asset($product->image)); ?>" alt="product-img" title="product-img" class="avatar-md" /></td>
                                    <td><h5 class="font-size-14 text-truncate"><?php echo e($product->title); ?></h5></td>
                                    <td><?php echo e($product->category != null ? $product->category['title'] : '-'); ?></td>
                                    <td><?php echo e(number_format($product->product_price)); ?><small class="ms-1">تومان</small></td>
                                    <td><?php echo e($product->sum_quantity != null ? $product->sum_quantity : '-'); ?></td>
                                    <td>
                                        <?php if(isset($product->sum_final_price)): ?>
                                            <?php echo e(number_format($product->sum_final_price - $product->sum_delivery_price)); ?>

                                            <small class="ms-1">تومان</small>
                                        <?php else: ?>
                                            -
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="d-flex gap-3">
                                            <a href="product-index?id=<?php echo e($product->id . '-' . $product->title); ?>" class="text-success"><i class="mdi mdi-pencil font-size-18"></i></a>
                                            <a class="text-danger pointer-event" onclick="remove(<?php echo e($product->id); ?>)"><i class="mdi mdi-delete font-size-18"></i></a>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        function remove(id){
            swal.fire({
                title: "از حدف اطمینان دارید؟",
                icon: "info",
                showCancelButton: true,
                showLoaderOnConfirm: true,
                confirmButtonText: "آره",
                confirmButtonColor: "#d22346",
                cancelButtonText: "نه",
                preConfirm: () => {
                    return $.ajax({
                        url: "<?php echo e(asset('').env('PanelPrefix')); ?>/product/" + id + "/delete",
                        type: 'DELETE',
                        data: {_token: "<?php echo e(csrf_token()); ?>", id:id},
                    });
                }
            }).then((data) => {
                if(data != undefined) {
                    if(data.value.status==true){
                        swal.fire({
                            title:'انجام شد!',
                            icon: 'success',
                            text: data.value.messege,
                        }).then(function () {
                            location.reload()
                        });
                    }
                    else{
                        swal("خطا",  data.value.messege  , "error");
                    }
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\arzlan\platform\resources\views/admin/shop/products.blade.php ENDPATH**/ ?>