<?php $__env->startSection('title', 'ثبت نام'); ?>

<?php $__env->startSection('head'); ?>
    <script src='https://www.google.com/recaptcha/api.js?hl=fa'></script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row justify-content-center">
        <div class="col-md-8 col-lg-6 col-xl-5">
            <div class="card overflow-hidden">
                <div class="row pt-5 pb-3 text-center">
                    <h3>ثبت نام</h3>
                </div>
                <div class="card-body pt-0">
                    <div class="text-center mb-1"><small>لطفا مطمئن شوید آدرس مرورگرتان منطبق با آدرس زیر باشد.</small></div>
                    <div class="text-center">
                        <span class="border border-1 py-1 px-4 rounded-pill">
                            <span class="text-success">https://</span><?php echo e(getSetting('app_url')); ?><i class="mdi mdi-lock font-size-16 text-success ms-1"></i>
                        </span>
                    </div>
                    <?php if(Session::has('Error')): ?>
                        <div class="alert alert-warning alert-dismissible" role="alert">
                            <i class="mdi mdi-alert-outline me-2"></i>
                            <?php echo e(Session::get('Error')); ?>

                            <button type="button" class="btn-close" data-dismiss="alert" aria-label="Close">
                            </button>
                        </div>
                    <?php endif; ?>
                    <div class="p-2">
                        <form class="needs-validation" id="login-form-block" novalidate  method="POST" autocomplete="off">
                            <?php echo csrf_field(); ?>
                            <div class="mb-3">
                                <label for="username" class="form-label">شماره موبایل</label>
                                <input type="text" class="form-control"
                                       required="required"
                                       name="mobile" id="mobile"
                                       maxlength="11" minlength="11"/>
                                <div class="invalid-feedback">
                                    شماره موبایل را بدرستی وارد کنید
                                </div>
                            </div>
                            <div class="form-group text-center">
                                <div class="g-recaptcha d-flex justify-content-center" data-sitekey="<?php echo e(env('NOCAPTCHA_SITEKEY')); ?>"></div>
                                <?php if($errors->has('g-recaptcha-response')): ?>
                                    <span class="invalid-feedback" style="display: block;">
                                        <strong><?php echo e($errors->first('g-recaptcha-response')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                            <div class="box_code mb-1" style="display:none ;">
                                <div class="auth-pass-inputgroup">
                                    <label class="form-label">شماره موبایل</label>
                                    <input type="text" class="form-control" id="code"
                                           maxlength="5" minlength="5" name="code" placeholder="کد 5 رقمی احراز هویت" >
                                    <div class="invalid-feedback">
                                        کد 5 رقمی را بدرستی درج کنید
                                    </div>
                                </div>
                                <div class="text-center">
                                    <a class="btn btn-light waves-effect btn-label waves-light my-2" id="makingdifferenttimer" style="display: none;" onclick="resend()">
                                        <i class="bx bx-message label-icon "></i> ارسال مجدد
                                    </a>
                                </div>
                                <div id="mdtimer" class="text-center">
                                    <a href="#" class="btn btn-light waves-effect my-2">
                                        <i class="bx bx-hourglass bx-spin font-size-16 align-middle me-2"></i> <span>59</span>
                                    </a>
                                </div>
                            </div>

                            <div class="mt-3 d-grid">
                                <button type="submit" class="btn btn-block btn-primary col-12 mr-1 mb-1"
                                        onclick="onSubmitform" id="BtnRegister">ثبت نام</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="mt-5 text-center">
                <div>
                    <p>قبلا ثبت نام کرده اید؟ <a href="<?php echo e(route('login')); ?>" class="fw-medium text-primary"> وارد شوید </a></p>
                    <p>© <script>document.write(new Date().getFullYear())</script> ساخته شده با <i class="mdi mdi-heart text-danger"></i> توسط تیم <?php echo e(getSetting('app_name_farsi')); ?></p>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script>
    function onSubmitform() {
        ElementBlock('form button')
        if ($("form:invalid").length == 1){
            $('form').addClass('was-validated');
            ElementUnBlock('form button');
        }
        else
            $('form').submit();
    }
    $(document).ready(function () {
        $('#login-form-block').ajaxForm({
            beforeSend: function() {

            },
            uploadProgress: function(event, position, total, percentComplete) {
            },
            complete: function(data) {
                data = data.responseJSON;
                if (data.status == true) {
                    if(data.redirect != null){
                        location.href = (data.redirect);
                        return false
                    }
                    Swal.fire({
                        icon: 'success',
                        title: "انجام شد",
                        html: data.message,
                        confirmButtonText: "تایید",
                    }).then(function () {
                    });
                    $('.box_code').slideDown();
                    $('#mobile').attr('readonly','readonly');
                    $('#code').attr('required','required');
                    $('form button').html('تایید کد');
                    timerResend()

                } else {
                    Swal.fire({
                        icon: 'warning',
                        title: "توجه",
                        html: data.message,
                        confirmButtonText: "تایید",
                    })
                }
                ElementUnBlock('#BtnRegister');
            }
        });


    });

    function resend() {

        ElementBlock('#makingdifferenttimer');
        $.post("<?php echo e(Route('ResendSmsRegister')); ?>",{_token: "<?php echo e(csrf_token()); ?>" },
            function(data){
                if(data.status == true){
                    toastr.success(data.message, "انجام شد!", {
                        positionClass: "toast-bottom-center",
                        progressBar: !0,
                    });

                }else{
                    toastr.error(data.message, "خطا!", {
                        positionClass: "toast-bottom-center",
                        progressBar: !0,
                    })
                }
                timerResend();
                ElementUnBlock('#makingdifferenttimer');
            });
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.login.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/towinex/engine/resources/views/user/auth/register.blade.php ENDPATH**/ ?>