<?php $__env->startSection('title', 'کارت های بانکی'); ?>
<?php $__env->startSection('css'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">کارت‌های بانکی</h4>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="card col-12">
            <div class="card-body">
                <div class="d-flex justify-content-between mb-4">
                    <div class="card-title mb-0">کارت‌های بانکی</div>
                </div>
                <div class="col-md-12">
                    <div class="row justify-content-between">
                        <div class="col-md-3">
                            <a class="btn btn-light mb-3" href="javascript:window.print()"><i class="mdi mdi-printer font-size-14"></i>پرینت اطلاعات صفحه</a>
                        </div>
                        <div class="col-md-3 d-flex">
                            <input type="text" id="myInput" class="form-control mb-3 bg-light me-2" onkeyup="myFunction()" placeholder="جست و جو کنید ...">
                        </div>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table align-middle mb-0 table-nowrap" id="myTable">
                        <thead class="table-light">
                        <tr>
                            <th>شناسه</th>
                            <th>نام کاربر</th>
                            <th>شماره کارت</th>
                            <th>شماره حساب</th>
                            <th>نام بانک</th>
                            <th>زمان ثبت</th>
                            <th>وضعیت</th>
                            <th>جزییات</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $cardbanks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cardbank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($cardbank->id); ?></td>
                                <td><?php echo e($cardbank->name.' '.$cardbank->family); ?></td>
                                <td><?php echo e($cardbank->card_number); ?></td>
                                <td><?php echo e($cardbank->account_number); ?></td>
                                <td><?php echo e($cardbank->bank_name); ?></td>
                                <td><?php echo e($cardbank->created_at); ?></td>
                                <td>
                                    <?php if($cardbank->confirm == 0): ?>
                                        <span class="badge badge-soft-warning">منتظر تایید</span>
                                    <?php elseif($cardbank->confirm == 1): ?>
                                        <span class="badge badge-soft-success">تایید شده</span>
                                    <?php else: ?>
                                    <span class="badge badge-soft-danger">تایید نشده</span>
                                    <?php endif; ?>
                                </td>
                                <td><a class="btn btn-light" href="<?php echo e(asset('').env('PanelPrefix')); ?>/users/<?php echo e($cardbank->id_user); ?>">مشاهده</a></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table><?php echo e($cardbanks->links()); ?>

                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/towinex/engine/resources/views/admin/cardbank.blade.php ENDPATH**/ ?>