<div class="row">
    <div class="col-lg-4 col-md-12 col-12">
        <div class="card o-hidden">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                        <tr>
                            <th scope="col">عنوان</th>
                            <th scope="col">مقدار</th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <th scope="row">تعداد سفارشات</th>
                            <td><?php echo e($result->CountOrders); ?></td>
                        </tr>
                        <tr>
                            <th scope="row">مبلغ سفارشات</th>
                            <td><?php echo e(number_format($result->AmountOrders)); ?></td>
                        </tr>
                        <tr>
                            <th scope="row">تعداد فروش</th>
                            <td><?php echo e(($result->CountOrdersSell)); ?></td>
                        </tr>
                        <tr>
                            <th scope="row">مبلغ فروش</th>
                            <td><?php echo e(number_format($result->AmountOrdersSell)); ?></td>
                        </tr>
                        <tr>
                            <th scope="row">تعداد خرید</th>
                            <td><?php echo e(($result->CountOrdersBuy)); ?></td>
                        </tr>
                        <tr>
                            <th scope="row">مبلغ خرید</th>
                            <td><?php echo e(number_format($result->AmountOrdersBuy)); ?></td>
                        </tr>
                        <tr>
                            <th scope="row">کاربر جدید</th>
                            <td><?php echo e(($result->CountUser)); ?></td>
                        </tr>
                        <tr>
                            <th scope="row">مبلغ بیشترین فروش</th>
                            <td><?php echo e(number_format($result->AmountMaxSell)); ?></td>
                        </tr>
                        <tr>
                            <th scope="row">مبلغ بیشترین خرید</th>
                            <td><?php echo e(number_format($result->AmountMaxBuy)); ?></td>
                        </tr>
                        <tr>
                            <th scope="row">تعداد معرفی ها</th>
                            <td><?php echo e(isset($result->UserInvitation) ? $result->UserInvitation : 0); ?></td>
                        </tr>
                        <tr>
                            <th scope="row">تعداد کارت های ثبت شده</th>
                            <td><?php echo e(isset($result->CardBank) ? $result->CardBank : 0); ?></td>
                        </tr>
                        <tr>
                            <th scope="row">تیکت های ایجاد شده</th>
                            <td><?php echo e(isset($result->Ticket) ? $result->Ticket : 0); ?></td>
                        </tr>
                        <tr>
                            <th scope="row">تراکنش های کیف پول</th>
                            <td><?php echo e(isset($result->Finance) ? $result->Finance : 0); ?></td>
                        </tr>
                        <tr>
                            <th scope="row">مبلغ و تعداد برداشت از کیف پول</th>
                            <td>(<?php echo e(isset($result->FinanceIncCount) ? $result->FinanceIncCount : 0); ?>)
                                - <?php echo e(isset($result->FinanceIncAmount) ? number_format($result->FinanceIncAmount): 0); ?></td>
                        </tr>
                        <tr>
                            <th scope="row">مبلغ و تعداد واریز به کیف پول</th>
                            <td>(<?php echo e(isset($result->FinanceDecCount) ? $result->FinanceDecCount : 0); ?>)
                                - <?php echo e(isset($result->FinanceDecAmount) ? number_format($result->FinanceDecAmount): 0); ?></td>
                        </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>


    <div class="col-lg-8 col-md-12 col-12">
        <div class="card o-hidden">
            <div class="card-body">
                <ul class="nav nav-tabs" id="myTab" role="tablist">
                    <?php $i = 0; $j = rand(0,1) ?>
                    <?php $__currentLoopData = $result->Currencys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="nav-item">
                            <a class="nav-link <?php if($i==$j): ?>active <?php endif; ?>" style="padding: 10px" id="<?php echo e($Currency); ?>-tab"
                               data-bs-toggle="tab" href="#<?php echo e($Currency); ?>" role="tab" aria-controls="<?php echo e($Currency); ?>"
                               aria-selected="true">
                                <img src="<?php echo e(asset('')); ?>app-assets/images/currency/<?php echo e($Currency); ?>.svg" style="width: 35px;">
                            </a>
                        </li>
                        <?php $i++; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <div class="tab-content pb-0" id="myTabContent">
                    <?php $i = 0; ?>
                    <?php $__currentLoopData = $result->Currencys; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="tab-pane fade show <?php if($i==$j): ?>active <?php endif; ?>" id="<?php echo e($Currency); ?>" role="tabpanel"
                             aria-labelledby="<?php echo e($Currency); ?>-tab">
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead>
                                    <tr>
                                        <th scope="col"> ارز: <?php echo e($Currency); ?>


                                        </th>
                                        <th scope="col">تعداد سفارشات</th>
                                        <th scope="col">مبلغ سفارشات</th>
                                        <th scope="col">تعداد خریدها</th>
                                        <th scope="col">تعداد فروش ها</th>
                                        <th scope="col">مبلغ کل خریدها</th>
                                        <th scope="col">مبلغ کل فروش ها</th>
                                        <th scope="col">بیشترین خرید</th>
                                        <th scope="col">بیشترین فروش</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <th scope="row">مقدار</th>
                                        <td><?php echo e($result->$Currency->CountOrders); ?></td>
                                        <td><?php echo e($result->$Currency->AmountOrders); ?></td>
                                        <td><?php echo e($result->$Currency->CountOrdersBuy); ?></td>
                                        <td><?php echo e(($result->$Currency->CountOrdersSell)); ?></td>
                                        <td><?php echo e(number_format($result->$Currency->AmountOrdersBuy)); ?>

                                            ($<?php echo e($result->$Currency->dollarBuy); ?>)
                                        </td>
                                        <td><?php echo e(number_format($result->$Currency->AmountOrdersSell)); ?>

                                            ($<?php echo e($result->$Currency->dollarSell); ?>)
                                        </td>
                                        <td>
                                            <a href="<?php echo e(asset('').env('PanelPrefix')); ?>/orders/<?php echo e($result->$Currency->IDMaxBuy); ?>"><?php echo e(number_format($result->$Currency->AmountMaxBuy)); ?></a>
                                        </td>
                                        <td>
                                            <a href="<?php echo e(asset('').env('PanelPrefix')); ?>/orders/<?php echo e($result->$Currency->IDMaxSell); ?>"><?php echo e(number_format($result->$Currency->AmountMaxSell)); ?></a>
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>


                            </div>
                        </div>
                        <?php $i++; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>

            </div>
        </div>

        <div class="card o-hidden">
            <div class="card-body">
                <div class="card-title">نمودار وضعیت سیستم</div>
                <div class="height-400">
                    <canvas id="area-chart"></canvas>
                </div>
            </div>
        </div>

    </div>


    <div class="col-md-6">
        <div class="card">
            <div class="card-body">
                <div class="card-title">نمودار ارز ها</div>
                <div class="height-300">
                    <canvas id="polar-chart"></canvas>
                </div>
            </div>
        </div>
    </div>

    <div class="col-md-6">
        <div class="card">
            <div class="card-body">
                <div class="card-title">نمودار طریقه سفارش</div>
                <div class="height-300">
                    <canvas id="stackedPie"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>


<script>
    $('[data-toggle="tooltip"]').tooltip();


            var o = $("#area-chart");
            new Chart(o, {
                    type: "line", options: {
                        responsive: !0, maintainAspectRatio: !1,
                        legend: {
                            position: "bottom",
                            labels: {
                                fontSize: 14,
                                fontFamily: 'Vazir-FD',
                            }
                        }
                        , hover: {
                            mode: "label"
                        }
                        , scales: {
                            xAxes: [{
                                display: !0, gridLines: {
                                    color: "#f3f3f3", drawTicks: !0
                                }
                                , scaleLabel: {
                                    display: !1, labelString: "ماه", fontFamily: 'Vazir-FD'
                                },
                                ticks: {
                                    fontFamily: 'Vazir-FD',

                                }
                            }
                            ], yAxes: [{
                                display: !0, gridLines: {
                                    color: "#f3f3f3", drawTicks: !1
                                }
                                , scaleLabel: {
                                    display: !0, labelString: "مقدار", fontFamily: 'Vazir-FD'
                                }
                            }
                            ]
                        }
                        , title: {
                            display: !1, text: "نمودار خط Chart.js - افسانه"
                        },
                        tooltips: {
                            titleFontFamily: 'Vazir-FD',
                            bodyFontFamily: 'Vazir-FD',
                            titleMarginBottom: 10,
                            titleSpacing: 10
                        }
                    }
                    , data: {
                        labels: [<?php $__currentLoopData = $result->Label_CL; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> "<?php echo e($label); ?>", <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>],
                        datasets: [{
                            label: "کاربر جدید",
                            data: [<?php $__currentLoopData = $result->UserAdd_CL; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <?php echo e($value); ?> , <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>]
                            ,
                            backgroundColor: "rgba(209,212,219,.4)",
                            borderColor: "transparent",
                            pointBorderColor: "#D1D4DB",
                            pointBackgroundColor: "#FFF",
                            pointBorderWidth: 2,
                            pointHoverBorderWidth: 2,
                            pointRadius: 4
                        }
                            , {
                                label: "مبلغ خرید(میلیون تومان)",
                                data: [<?php $__currentLoopData = $result->AmountBuy; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <?php echo e($value); ?> , <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>]
                                ,
                                backgroundColor: "rgba(255,113,103,0.6)",
                                borderColor: "transparent",
                                pointBorderColor: "#e01b07",
                                pointBackgroundColor: "#FFF",
                                pointBorderWidth: 2,
                                pointHoverBorderWidth: 2,
                                pointRadius: 4
                            }
                            , {
                                label: "مبلغ فروش(میلیون تومان)",
                                data: [<?php $__currentLoopData = $result->AmountSell; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <?php echo e($value); ?> , <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>]
                                ,
                                backgroundColor: "rgba(0,43,255,0.6)",
                                borderColor: "transparent",
                                pointBorderColor: "#5175E0",
                                pointBackgroundColor: "#FFF",
                                pointBorderWidth: 2,
                                pointHoverBorderWidth: 2,
                                pointRadius: 4
                            }

                        ]
                    }
                }
            )

            var a = $("#polar-chart");
            new Chart(a, {
                    type: "pie",
                    options: {

                        responsive: !0, maintainAspectRatio: !1, responsiveAnimationDuration: 500,
                        legend: {
                            position: "right",
                            labels: {
                                fontSize: 14,
                                fontFamily: 'Vazir-FD',
                            }
                        },
                        tooltips: {
                            titleFontFamily: 'Vazir-FD',
                            bodyFontFamily: 'Vazir-FD',
                            titleMarginBottom: 10,
                            titleSpacing: 10
                        }
                    }
                    , data: {
                        labels: [<?php $__currentLoopData = $result->PieCurrencyOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Chart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> "<?php echo e($Chart->orders_model); ?>", <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>],
                        datasets: [{
                            data: [<?php $__currentLoopData = $result->PieCurrencyOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Chart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>  <?php echo e($Chart->amount); ?> , <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>],

                            backgroundColor: ["#fe9403", "#252525", "#009ddf", "#e6381c", "#aa1a03", "#fecc00", '#00cebe', '#7f2371', '#53ae94', '#106db3'],
                        }
                        ]
                    }
                }
            )

            var a = $("#stackedPie");
            new Chart(a, {
                    type: "polarArea", options: {
                        responsive: !0, maintainAspectRatio: !1, responsiveAnimationDuration: 500, legend: {
                            position: "top"
                        }
                        , title: {
                            display: !1, text: "Chart.js نمودار منطقه قطبی"
                        }
                        , scale: {
                            ticks: {
                                beginAtZero: !0
                            }
                            , reverse: !1
                        }
                        , animation: {
                            animateRotate: !1
                        }
                    }
                    , data: {
                        labels: [<?php $__currentLoopData = $result->PieCurrencyVia; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Chart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> "<?php echo e($Chart->via); ?>", <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>], datasets: [{
                            data: [<?php $__currentLoopData = $result->PieCurrencyVia; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Chart): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php echo e($Chart->count); ?> , <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>],
                            backgroundColor: ["#639", "#63845", "#ebcb37", "#a1b968", "#0d94bc", "#135bba"]
                        }
                        ]
                    }
                }
            )

</script>
<?php /**PATH E:\arzlan\platform\resources\views/admin/reports/load.blade.php ENDPATH**/ ?>