<?php $__env->startSection('title', 'تیکت ها'); ?>

<?php $__env->startSection('content'); ?>
    <div class="d-lg-flex">
        <div class="chat-leftsidebar me-lg-4">
            <div class="">
                <div class="py-4 border-bottom">
                    <div class="d-flex">
                        <div class="flex-shrink-0 align-self-center me-3">
                            <img src="<?php echo e(asset('images/users/user.png')); ?>" class="avatar-xs rounded-circle" alt="">
                        </div>
                        <div class="flex-grow-1">
                            <h5 class="font-size-15 mb-1"><?php echo e(Auth::user()->name .' '.Auth::user()->family); ?></h5>
                            <p class="text-muted mb-0"><i class="mdi mdi-circle text-success align-middle me-1"></i>آنلاین</p>
                        </div>
                    </div>
                </div>
                <div class="chat-leftsidebar-nav">
                    <ul class="nav nav-pills nav-justified">
                        <button type="button" data-bs-toggle="modal" data-bs-target=".bs-example-modal-lg" class="nav-link active">
                            <span class="">تیکت جدید</span>
                        </button>
                    </ul>
                    <div class="tab-content py-4">
                        <div class="tab-pane show active" id="chat">
                            <div class="bg-white p-3">
                                <h5 class="font-size-14 mb-3">آخرین تیکت‌ها</h5>
                                <ul class="list-unstyled chat-list" data-simplebar style="max-height: 410px;">
                                    <?php if(count($tickets)>0): ?>
                                        <?php $__currentLoopData = $tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li class="">
                                                <a href="<?php echo e(asset('')); ?>ticket/<?php echo e($ticket->id); ?>">
                                                    <div class="d-flex">
                                                        <div class="flex-shrink-0 align-self-center me-3">
                                                            <?php if($ticket->seen_user == 1 ): ?>
                                                                <i class="mdi mdi-circle font-size-10" data-bs-toggle="tooltip" data-bs-placement="bottom" title="خوانده شده"></i>
                                                            <?php else: ?>
                                                                <i class="mdi mdi-circle text-success font-size-10" data-bs-toggle="tooltip" data-bs-placement="bottom" title="خوانده نشده"></i>
                                                            <?php endif; ?>
                                                        </div>
                                                        <div class="flex-shrink-0 align-self-center me-3">
                                                            <img src="<?php echo e(asset('images/users/user.png')); ?>" class="rounded-circle avatar-xs" alt="">
                                                        </div>
                                                        <div class="flex-grow-1 overflow-hidden">
                                                            <h5 class="text-truncate font-size-14 mb-1"><?php echo e($ticket->title); ?></h5>
                                                            <p class="text-truncate mb-0 me-3"><?php echo e($ticket->unit); ?></p>
                                                            <small class="text-truncate mb-0">تاریخ ایجاد: <?php echo e($ticket->created_at); ?></small>
                                                            <small class="text-truncate mb-0">تاریخ ایجاد: <?php echo e($ticket->updated_at); ?></small>
                                                        </div>
                                                        <div class="font-size-11">
                                                            <?php if($ticket->status == 0): ?>
                                                                <td><span class="badge badge-soft-warning">منتظر پاسخ</span></td>
                                                            <?php elseif($ticket->status == 1): ?>
                                                                <td><span class="badge badge-soft-success">پاسخ داده شده</span></td>
                                                            <?php else: ?>
                                                                <td><span class="badge badge-soft-danger">بسته</span></td>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </a>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        شما هیچ تیکت ثبت شده‌ای در سایت ندارید
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="w-100 user-chat d-none d-md-block">
            <div class="card">
                <div>
                    <div class="chat-conversation p-3 d-flex">
                        <img class="mt-5 mx-auto" src="<?php echo e(asset('images/no-ticket.svg')); ?>" width="300px">
                    </div>
                    <div class="text-center mb-5">
                        <p class="text-truncate mb-0 me-3">یک تیکت را برای نمایش انتخاب کنید</p>
                    </div>
                    <div class="p-3 chat-input-section">
                        <div class="row">
                            <div class="col">
                                <div class="position-relative">
                                    <input type="text" class="form-control chat-input" placeholder="متن پاسخ تیکت ..." disabled>
                                    <div class="chat-input-links" id="tooltip-container">
                                        <ul class="list-inline mb-0">
                                            <li class="list-inline-item"><a href="#" title="Images"><i class="mdi mdi-file-image-outline"></i></a></li>
                                            <li class="list-inline-item"><a href="#" title="Add Files"><i class="mdi mdi-file-document-outline"></i></a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-auto">
                                <button type="submit" class="btn btn-primary btn-rounded chat-send w-md waves-effect waves-light"><i class="mdi mdi-send"></i>  <span class="d-none d-sm-inline-block me-2">ارسال</span></button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade bs-example-modal-lg" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="myLargeModalLabel">ثبت درخواست جدید</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form autocomplete="off" method="post" class="needs-validation" novalidate action="" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row col-md-7 col-12 m-md-auto m-0 p-0 mt-2">
                            <div class="col-lg-6 m-0 p-0 ps-md-1 form-group mb-2">
                                <label for="firstName1">موضوع</label>
                                <input type="text" class="form-control" name="subject" id="subject" placeholder="موضوع خود را درج کنید" required>
                                <div class="invalid-feedback">موضوع خود را انتخاب کنید</div>
                            </div>
                            <div class="col-lg-6 p-0 pl-0 ps-md-1 form-group mb-2">
                                <label for="picker1">واحد</label>
                                <select class="form-control" name="unit" id="unit" required>
                                    <option value='' disabled selected>واحد را انتخاب کنید</option>
                                    <option value="پیگیری سفارش">پیگیری سفارش</option>
                                    <option value="احراز هویت">احراز هویت</option>
                                    <option value="مالی">مالی</option>
                                    <option value="سایر">سایر</option>
                                </select>
                                <div class="invalid-feedback">واحد را انتخاب کنید</div>
                            </div>
                            <div class="col-md-12 p-0 form-group mb-2">
                                <label for="picker1">در خصوص سفارش</label>
                                <select class="form-control" name="order" id="order">
                                    <option value="">هیچ کدام</option>
                                    <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($order->id); ?>"><?php echo e($order->detail->type .' '. $order->detail->title .' ('.$order->detail->amount_dollar.$order->detail->dollar.') ' .$order->date); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="col-md-12 p-0 form-group mb-2">
                                <label for="phone">توضیحات</label>
                                <textarea rows="5"  name="message" id="message" required class="form-control" placeholder="پیغام خود را درج کنید"></textarea>
                                <div class="invalid-feedback">پیغام خود را درج کنید</div>
                            </div>

                            <div class="col-md-12 p-0 form-group mb-2">
                                <label for="credit1">فایل پیوست</label>
                                <fieldset class="form-group">
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="file" id="file" accept="image/*,.doc,.docx,.pdf,application/zip,.rar">
                                        <label class="custom-file-label" for="file">انتخاب فایل</label>
                                    </div>
                                </fieldset>
                                <small>پسوندهای مجاز: jpg, jpeg, png, pdf, doc, docx, zip, rar</small>
                                <small class="text-left mr-3">حداکثر حجم فایل 5 مگابایت</small>
                            </div>

                            <div class="progress mb-2 w-100" style="display:none ">
                                <div class="progress-bar bg-info progress-bar-striped progress-bar-animated" role="progressbar"
                                     aria-valuemax="100" style="width:0%">
                                    0%
                                </div>
                            </div>
                            <div class="col-md-6 m-auto">
                                <button type="submit" class="btn btn-block btn-primary">ثبت درخواست</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        $(document).ready(function () {
            // bind 'myForm' and provide a simple callback function
            var bar = $('.progress-bar');
            var percent = $('.progress-bar');

            $('form').ajaxForm({
                beforeSend: function (xhr, opts) {
                    if($('#file').val()!=""){
                        var file = $('#file')[0].files[0];
                        if(file.size>=5300000) {
                            swal.fire({
                                type: 'warning',
                                title: "انجام شد",
                                title: "توجه",
                                html: 'حداکثر مجاز حجم فایل 5 مگابایت است.',
                                confirmButtonText: "تایید",
                            });
							xhr.abort();
                            return false
                        }
                    }
                    $('form button').attr('disabled','disabled');
                    $('form').addClass('disable-block');

                    if($('#file').val()!="")
                        $('.progress').fadeIn();

                    var percentVal = '0%';
                    bar.css('width',percentVal+'%');
                    percent.html(percentVal);
                },
                uploadProgress: function (event, position, total, percentComplete) {
                    var percentVal = percentComplete-3 + '%';
                    bar.width(percentVal);
                    percent.html(percentVal);
                },
                complete: function (data) {
                    bar.css('width','100%');
                    percent.html(100);

                    data = data.responseJSON;
                    $('form').removeClass('disable-block');
                    if (data.status == true) {
                        swal.fire({
                            type: 'success',
                            icon: 'success',
                            title: "انجام شد",
                            html: data.message,
                            confirmButtonText: "تایید",
                            onClose: () => {
                                location.href= "<?php echo e(asset('')); ?>ticket/"+data.id;
                            }
                        });
                    } else {
                        swal.fire({
                            type: 'warning',
                            icon: 'warning',
                            title: "توجه",
                            html: data.message,
                            confirmButtonText: "تایید",
                        })
                        $('.progress').fadeOut();
                    }
                    $('form button').removeAttr('disabled');
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\arzlan\platform\resources\views/user/ticket.blade.php ENDPATH**/ ?>