<?php $__env->startSection('title', 'جزییات سفارش'); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">جزییات سفارش <?php echo e($order->product->title ?? ' '); ?></h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="<?php echo e(asset('')); ?>product-orders">سفارشات فروشگاه</a></li>
                        <li class="breadcrumb-item active">فاکتور</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="card border">
                <?php if( isset($order) ): ?>
                    <div class="card-body">
                        <div class="invoice-title">
                            <h4 class="float-end font-size-16">شماره سفارش <?php echo e($order->id); ?>#</h4>
                            <div class="mb-4">
                                <img src="<?php echo e(asset('images/logo/logo-dark.svg')); ?>" alt="logo" height="20"/>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <p class="text-center">اطلاعاتی که در این صفحه میبینید متعلق به این سفارش می باشد</p>
                            <div class="col-sm-12">
                                <div class="my-2">
                                    <strong>تاریخ ثبت:</strong>
                                    <?php echo e($order->date); ?>

                                </div>
                                <div class="my-2">
                                    <?php if( in_array($order->status, ['payment_confirm', 'done'])): ?>
                                        <strong>مبلغ پرداخت شده:</strong>
                                        <?php echo e(number_format($order->final_price)); ?> تومان
                                    <?php elseif( $order->status == 'payment-pending'): ?>
                                        <strong>مبلغ قابل پرداخت :</strong>
                                        <?php echo e(number_format($order->final_price)); ?> تومان
                                    <?php endif; ?>
                                </div>
                                <div class="my-2">
                                    <strong>وضعیت:</strong>
                                    <?php if( $order->status == 'payment-confirm' ): ?>
                                        <span class="badge badge-pill badge-soft-success font-weight-light">پرداخت موفق</span>
                                    <?php elseif( $order->status == 'payment-pending' ): ?>
                                        <span class="badge badge-pill badge-soft-warning font-weight-light">در انتظار پرداخت</span>
                                    <?php elseif( $order->status == 'payment-cancel' ): ?>
                                        <span class="badge badge-pill badge-soft-danger font-weight-light">پرداخت ناموفق</span>
                                    <?php elseif( $order->status == 'done' ): ?>
                                        <span class="badge badge-pill badge-soft-success font-weight-light">تکمیل شده</span>
                                    <?php elseif( $order->status == 'cart' ): ?>
                                        <span class="badge badge-pill badge-soft-warning font-weight-light">سبد خرید</span>
                                    <?php elseif( $order->status == 'canceled' ): ?>
                                        <span class="badge badge-pill badge-soft-danger font-weight-light">لغو شده</span>
                                    <?php endif; ?>
                                </div>
                                <div class="my-2">
                                    <?php if( $order->payment_method == 'wallet' ): ?>
                                        <strong>پرداخت از طریق:</strong>
                                        <span>کیف پول</span>
                                    <?php endif; ?>
                                </div>
                                <div class="my-4">
                                    <span class="mb-3">مشخصات خریدار:</span>
                                    <div class="table-responsive">
                                        <table class="table align-middle table-nowrap table-hover">
                                            <thead class="table-light">
                                            <tr>
                                                <th scope="col" style="width: 70px;">#</th>
                                                <th scope="col">نام و نام خانوادگی</th>
                                                <th scope="col">شماره تماس</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td>
                                                        <div class="avatar-xs">
                                                            <img src="<?php echo e(asset('images/users/user.png')); ?>" width="30px">
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <h5 class="font-size-14 mb-1"><?php echo e($order->user->name . ' ' . $order->user->family); ?></h5>
                                                    </td>
                                                    <td><?php echo e($order->user->mobile); ?></td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="py-2 mt-3">
                            <h3 class="font-size-15 fw-bold">جزئیات سفارش</h3>
                        </div>
                        <p>فهرست محصولات / خدمات درخواستی</p>
                        <div class="table-responsive">
                            <table class="table table-bordered">
                                <thead class="">
                                <tr>
                                    <th class="text-center">#</th>
                                    <th class="text-center w-60">نام محصول</th>
                                    <th class="text-center">مقدار / تعداد</th>
                                    <th class="text-center">قیمت واحد</th>
                                    <th class="text-center">قیمت ارسال</th>
                                    <th class="text-center">مبلغ کل</th>
                                </tr>
                                </thead>
                                <tbody class="text-center">
                                <tr>
                                    <td scope="row" class="sans-serif">1</td>
                                    <td><?php echo e($order->product_title); ?></td>
                                    <td><?php echo e($order->quantity); ?></td>
                                    <td><?php echo e(number_format($order->price)); ?></td>
                                    <td><?php echo e($order->delivery_price ? number_format($order->delivery_price) : 'رایگان'); ?></td>
                                    <td><?php echo e(number_format($order->final_price)); ?> تومان</td>
                                </tr>
                                <tr class="border-0">
                                    <th class="border-0"></th>
                                </tr>
                                <tr>
                                    <td class="border-0"></td>
                                    <th scope="row">توضیحات بخش پشتیبانی</th>
                                    <td colspan="4" class="sans-serif">
                                        <span><?php echo e($order->admin_note ?? '-'); ?></span>
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="d-print-none">
                            <div class="float-end">
                                <a href="javascript:window.print()" class="btn btn-success waves-effect waves-light me-1"><i class="fa fa-print"></i></a>
                                <a href="<?php echo e(asset('')); ?>product-orders" class="btn btn-light w-md waves-effect waves-light">بازگشت به سفارشات</a>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\arzlan\platform\resources\views/user/ecommerce/order-detail.blade.php ENDPATH**/ ?>