<?php $__env->startSection('title', 'اطلاعات مالی'); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-xl-3">
            <?php echo $__env->make('user.profile.profile-detail', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php if(count($card)>0): ?>
                <div class="card border border-success">
                    <div class="card-header bg-transparent border-success">
                        <span class="my-0 text-success"><i class="mdi mdi-check-all me-3"></i>شما دارای حساب بانکی تایید شده می باشید.</span>
                    </div>
                </div>
            <?php else: ?>
                <div class="card border border-danger">
                    <div class="card-header bg-transparent border-danger">
                        <span class="my-0 text-danger"><i class="mdi mdi-alert me-3"></i>حساب بانکی تایید شده ای ندارید!</span>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <div class="col-xl-9">
            <?php echo $__env->make('user.profile.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="card">
                <div class="card-body">
                    <p class="">جهت دریافت خدمات و سرویس های وب سایت به صورت آنی، می بایست شماره کارت بانکی که خرید را توسط آن انجام می دهید ثبت نمایید.
                    <form autocomplete="off" method="post" action=""  class="needs-validation" novalidate >
                        <?php echo csrf_field(); ?>
                        <div class="row col-md-9 col-12 m-md-auto m-0 p-0 mt-2">
                            <div class="col-md-6 form-group mb-3">
                                <label>نام بانک</label>
                                <select name="bank_name" id="bank_name" required class="form-control text-center">
                                    <option value="" disabled hidden selected>انتخاب کنید</option>
                                    <option value="بانک ملی">بانک ملی</option>
                                    <option value="بانک ملت">بانک ملت</option>
                                    <option value="بانک مسکن">بانک مسکن</option>
                                    <option value="بانک آینده">بانک آینده</option>
                                    <option value="بانک صادرات">بانک صادرات</option>
                                    <option value="بانک کشاورزی">بانک کشاورزی</option>
                                    <option value="بانک سامان">بانک سامان</option>
                                    <option value="بانک پارسیان">بانک پارسیان</option>
                                    <option value="بانک پاسارگاد">بانک پاسارگاد</option>
                                    <option value="بانک دی">بانک دی</option>
                                    <option value="بانک رسالت">بانک رسالت</option>
                                    <option value="بانک شهر">بانک شهر</option>
                                    <option value="بانک سرمایه">بانک سرمایه</option>
                                    <option value="بانک اقتصاد نوین">بانک اقتصاد نوین</option>
                                    <option value="بانک انصار">بانک انصار</option>
                                    <option value="بانک تجارت">بانک تجارت</option>
                                    <option value="بانک ایران زمین">بانک ایران زمین</option>
                                    <option value="سایر">سایر</option>
                                </select>
                                <div class="invalid-feedback"> بانک را انتخاب کنید</div>
                            </div>
                            <div class="col-md-6 form-group mb-3">
                                <label>شماره کارت</label>
                                <input type="text" class="form-control text-center numbers ltr-dir" name="card_number" maxlength="16" minlength="16" placeholder="شماره کارت" required>
                                <div class="invalid-feedback">شماره کارت بصورت صحیح درج شود</div>
                            </div>
                            <div id="box-shaba" class="w-100" style="">
                                <div class="row">
                                    <div class="col-md-6 form-group mb-3">
                                        <label>شماره حساب</label>
                                        <input type="text" class="form-control text-center numbers ltr-dir" name="account_number" required maxlength="16" minlength="9" placeholder="شماره حساب" >
                                        <div class="invalid-feedback">شماره حساب درج شود</div>
                                    </div>
                                    <div class="col-md-6 form-group mb-3">
                                        <label>شماره شبا بدون IR</label>
                                        <input type="text" class="form-control text-center numbers ltr-dir" name="iban" required maxlength="24" minlength="24" placeholder="شماره شبا بدون IR" >
                                        <div class="invalid-feedback">شماره شبا درج شود</div>
                                    </div>
                                </div>
                            </div>
                            <div class="d-flex justify-content-center">
                                <button type="submit" class="btn btn-primary">ثبت کارت</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead class="thead-default">
                            <tr>
                                <th class="text-center ">#</th>
                                <th class="text-center">بانک</th>
                                <th class="text-center">شماره کارت</th>
                                <th class="text-center">شماره حساب</th>
                                <th class="text-center">شبا</th>
                                <th class="text-center">وضعیت</th>
                            </tr>
                            </thead>
                            <tbody class="text-center font-size-small">
                            <?php $i=1 ?>
                            <?php if(count($card)>0): ?>
                                <?php $__currentLoopData = $card; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $card): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td scope="row" class="sans-serif"><?php echo e($i); ?></td>
                                        <td><?php echo e($card->bank_name); ?></td>
                                        <td class="text-11 sans-serif" ><?php echo e($card->card_number); ?></td>
                                        <td class="text-10 sans-serif" ><?php echo e($card->account_number ?? '-----'); ?></td>
                                        <td class="text-10 sans-serif"><?php echo e($card->shaba?? '-----'); ?></td>

                                        <?php if($card->confirm == 0): ?>
                                            <td><span class="badge badge-soft-warning">منتظر تایید</span></td>
                                        <?php elseif($card->confirm == 1): ?>
                                            <td><span class="badge badge-soft-success">تایید شده</span></td>
                                        <?php else: ?>
                                            <td><span class="badge badge-soft-danger">تایید نشده</span></td>
                                        <?php endif; ?>

                                    </tr>
                                    <?php $i++ ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="6" scope="row">هیچ کارت بانکی ثبت نشده است</td>
                                </tr>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $(document).ready(function() {
            $('form').ajaxForm({
                beforeSend: function() {
                    ElementBlock('form button');
                },
                uploadProgress: function(event, position, total, percentComplete) {
                },
                complete: function(data) {
                    data = data.responseJSON;
                    if (data.status == true) {
                        Swal.fire({
                            icon: 'success',
                            title: "انجام شد",
                            html: data.message,
                            confirmButtonText: "تایید",
                        }).then(function () {
                            location.reload();
                        });
                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: "خطا",
                            html: data.message,
                            confirmButtonText: "تایید",
                        })
                    }
                    ElementUnBlock('form button');
                }
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/towinex/engine/resources/views/user/profile/financial.blade.php ENDPATH**/ ?>